/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml.access;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import rabbit.data.access.model.IPerspectiveData;
import rabbit.data.access.model.WorkspaceStorage;
import rabbit.data.internal.access.model.PerspectiveData;
import rabbit.data.internal.xml.IDataStore;
import rabbit.data.internal.xml.access.AbstractAccessor;
import rabbit.data.internal.xml.schema.events.EventListType;
import rabbit.data.internal.xml.schema.events.PerspectiveEventListType;
import rabbit.data.internal.xml.schema.events.PerspectiveEventType;

public class PerspectiveDataAccessor
extends AbstractAccessor<IPerspectiveData, PerspectiveEventType, PerspectiveEventListType> {
    @Inject
    PerspectiveDataAccessor(@Named(value="PerspectiveStore") IDataStore store) {
        super(store);
    }

    @Override
    protected IPerspectiveData createDataNode(LocalDate date, WorkspaceStorage ws, PerspectiveEventType t) throws Exception {
        Duration duration = new Duration(t.getDuration());
        return new PerspectiveData(date, ws, duration, t.getPerspectiveId());
    }

    @Override
    protected Collection<PerspectiveEventListType> getCategories(EventListType t) {
        return t.getPerspectiveEvents();
    }

    @Override
    protected Collection<PerspectiveEventType> getElements(PerspectiveEventListType list) {
        return list.getPerspectiveEvent();
    }
}

