/* ***********************************************************/
/* Copyright (c) 2001,2011 by Progress Software Corporation  */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/

/* getdescription.p - Eclipse get description */

DEFINE INPUT  PARAMETER cPrm   AS CHARACTER  NO-UNDO. 
DEFINE VARIABLE fieldval AS CHARACTER NO-UNDO. 
DEFINE VARIABLE tableval AS CHARACTER NO-UNDO.

DEFINE VARIABLE cDB      AS CHARACTER NO-UNDO.
cDb = ENTRY(1,cPrm,".").
IF ENTRY(2,cPrm,".") = "" THEN 
DO:
    RETURN "Database: " + cDB + ".".
END.
ELSE IF ENTRY(3,cPrm,".") = "" THEN 
    DO:
        FIND FIRST OEIDE_DICTDB._file WHERE OEIDE_DICTDB._file._file-name = ENTRY(2,cPrm,".") NO-ERROR.
        ASSIGN 
            tableval = "DB-Table: " + cDB + "." + OEIDE_DICTDB._file._file-name + "~n" + OEIDE_DICTDB._file._desc NO-ERROR.
        IF tableval EQ "" THEN 
        DO:
            ASSIGN 
                tableval = " This table doesn't exist. ~n Refresh Cache(CTRL+R) to sync with database.".
        END.
        RETURN  tableval.
    END.
    ELSE 
    DO:
        FIND OEIDE_DICTDB._file WHERE OEIDE_DICTDB._file._file-name = ENTRY(2,cPrm,".") NO-ERROR.
        IF ENTRY(4,cPrm,".") EQ "" THEN 
        DO:
            FIND OEIDE_DICTDB._field OF OEIDE_DICTDB._file WHERE OEIDE_DICTDB._field._field-name = ENTRY(3,cPrm,".") NO-ERROR.
            ASSIGN 
                fieldval = "DB-Field: " + cDB + "." + OEIDE_DICTDB._file._file-name + "." + OEIDE_DICTDB._field._field-name 
        + "~n" + OEIDE_DICTDB._field._data-type + " " + OEIDE_DICTDB._field._format  
        + "~n" + OEIDE_DICTDB._field._desc NO-ERROR.
            IF fieldval EQ "" THEN 
            DO:
                ASSIGN 
                    fieldval = " This field doesn't exist. ~n Refresh Cache(CTRL+R) to sync with database.".
            END.	
            RETURN fieldval.
        END.
        ELSE IF ENTRY(4,cPrm,".") EQ "INDEX" THEN 
            DO:
                DEFINE VARIABLE indexDesc AS CHARACTER NO-UNDO.
                FIND OEIDE_DICTDB._index OF OEIDE_DICTDB._file  WHERE OEIDE_DICTDB._index._index-Name = ENTRY(3,cPrm,".") NO-ERROR.
                indexDesc = "DB-Index: " + cDB + "." + OEIDE_DICTDB._file._file-name + "." + OEIDE_DICTDB._index._index-Name.
                FOR EACH OEIDE_DICTDB._index-field OF OEIDE_DICTDB._index WHERE OEIDE_DICTDB._index._index-Name = ENTRY(3,cPrm,"."):
                    FOR EACH OEIDE_DICTDB._field OF OEIDE_DICTDB._index-field:
                        indexDesc = indexDesc + "~n" + OEIDE_DICTDB._field._field-name.
                        IF  OEIDE_DICTDB._index-field._ascending EQ YES THEN
                            indexDesc = indexDesc + "(A)".
                    END.
                END. 
                RETURN indexDesc.
            END. 
    END.

