/* ***********************************************************/
/* Copyright (c) 2005 by Progress Software Corporation       */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/

/*
    this code handles connections to database
*/
  DEFINE INPUT PARAMETER cPrm AS CHARACTER  NO-UNDO.
  DEFINE NEW GLOBAL SHARED VARIABLE OEIDE_Context    AS HANDLE NO-UNDO.

  function getServerDirectory returns character (  ) in OEIDE_Context.
  function getProjectWorkDirectory returns character 	(  ) in OEIDE_Context.

  DEFINE VARIABLE params        AS CHARACTER   NO-UNDO.
  DEFINE VARIABLE dname         AS CHARACTER   NO-UNDO.
  DEFINE VARIABLE dbalias       AS CHARACTER   NO-UNDO.

  DEFINE VARIABLE i1            AS INTEGER     NO-UNDO.
  DEFINE VARIABLE cStatus       AS CHARACTER   NO-UNDO.
  DEFINE VARIABLE ErrorLogFile  AS CHARACTER   NO-UNDO.


  ErrorLogFile = getProjectWorkDirectory() + "/error.log".

  cPrm = TRIM(cPrm).
  DO i1 = 1 to NUM-ENTRIES(cPrm) BY 3:
    ASSIGN
    	dName = TRIM(ENTRY(i1, cPrm))
    	dbalias = TRIM(ENTRY(i1 + 1, cPrm))
    	params = TRIM(ENTRY(i1 + 2,cPrm))
    	params = REPLACE(params, ";", ",").

	CONNECTBLOCK:
	  DO ON STOP  UNDO, LEAVE CONNECTBLOCK
	     ON QUIT  UNDO, LEAVE CONNECTBLOCK
	     ON ERROR UNDO, LEAVE CONNECTBLOCK:
		OUTPUT TO VALUE(ErrorLogFile) UNBUFFERED.
		CONNECT VALUE(params) NO-ERROR.
		OUTPUT CLOSE.
	END.
	IF ERROR-STATUS:ERROR OR ERROR-STATUS:GET-MESSAGE(1) > "" THEN
		cStatus = ERROR-STATUS:GET-MESSAGE(1).
	ELSE DO:
		RUN VALUE(getServerDirectory() + "_idecreatealias.p") (dName, dbalias) NO-ERROR.
		IF ERROR-STATUS:ERROR THEN
			cStatus = RETURN-VALUE.
		ELSE
			cStatus = "OK".

	END.
  END.
  RETURN cStatus.
