/* ***********************************************************/
/* Copyright (c) 1984-2016 by Progress Software Corporation  */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/
/*  File:        _idegetcrc                                  */
/*  Description: Retrieves the CRC-VALUE of the specified    */
/*		   file                                        */
/*  Parameters:  cFile  The relative file name               */
/*  Author:      Don S. Bulua                                */
/*************************************************************/

    DEFINE INPUT  PARAMETER cFile AS CHARACTER  NO-UNDO.
    DEFINE NEW GLOBAL SHARED VARIABLE OEIDE_Context    AS HANDLE NO-UNDO.
    function getProjectWorkDirectory returns character 	(  ) in OEIDE_Context.
    
    DEFINE VARIABLE crc_val        AS INTEGER     NO-UNDO.
    DEFINE VARIABLE cReturn        AS CHARACTER   NO-UNDO.
    DEFINE VARIABLE CompileTempDir AS CHARACTER   NO-UNDO. 
    DEFINE VARIABLE cRName         AS CHARACTER   NO-UNDO.
    DEFINE VARIABLE cPrefix		   AS CHARACTER   NO-UNDO.
    
    DEFINE SHARED VARIABLE cLinkedResources  AS CHARACTER.
   
    CompileTempDir = getProjectWorkDirectory() + "/../".

    COMPILE VALUE(cFile) SAVE INTO VALUE(CompileTempDir) NO-ERROR.

    IF NOT COMPILER:ERROR THEN
    DO:
       ASSIGN  RCODE-INFORMATION:FILENAME = cFile
               crc_val = RCODE-INFORMATION:crc-value
              NO-ERROR.
       cReturn = STRING(crc_val).
    END.
    ELSE
      cReturn = "ERROR:" + ERROR-STATUS:GET-MESSAGE(1).
    
    RUN adecomm/_osprefx.p (INPUT cFile, OUTPUT cPrefix, OUTPUT cRName).
    IF R-INDEX(cRName, ".p") = (LENGTH(cRName) - 1) THEN DO:
    	cRName = SUBSTRING(cRName, 1, LENGTH(cRName) - 1) + "r".
    END.
    
    cRName = CompileTempDir + cRName.
    
    OS-DELETE VALUE(cRName) NO-ERROR.
    
    
    RETURN cReturn.
	
		
