/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.java.oea.plugins.querygenerator;

import com.proalpha.java.oea.plugins.querygenerator.Variable;
import com.proalpha.java.oea.plugins.querygenerator.VariableParser;
import java.util.Scanner;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorTools {
    private static EditorTools editorTools = null;

    private EditorTools() {
    }

    public static EditorTools getInstance() {
        if (editorTools == null) {
            editorTools = new EditorTools();
        }
        return editorTools;
    }

    public void insertText(String insertString) {
        this.insertText(this.getActiveEditor(), insertString);
    }

    public String getSelectionText() {
        return this.getSelectionText(this.getActiveEditor());
    }

    public String getSelectionText(ITextEditor editor) {
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            return textSelection.getText();
        }
        return "";
    }

    public void insertText(ITextEditor editor, String insertString) {
        if (editor != null) {
            IDocumentProvider documentProvider = editor.getDocumentProvider();
            IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
            ISelectionProvider selectionProvider = editor.getSelectionProvider();
            ISelection selection = selectionProvider.getSelection();
            if (selection instanceof ITextSelection) {
                try {
                    ITextSelection textSelection = (ITextSelection)selection;
                    int line = textSelection.getStartLine();
                    int selectionOffset = textSelection.getOffset();
                    int indentation = selectionOffset - document.getLineOffset(line);
                    insertString = this.indent(insertString, indentation, 1);
                    VariableParser variableParser = new VariableParser(insertString);
                    variableParser.parse();
                    insertString = variableParser.getResultText();
                    document.replace(selectionOffset, textSelection.getLength(), insertString);
                    Variable[] variables = variableParser.getVariables();
                    if (variables.length > 0) {
                        ITextViewer viewer = (ITextViewer)editor.getAdapter(ITextOperationTarget.class);
                        LinkedModeModel model = new LinkedModeModel();
                        int posCount = 0;
                        int exitPosition = selectionOffset + insertString.length();
                        int i = 0;
                        while (i < variables.length) {
                            switch (variables[i].getVariableType()) {
                                case CURSOR_POS: {
                                    exitPosition = selectionOffset + variables[i].getOffset();
                                    break;
                                }
                                default: {
                                    LinkedPositionGroup group = new LinkedPositionGroup();
                                    group.addPosition(new LinkedPosition(document, selectionOffset + variables[i].getOffset(), variables[i].getLength()));
                                    model.addGroup(group);
                                    ++posCount;
                                }
                            }
                            ++i;
                        }
                        if (posCount == 0) {
                            editor.selectAndReveal(exitPosition, 0);
                        } else {
                            model.forceInstall();
                            LinkedModeUI ui = new LinkedModeUI(model, viewer);
                            ui.setExitPosition(viewer, exitPosition, 0, Integer.MAX_VALUE);
                            ui.enter();
                        }
                    }
                }
                catch (BadLocationException e) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    MessageDialog.openInformation((Shell)window.getShell(), (String)"QueryGenerator", (String)e.getMessage());
                }
            }
        }
    }

    private ITextEditor getActiveEditor() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        return (ITextEditor)editorPart.getAdapter(ITextEditor.class);
    }

    private String indent(String text, int spaceCount, int skipLines) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        Scanner scanner = new Scanner(text);
        int lineNo = 1;
        while (scanner.hasNextLine()) {
            if (lineNo > 1) {
                stringBuilder.append(lineSeparator);
            }
            if (lineNo > skipLines) {
                int i = 0;
                while (i < spaceCount) {
                    stringBuilder.append(" ");
                    ++i;
                }
            }
            stringBuilder.append(scanner.nextLine());
            ++lineNo;
        }
        scanner.close();
        return stringBuilder.toString();
    }
}

