/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.util;

import com.proalpha.pds.jaxb.DsDSConsistencyChecks;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.program.Program;

public class SendCheckInfoEmail {
    private String objectID = "";
    private String checkID = "";
    private String subCheckID = "";
    private String lastUser = "";
    private String description = "";
    private String srcStatement = "";
    private String line = "";
    private String reported;

    public void send(ISelection selection, String paProjectName) {
        Iterator it = ((IStructuredSelection)selection).iterator();
        StringWriter body = new StringWriter();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
                DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc entrySrc = (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)object;
                this.setObjectID(entrySrc.getSourceFileName());
                this.setCheckID(entrySrc.getDSCheckID());
                this.setSubCheckID(entrySrc.getDSSubCheckID());
                this.setLastUser(entrySrc.getLastUser());
                this.setReported(entrySrc.getReportedFirst());
                this.setSrcStatement(entrySrc.getStatement());
                this.setLine(entrySrc.getSourceFileLine());
                this.setDescription(entrySrc.getLogEntryDescription());
            } else if (object instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos entryRepos = (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)object;
                this.setObjectID(entryRepos.getOwningID());
                this.setCheckID(entryRepos.getDSCheckID());
                this.setSubCheckID(entryRepos.getDSSubCheckID());
                this.setLastUser(entryRepos.getLastUser());
                this.setReported(entryRepos.getReportedFirst());
                this.setSrcStatement("");
                this.setLine(0);
                this.setDescription(entryRepos.getLogEntryDescription());
            }
            this.appendLine(body, this.getLastUser());
            this.appendLine(body, this.getReported());
            this.appendLine(body, this.getObjectID());
            this.appendLine(body, this.getLine());
            this.appendLine(body, "");
            this.appendLine(body, this.getDescription());
            this.appendLine(body, "");
            this.appendLine(body, this.getSrcStatement());
        }
        String subject = String.valueOf(paProjectName) + " : " + this.getSubCheckID() + " (" + this.getCheckID() + ")";
        String mailto = "mailto:?subject=" + this.enc(subject) + "&body=" + this.enc(body.toString());
        Program.launch((String)mailto);
    }

    private void appendLine(StringWriter body, String str) {
        body.append(str).append(System.lineSeparator());
    }

    private String enc(String p) {
        if (p == null) {
            p = "";
        }
        try {
            return URLEncoder.encode(p, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    private String getDescription() {
        return this.description;
    }

    private String getLastUser() {
        return this.lastUser;
    }

    private String getLine() {
        return this.line;
    }

    private String getObjectID() {
        return this.objectID;
    }

    private String getReported() {
        return this.reported;
    }

    private String getSrcStatement() {
        return this.srcStatement;
    }

    private String getSubCheckID() {
        return this.subCheckID;
    }

    private String getCheckID() {
        return this.checkID;
    }

    private void setDescription(String description) {
        this.description = "Description:\t" + System.lineSeparator() + description;
    }

    private void setLastUser(String lastUser) {
        this.lastUser = "Last User:\t" + lastUser;
    }

    private void setLine(Integer line) {
        if (line != null) {
            this.line = "Line:\t\t" + String.valueOf(line);
        }
    }

    private void setObjectID(String objectID) {
        this.objectID = "Object:\t\t" + objectID;
    }

    private void setReported(XMLGregorianCalendar calendar) {
        this.reported = "Reported:\t" + calendar.getDay() + "." + calendar.getMonth() + "." + calendar.getYear();
    }

    private void setSrcStatement(String srcStatement) {
        this.srcStatement = "Code Fragment: " + System.lineSeparator() + srcStatement;
    }

    private void setSubCheckID(String subCheckID) {
        this.subCheckID = subCheckID;
    }

    private void setCheckID(String checkID) {
        this.checkID = checkID;
    }
}

