/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.checks;

import com.proalpha.pds.checks.CheckFilter;
import com.proalpha.pds.checks.CheckTreeView;
import com.proalpha.pds.checks.ConsistencyChecksImageProvider;
import com.proalpha.pds.jaxb.DsDSConsistencyChecks;
import com.proalpha.pds.util.SendCheckInfoEmail;
import java.io.File;
import java.net.URL;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SubCheckView
extends ViewPart
implements ISelectionListener {
    public static final String ID = "com.proalpha.pds.checks.SubCheckView";
    private FormToolkit toolkit;
    private Form form;
    private Text lastUser;
    private Text reported;
    private Text objectID;
    private Text line;
    private Text module;
    private Text description;
    private TableViewer viewer;
    private Text codeFragment;
    private ConsistencyChecksImageProvider imageProvider = new ConsistencyChecksImageProvider();
    private String selectedProjectName;
    private CheckFilter filter;
    private Image mailImage;

    public void dispose() {
        if (this.mailImage != null) {
            this.mailImage.dispose();
        }
        super.dispose();
    }

    private void clearDetailSection() {
        this.setLastUser("");
        this.setReported("");
        this.setObjectID("");
        this.setLine("");
        this.setModule("");
        this.setDescription("");
        this.setCodeFragment("");
    }

    private void clearTableSection() {
        if (!this.viewer.getTable().isDisposed()) {
            this.viewer.getTable().removeAll();
            this.viewer.setInput(null);
            this.viewer.refresh(true);
            this.setPartName("Consistency Subchecks");
            this.setTitleImage(this.imageProvider.getDefaultImage());
        }
    }

    private void createDetailSection() {
        Section sectionDetails = this.toolkit.createSection(this.form.getBody(), 258);
        sectionDetails.setText("Details");
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        sectionDetails.setLayout((Layout)layout);
        sectionDetails.setLayoutData((Object)new GridData(768));
        sectionDetails.setExpanded(true);
        Composite compositeDetails = this.toolkit.createComposite((Composite)sectionDetails);
        compositeDetails.setLayout((Layout)layout);
        sectionDetails.setClient((Control)compositeDetails);
        this.toolkit.createLabel(compositeDetails, "Last User");
        this.toolkit.createLabel(compositeDetails, "Reported");
        this.toolkit.createLabel(compositeDetails, "Line");
        this.toolkit.createLabel(compositeDetails, "Module");
        this.lastUser = this.toolkit.createText(compositeDetails, "");
        this.lastUser.setLayoutData((Object)new GridData(768));
        this.reported = this.toolkit.createText(compositeDetails, "");
        this.reported.setLayoutData((Object)new GridData(768));
        this.line = this.toolkit.createText(compositeDetails, "");
        this.line.setLayoutData((Object)new GridData(768));
        this.module = this.toolkit.createText(compositeDetails, "");
        this.module.setLayoutData((Object)new GridData(768));
        this.toolkit.createLabel(compositeDetails, "Object");
        this.toolkit.createLabel(compositeDetails, "Description");
        this.toolkit.createLabel(compositeDetails, "Code Fragment");
        this.toolkit.createLabel(compositeDetails, "");
        this.objectID = this.toolkit.createText(compositeDetails, "", 66);
        GridData objectIDData = new GridData(768);
        objectIDData.horizontalSpan = 1;
        objectIDData.heightHint = 100;
        objectIDData.widthHint = 100;
        objectIDData.horizontalAlignment = 4;
        this.objectID.setLayoutData((Object)objectIDData);
        GridData descData = new GridData(768);
        descData.horizontalSpan = 1;
        descData.heightHint = 100;
        descData.horizontalAlignment = 4;
        this.description = this.toolkit.createText(compositeDetails, "", 578);
        this.description.setLayoutData((Object)descData);
        this.codeFragment = this.toolkit.createText(compositeDetails, "", 2);
        GridData codeFragmentData = new GridData(768);
        codeFragmentData.horizontalSpan = 2;
        codeFragmentData.heightHint = 100;
        codeFragmentData.horizontalAlignment = 4;
        this.codeFragment.setLayoutData((Object)codeFragmentData);
        this.codeFragment.setFont(JFaceResources.getFont((String)"Courier New"));
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        GridLayout formLayout = new GridLayout();
        formLayout.numColumns = 1;
        this.form.getBody().setLayout((Layout)formLayout);
        this.form.getBody().setLayoutData((Object)new GridData(1808));
        IToolBarManager toolBarMgr = this.getViewSite().getActionBars().getToolBarManager();
        toolBarMgr.update(true);
        this.createTableSection();
        this.createDetailSection();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    private void createTableSection() {
        Section sectionTable = this.toolkit.createSection(this.form.getBody(), 4096);
        sectionTable.setExpanded(true);
        sectionTable.setLayout((Layout)new GridLayout());
        GridData sectionTableData = new GridData(1808);
        sectionTableData.minimumHeight = 100;
        sectionTable.setLayoutData((Object)sectionTableData);
        Composite compositeTable = this.toolkit.createComposite((Composite)sectionTable);
        compositeTable.setLayout((Layout)new GridLayout());
        compositeTable.setLayoutData((Object)new GridData(1808));
        sectionTable.setClient((Control)compositeTable);
        this.viewer = new TableViewer(compositeTable, 66306);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.configureTable(table);
        table.addListener(3, event -> {
            TableItem item = table.getItem(new Point(event.x, event.y));
            if (item == null) {
                table.deselectAll();
                this.clearDetailSection();
            }
        });
        Menu tableContextMenu = new Menu((Control)table);
        table.setMenu(tableContextMenu);
        MenuItem sendAsMailMenuItem = new MenuItem(tableContextMenu, 0);
        sendAsMailMenuItem.setText("Send as Mail");
        this.mailImage = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/images/mail.png")).createImage();
        sendAsMailMenuItem.setImage(this.mailImage);
        table.addListener(35, event -> {
            if (table.getSelectionCount() <= 0) {
                event.doit = false;
            }
        });
        sendAsMailMenuItem.addListener(13, event -> {
            SendCheckInfoEmail mail = new SendCheckInfoEmail();
            String projectName = this.selectedProjectName != null ? this.selectedProjectName : "Unknown project";
            mail.send(this.viewer.getSelection(), projectName);
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                block6: {
                    IProject selectedProject;
                    TableViewer viewer = (TableViewer)event.getSource();
                    IStructuredSelection el = (IStructuredSelection)viewer.getSelection();
                    Object elem = el.getFirstElement();
                    if (elem instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc && SubCheckView.this.selectedProjectName != null && (selectedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(SubCheckView.this.selectedProjectName)) != null) {
                        String sourceFileName = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)elem).getSourceFileName();
                        File projectFile = selectedProject.getRawLocation().makeAbsolute().toFile();
                        File fileToOpen = SubCheckView.this.searchFile(new File(projectFile.toPath().toAbsolutePath() + "\\src"), sourceFileName);
                        if (fileToOpen != null && fileToOpen.exists() && fileToOpen.isFile()) {
                            IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            try {
                                IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                                if (!(editor instanceof ITextEditor)) break block6;
                                IDocumentProvider provider = ((ITextEditor)editor).getDocumentProvider();
                                IDocument document = provider.getDocument((Object)editor.getEditorInput());
                                int start = 0;
                                try {
                                    start = document.getLineOffset(((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)elem).getSourceFileLine() - 1);
                                }
                                catch (BadLocationException e) {
                                    e.printStackTrace();
                                }
                                ((ITextEditor)editor).selectAndReveal(start, 0);
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    SubCheckView.this.updateDetailSection(((IStructuredSelection)selection).getFirstElement());
                }
            }
        });
        this.filter = new CheckFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
    }

    private File searchFile(File file, String search) {
        if (file.isDirectory()) {
            File[] arr;
            File[] fileArray = arr = file.listFiles();
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                File found = this.searchFile(f, search);
                if (found != null) {
                    return found;
                }
                ++n2;
            }
        } else if (file.getName().equals(search)) {
            return file;
        }
        return null;
    }

    private void configureTable(Table table) {
        TableColumn lastUserColumn = this.createTableColumn(table, "Last User");
        TableColumn reportedColumn = this.createTableColumn(table, "Reported");
        TableColumn objectColumn = this.createTableColumn(table, "Object");
        TableColumn lineColumn = this.createTableColumn(table, "Line");
        TableColumn moduleColumn = this.createTableColumn(table, "Module");
        TableColumn descriptionColumn = this.createTableColumn(table, "Description");
        TableViewerColumn column1 = new TableViewerColumn(this.viewer, lastUserColumn);
        column1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String resultText = super.getText(element);
                if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element).getLastUser();
                } else if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)element).getLastUser();
                }
                return resultText;
            }
        });
        TableViewerColumn column2 = new TableViewerColumn(this.viewer, reportedColumn);
        column2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String resultText = super.getText(element);
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                GregorianCalendar calendar = null;
                if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
                    calendar = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element).getReportedFirst().toGregorianCalendar();
                } else if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    calendar = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)element).getReportedFirst().toGregorianCalendar();
                }
                if (calendar != null) {
                    dateFormat.setTimeZone(calendar.getTimeZone());
                    resultText = dateFormat.format(calendar.getTime());
                }
                return resultText;
            }
        });
        TableViewerColumn column3 = new TableViewerColumn(this.viewer, objectColumn);
        column3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String resultText = super.getText(element);
                if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element).getSourceFileName();
                } else if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)element).getOwningID();
                }
                return resultText;
            }
        });
        TableViewerColumn column4 = new TableViewerColumn(this.viewer, lineColumn);
        column4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String resultText = super.getText(element);
                if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
                    resultText = String.valueOf(((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element).getSourceFileLine());
                } else if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    resultText = "";
                }
                return resultText;
            }
        });
        TableViewerColumn column5 = new TableViewerColumn(this.viewer, moduleColumn);
        column5.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String resultText = super.getText(element);
                if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element).getModule();
                } else if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)element).getModule();
                }
                return resultText;
            }
        });
        TableViewerColumn column6 = new TableViewerColumn(this.viewer, descriptionColumn);
        column6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String resultText = super.getText(element);
                if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element).getLogEntryDescription();
                } else if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    resultText = ((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)element).getLogEntryDescription();
                }
                return resultText;
            }
        });
        lastUserColumn.addListener(13, this.createSortListener(table));
        objectColumn.addListener(13, this.createSortListener(table));
        reportedColumn.addListener(13, this.createSortListener(table));
        lineColumn.addListener(13, this.createSortIntListener(table));
        moduleColumn.addListener(13, this.createSortListener(table));
        descriptionColumn.addListener(13, this.createSortListener(table));
    }

    private Listener createSortListener(final Table table) {
        return new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = table.getItems();
                TableColumn column = (TableColumn)e.widget;
                int direction = SubCheckView.this.getSortDirection(table, column);
                int index = this.getColumnIndex(table, column);
                if (index >= 0) {
                    Collator collator = Collator.getInstance(Locale.getDefault());
                    int i = 0;
                    while (i < items.length) {
                        String value1 = items[i].getText(index);
                        int j = 0;
                        while (j < i) {
                            String value2 = items[j].getText(index);
                            if (collator.compare(value1, value2) * direction <= 0) {
                                String[] values = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3), items[i].getText(4), items[i].getText(5)};
                                items[i].dispose();
                                TableItem item = new TableItem(table, 0, j);
                                item.setText(values);
                                items = table.getItems();
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }

            private int getColumnIndex(Table table2, TableColumn column) {
                int index = 0;
                TableColumn[] tableColumnArray = table2.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn tableColumn = tableColumnArray[n2];
                    if (tableColumn.getText().equals(column.getText())) break;
                    ++index;
                    ++n2;
                }
                return index;
            }
        };
    }

    private Listener createSortIntListener(final Table table) {
        return new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = table.getItems();
                TableColumn column = (TableColumn)e.widget;
                int direction = SubCheckView.this.getSortDirection(table, column);
                int index = this.getColumnIndex(table, column);
                if (index >= 0) {
                    int i = 0;
                    while (i < items.length) {
                        int value1 = Integer.parseInt(items[i].getText(index));
                        int j = 0;
                        while (j < i) {
                            int value2 = Integer.parseInt(items[j].getText(index));
                            if (Integer.compare(value1, value2) * direction <= 0) {
                                String[] values = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3), items[i].getText(4), items[i].getText(5)};
                                items[i].dispose();
                                TableItem item = new TableItem(table, 0, j);
                                item.setText(values);
                                items = table.getItems();
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }

            private int getColumnIndex(Table table2, TableColumn column) {
                int index = 0;
                TableColumn[] tableColumnArray = table2.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn tableColumn = tableColumnArray[n2];
                    if (tableColumn.getText().equals(column.getText())) break;
                    ++index;
                    ++n2;
                }
                return index;
            }
        };
    }

    private int getSortDirection(Table table, TableColumn column) {
        int direction = table.getSortDirection();
        table.setSortColumn(column);
        if (direction == 128) {
            table.setSortDirection(1024);
            direction = -1;
        } else if (direction == 1024) {
            table.setSortDirection(0);
            direction = 0;
        } else {
            table.setSortDirection(128);
            direction = 1;
        }
        return direction;
    }

    private TableColumn createTableColumn(Table table, String header) {
        TableColumn column = new TableColumn(table, 0);
        column.setText(header);
        column.setWidth(100);
        column.setResizable(true);
        return column;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != null && selection != null) {
            if (!(part instanceof CheckTreeView) || this.viewer.getTable().isDisposed()) {
                IStructuredSelection structuredSelection;
                if (!selection.isEmpty() && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() > 1) {
                    this.clearDetailSection();
                }
                return;
            }
            this.clearDetailSection();
            this.clearTableSection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection;
                Object firstSelectedElement;
                if (part instanceof CheckTreeView) {
                    this.selectedProjectName = ((CheckTreeView)part).getSelectedProject();
                    this.filter.setSearchFilter(((CheckTreeView)part).getCurrentTeam(), ((CheckTreeView)part).getCurrentModule());
                }
                if ((firstSelectedElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck) {
                    this.updateTableSection((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck)firstSelectedElement);
                } else if (firstSelectedElement instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc || firstSelectedElement instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
                    this.updateDetailSection(firstSelectedElement);
                }
            }
        }
    }

    private void updateTableSection(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck subcheck) {
        Boolean hasInput = Boolean.FALSE;
        Object viewerInput = null;
        if (subcheck.getTtDSLogEntrySrc().size() > 0) {
            viewerInput = subcheck.getTtDSLogEntrySrc().toArray();
            hasInput = Boolean.TRUE;
        } else if (subcheck.getTtDSLogEntryRepos().size() > 0) {
            viewerInput = subcheck.getTtDSLogEntryRepos();
            hasInput = Boolean.TRUE;
        }
        if (hasInput.booleanValue()) {
            this.viewer.getTable().removeAll();
            this.viewer.setInput(viewerInput);
            this.viewer.refresh(true);
            TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.pack();
                ++n2;
            }
            this.setPartName(subcheck.getDSSubCheckID());
            this.setTitleImage(this.imageProvider.getImage(subcheck));
        }
    }

    private void setDescription(String text) {
        this.description.setText(text != null ? text : "");
    }

    public void setFocus() {
    }

    private void setLastUser(String text) {
        this.lastUser.setText(text != null ? text : "");
    }

    private void setLine(String text) {
        this.line.setText(text != null ? text : "");
    }

    private void setCodeFragment(String text) {
        this.codeFragment.setText(text != null ? text : "");
    }

    private void setModule(String text) {
        this.module.setText(text != null ? text : "");
    }

    private void setLogEntryReposDetails(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos entryRepos) {
        this.setLastUser(entryRepos.getLastUser());
        this.setReported(entryRepos.getReportedFirst());
        this.setObjectID(entryRepos.getOwningID().replace(", ", ",\n"));
        this.setLine("");
        this.setModule(entryRepos.getModule());
        this.setDescription(entryRepos.getLogEntryDescription());
        this.setCodeFragment("");
    }

    private void setLogEntrySrcDetails(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc entrySrc) {
        this.setLastUser(entrySrc.getLastUser());
        this.setReported(entrySrc.getReportedFirst());
        this.setObjectID(entrySrc.getSourceFileName());
        this.setLine(String.valueOf(entrySrc.getSourceFileLine()));
        this.setModule(entrySrc.getModule());
        this.setDescription(entrySrc.getLogEntryDescription());
        this.setCodeFragment(entrySrc.getStatement());
    }

    private void setObjectID(String text) {
        this.objectID.setText(text != null ? text : "");
    }

    private void setReported(String text) {
        this.reported.setText(text != null ? text : "");
    }

    private void setReported(XMLGregorianCalendar calendar) {
        if (calendar != null) {
            this.setReported(String.valueOf(calendar.getDay()) + "." + calendar.getMonth() + "." + calendar.getYear());
        } else {
            this.setReported("");
        }
    }

    private void updateDetailSection(Object entry) {
        if (entry instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
            this.setLogEntrySrcDetails((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)entry);
        } else if (entry instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
            this.setLogEntryReposDetails((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)entry);
        } else {
            this.clearDetailSection();
        }
    }
}

