/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.checks;

import com.proalpha.pds.checks.CheckFilter;
import com.proalpha.pds.checks.ConsistencyChecksImageProvider;
import com.proalpha.pds.jaxb.DsDSConsistencyChecks;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class CheckTreeViewLabelProvider
extends LabelProvider {
    private ConsistencyChecksImageProvider consistencyChecksImageProvider;
    private CheckFilter checkFilter;

    public CheckTreeViewLabelProvider(CheckFilter filter) {
        this.checkFilter = filter;
        this.consistencyChecksImageProvider = new ConsistencyChecksImageProvider();
    }

    public String getText(Object element) {
        String text = "no text";
        if (element instanceof DsDSConsistencyChecks.TtDSCheck) {
            text = ((DsDSConsistencyChecks.TtDSCheck)element).getDSCheckID();
        } else if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck) {
            DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck subCheck = (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck)element;
            String count = subCheck.getDSCheckID().startsWith("Unit Tests") ? MessageFormat.format("{0}|{1}", this.checkFilter.getFailedTestsCount(subCheck), subCheck.getReportedTotal()) : MessageFormat.format("{0}|{1}", this.checkFilter.getVisibleElementCount(subCheck), subCheck.getReportedTotal());
            text = MessageFormat.format("{0} ({1})", subCheck.getDSSubCheckID(), count);
        }
        return text;
    }

    public Image getImage(Object element) {
        return this.consistencyChecksImageProvider.getImage(element);
    }
}

