/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.checks;

import com.proalpha.pds.jaxb.DsDSConsistencyChecks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class CheckFilter
extends ViewerFilter {
    private static final String CHECK_ALL = "<ALL>";
    private static final String[] TEAMS = new String[]{"<ALL>", "Basis-Team (B*, D*, IB, IS)", "CA-Link-Team (PC)", "CCI-Team (U*)", "EVS-Team (E*, IE, IK, IV, V*)", "IDE-Team (DD, DU, DV)", "INWB/DMS/BI/WEB-Team (BI, BO, DI, O*, W*)", "Mawi-Team (IJ, IM, J*, M*, SD, SE, SO, WS)", "PK-Team (MU)", "PPS-Team (IP, MA, MB, P*)", "Rewe-Team (A*, F*, IF, K*, L*, R*, SA, SK, T*)"};
    private static final String[][] TEAM_MODULES = new String[][]{{"I_", "IA", "S_", "SB", "*"}, {"B*", "D*", "IB", "IS"}, {"PC"}, {"U*"}, {"E*", "IE", "IK", "IV", "V*"}, {"DD", "DU", "DV"}, {"BI", "BO", "DI", "O*", "W*"}, {"IJ", "IM", "J*", "M*", "SD", "SE", "SO", "WS"}, {"MU"}, {"IP", "MA", "MB", "P*"}, {"A*", "F*", "IF", "K*", "L*", "R*", "SA", "SK", "T*"}};
    private static final List<String> TEAMLIST = Arrays.asList(TEAMS);
    private List<String> currentTeamModuleList = new ArrayList<String>();
    private String searchTeam = "<ALL>";
    private String searchModule = "<ALL>";

    public String[] getTeams() {
        return TEAMS;
    }

    public Integer getFailedTestsCount(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck subCheck) {
        Integer count = 0;
        List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc> filteredSrcEntries = subCheck.getTtDSLogEntrySrc();
        if (!filteredSrcEntries.isEmpty()) {
            for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc filteredSrcEntry : filteredSrcEntries) {
                if (!filteredSrcEntry.getLogEntryDescription().equalsIgnoreCase("FAILED")) continue;
                count = count + 1;
            }
        }
        return count;
    }

    public Integer getVisibleElementCount(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck subCheck) {
        Integer count = 0;
        if (this.searchTeam.equals(CHECK_ALL) && this.searchModule.equals(CHECK_ALL)) {
            count = subCheck.getReportedTotal();
        } else {
            List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos> filteredRepoEntries;
            List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc> filteredSrcEntries = subCheck.getTtDSLogEntrySrc();
            if (!filteredSrcEntries.isEmpty()) {
                for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc filteredSrcEntry : filteredSrcEntries) {
                    if (!this.srcMatchesModule(filteredSrcEntry)) continue;
                    count = count + 1;
                }
            }
            if (!(filteredRepoEntries = subCheck.getTtDSLogEntryRepos()).isEmpty()) {
                for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos filteredRepoEntry : filteredRepoEntries) {
                    if (!this.repoMatchesModule(filteredRepoEntry)) continue;
                    count = count + 1;
                }
            }
        }
        return count;
    }

    public void setSearchFilter(String team, String module) {
        this.searchTeam = team;
        this.searchModule = module;
        this.currentTeamModuleList.clear();
        if (!this.searchTeam.equals(CHECK_ALL)) {
            this.currentTeamModuleList.addAll(Arrays.asList(TEAM_MODULES[TEAMLIST.indexOf(this.searchTeam)]));
        }
        this.currentTeamModuleList.addAll(Arrays.asList(TEAM_MODULES[TEAMLIST.indexOf(CHECK_ALL)]));
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (this.searchTeam.equals(CHECK_ALL) && this.searchModule.equals(CHECK_ALL) && !(element instanceof DsDSConsistencyChecks.TtDSCheck)) {
            return true;
        }
        if (element instanceof DsDSConsistencyChecks.TtDSCheck) {
            return this.filterCheck((DsDSConsistencyChecks.TtDSCheck)element);
        }
        if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck) {
            return this.filterSubCheck((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck)element);
        }
        if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
            return this.srcMatchesModule((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element);
        }
        if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
            return this.repoMatchesModule((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)element);
        }
        return true;
    }

    private boolean filterCheck(DsDSConsistencyChecks.TtDSCheck Check) {
        boolean isShown = false;
        List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck> filteredSubCheckEntries = Check.getTtDSSubCheck();
        if (!filteredSubCheckEntries.isEmpty()) {
            if (this.searchTeam.equals(CHECK_ALL) && this.searchModule.equals(CHECK_ALL)) {
                return true;
            }
            for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck filteredSubCheckEntry : filteredSubCheckEntries) {
                if (!this.filterSubCheck(filteredSubCheckEntry)) continue;
                isShown = true;
            }
        }
        return isShown;
    }

    private boolean filterSubCheck(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck subCheck) {
        List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos> filteredRepoEntries;
        List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc> filteredSrcEntries = subCheck.getTtDSLogEntrySrc();
        if (!filteredSrcEntries.isEmpty()) {
            for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc filteredSrcEntry : filteredSrcEntries) {
                if (!this.srcMatchesModule(filteredSrcEntry)) continue;
                return true;
            }
        }
        if (!(filteredRepoEntries = subCheck.getTtDSLogEntryRepos()).isEmpty()) {
            for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos filteredRepoEntry : filteredRepoEntries) {
                if (!this.repoMatchesModule(filteredRepoEntry)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean srcMatchesModule(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc srcEntry) {
        if (srcEntry.getModule() != null && !srcEntry.getModule().isEmpty()) {
            if (this.searchModule.equals(CHECK_ALL)) {
                return this.checkTeamModules(srcEntry.getModule());
            }
            return srcEntry.getModule().equals(this.searchModule);
        }
        return false;
    }

    private boolean repoMatchesModule(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos repoEntry) {
        if (repoEntry.getModule() != null && !repoEntry.getModule().isEmpty()) {
            if (this.searchModule.equals(CHECK_ALL)) {
                return this.checkTeamModules(repoEntry.getModule());
            }
            return repoEntry.getModule().equals(this.searchModule);
        }
        return false;
    }

    private boolean checkTeamModules(String module) {
        if (this.isModuleHidden(module)) {
            return false;
        }
        for (String currentModule : this.currentTeamModuleList) {
            if (currentModule.contains("*")) {
                if (currentModule.equals("*")) {
                    if (currentModule.equals(module)) {
                        return true;
                    }
                    int i = 0;
                    while (i < TEAM_MODULES.length) {
                        if (!this.isAlreadyIncludedInCurrentTeam(i)) {
                            int j = 0;
                            while (j < TEAM_MODULES[i].length) {
                                if (this.matchesLetterStarExpression(i, j, module)) {
                                    return false;
                                }
                                if (module.equals(TEAM_MODULES[i][j])) {
                                    return false;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    return true;
                }
                if (!this.matchPossible(currentModule, module)) continue;
                int i = 0;
                while (i < TEAM_MODULES.length) {
                    if (!this.isAlreadyIncludedInCurrentTeam(i)) {
                        int j = 0;
                        while (j < TEAM_MODULES[i].length) {
                            if (module.equals(TEAM_MODULES[i][j])) {
                                return false;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                return true;
            }
            if (!currentModule.equals(module)) continue;
            return true;
        }
        return true;
    }

    private boolean isModuleHidden(String module) {
        return module.equals("**") || !module.equals("*") && module.length() != 2;
    }

    private boolean isAlreadyIncludedInCurrentTeam(int i) {
        return TEAMLIST.indexOf(this.searchTeam) == i || TEAMLIST.indexOf(CHECK_ALL) == i;
    }

    private boolean matchesLetterStarExpression(int i, int j, String module) {
        return TEAM_MODULES[i][j].contains("*") && !TEAM_MODULES[i][j].equals("*") && (TEAM_MODULES[i][j].startsWith(String.valueOf(module.charAt(0))) || TEAM_MODULES[i][j].endsWith(String.valueOf(module.charAt(1))));
    }

    private boolean matchPossible(String currentModule, String module) {
        if (currentModule.startsWith("*")) {
            return currentModule.endsWith(String.valueOf(module.charAt(1)));
        }
        return currentModule.startsWith(String.valueOf(module.charAt(0)));
    }
}

