/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.checks;

import com.proalpha.pds.checks.Team;
import com.proalpha.pds.checks.jaxb.DsDSConsistencyChecks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class CheckFilter
extends ViewerFilter {
    private final String CHECK_ALL = "<ALL>";
    private List<String> whiteListPatterns;
    private List<String> blackListPatterns = new ArrayList<String>();

    public CheckFilter() {
        this.whiteListPatterns = new ArrayList<String>();
        this.whiteListPatterns.addAll(Team.ALL.getModules());
    }

    public Integer getFailedTestsCount(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck subCheck) {
        Integer count = 0;
        List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc> filteredSrcEntries = subCheck.getTtDSLogEntrySrc();
        if (!filteredSrcEntries.isEmpty()) {
            for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc filteredSrcEntry : filteredSrcEntries) {
                if (!filteredSrcEntry.getLogEntryDescription().equalsIgnoreCase("FAILED")) continue;
                count = count + 1;
            }
        }
        return count;
    }

    public Integer getVisibleElementCount(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck subCheck) {
        List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos> repoEntries;
        if (this.whiteListPatterns.containsAll(Team.ALL.getModules()) && this.blackListPatterns.isEmpty()) {
            return subCheck.getReportedTotal();
        }
        Integer count = 0;
        List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc> srcEntries = subCheck.getTtDSLogEntrySrc();
        if (!srcEntries.isEmpty()) {
            for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc srcEntry : srcEntries) {
                if (!this.filterSrcEntry(srcEntry)) continue;
                count = count + 1;
            }
        }
        if (!(repoEntries = subCheck.getTtDSLogEntryRepos()).isEmpty()) {
            for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos repoEntry : repoEntries) {
                if (!this.filterRepoEntry(repoEntry)) continue;
                count = count + 1;
            }
        }
        return count;
    }

    public void setSearchFilter(String team, String module, boolean showCommonModules) {
        this.whiteListPatterns.clear();
        this.blackListPatterns.clear();
        if (showCommonModules) {
            this.whiteListPatterns.addAll(Team.COMMON.getModules());
        } else {
            this.blackListPatterns.addAll(Team.COMMON.getModules());
        }
        if (!module.equals("<ALL>")) {
            this.whiteListPatterns.add(module.replace("*", "\\*"));
            this.blackListPatterns.remove(module);
        } else if (!team.equals("<ALL>")) {
            this.whiteListPatterns.addAll(Team.valueOfLabel(team).getModules());
            if (Team.valueOfLabel(team) == Team.UNASSIGNED) {
                this.blackListPatterns.addAll(this.getAllTeamModulesExcept(team));
            } else {
                this.blackListPatterns.addAll(this.getExcludedModulesByTeam(team));
            }
        } else {
            this.whiteListPatterns.addAll(Team.ALL.getModules());
        }
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (this.whiteListPatterns.containsAll(Team.ALL.getModules()) && this.blackListPatterns.isEmpty() && !(element instanceof DsDSConsistencyChecks.TtDSCheck)) {
            return true;
        }
        if (element instanceof DsDSConsistencyChecks.TtDSCheck) {
            return this.filterCheck((DsDSConsistencyChecks.TtDSCheck)element);
        }
        if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck) {
            return this.filterSubCheck((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck)element);
        }
        if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc) {
            return this.filterSrcEntry((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc)element);
        }
        if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos) {
            return this.filterRepoEntry((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos)element);
        }
        return true;
    }

    private List<String> getAllTeamModulesExcept(String currentTeam) {
        ArrayList<String> teamModules = new ArrayList<String>();
        List otherTeams = Arrays.asList(Team.values()).stream().collect(Collectors.toList());
        otherTeams.remove((Object)Team.valueOfLabel(currentTeam));
        otherTeams.remove((Object)Team.ALL);
        for (Team team : otherTeams) {
            teamModules.addAll(team.getModules());
        }
        return teamModules;
    }

    private List<String> getExcludedModulesByTeam(String currentTeam) {
        ArrayList<String> excludedModulesByTeam = new ArrayList<String>();
        List teamModulesWithWildcards = Team.valueOfLabel(currentTeam).getModules().stream().filter(x -> x.matches(".?\\\\w.?")).collect(Collectors.toList());
        if (!teamModulesWithWildcards.isEmpty()) {
            List otherTeams = Arrays.asList(Team.values()).stream().collect(Collectors.toList());
            otherTeams.remove((Object)Team.valueOfLabel(currentTeam));
            for (String wildcardModule : teamModulesWithWildcards) {
                for (Team team : otherTeams) {
                    for (String module : team.getModules()) {
                        if (!module.matches(wildcardModule)) continue;
                        excludedModulesByTeam.add(module);
                    }
                }
            }
        }
        return excludedModulesByTeam;
    }

    private boolean filterCheck(DsDSConsistencyChecks.TtDSCheck Check) {
        List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck> filteredSubCheckEntries = Check.getTtDSSubCheck();
        if (!filteredSubCheckEntries.isEmpty()) {
            if (this.whiteListPatterns.containsAll(Team.ALL.getModules()) && this.blackListPatterns.isEmpty()) {
                return true;
            }
            for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck filteredSubCheckEntry : filteredSubCheckEntries) {
                if (!this.filterSubCheck(filteredSubCheckEntry)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean filterSubCheck(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck subCheck) {
        List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos> filteredRepoEntries;
        List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc> filteredSrcEntries = subCheck.getTtDSLogEntrySrc();
        if (!filteredSrcEntries.isEmpty()) {
            for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc filteredSrcEntry : filteredSrcEntries) {
                if (!this.filterSrcEntry(filteredSrcEntry)) continue;
                return true;
            }
        }
        if (!(filteredRepoEntries = subCheck.getTtDSLogEntryRepos()).isEmpty()) {
            for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos filteredRepoEntry : filteredRepoEntries) {
                if (!this.filterRepoEntry(filteredRepoEntry)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean filterSrcEntry(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc srcEntry) {
        return this.filterModule(srcEntry.getModule());
    }

    private boolean filterRepoEntry(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos repoEntry) {
        return this.filterModule(repoEntry.getModule());
    }

    private boolean filterModule(String module) {
        if (module == null || module.isEmpty()) {
            return false;
        }
        if (module.equals("**") || !module.equals("*") && module.length() != 2) {
            return false;
        }
        boolean showModule = false;
        for (String filterPattern : this.whiteListPatterns) {
            if (!module.matches(filterPattern)) continue;
            showModule = true;
            break;
        }
        for (String filterPattern : this.blackListPatterns) {
            if (!module.matches(filterPattern)) continue;
            showModule = false;
            break;
        }
        if (!showModule && this.whiteListPatterns.contains(module.replace("*", "\\*"))) {
            showModule = true;
        }
        return showModule;
    }
}

