/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.cherrypick;

import com.proalpha.git.PaGit;
import com.proalpha.git.model.PaCherryPickResult;
import com.proalpha.pds.gitutils.cherrypick.CherryPick;
import com.proalpha.pds.gitutils.external.DbAndBinaryOperation;
import com.proalpha.pds.gitutils.mylyn.CheckoutAction;
import com.proalpha.pds.paconnector.Activator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.ui.internal.push.PushBranchWizard;
import org.eclipse.egit.ui.internal.push.PushWizardDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CherryPickResultDialog
extends Dialog {
    private final Logger logger = LoggerFactory.getLogger(CherryPickResultDialog.class);
    private final PaCherryPickResult result;
    private final List<RevCommit> successfulPicks;
    private final List<RevCommit> openPicks;
    private Text text;
    private Button btnPush;
    private Label lblHint;
    private CheckoutAction currentAction = CheckoutAction.NONE;
    private IProgressMonitor monitor;
    private Repository repository;

    protected Control createDialogArea(Composite parent) {
        final Composite main = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(main);
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        main.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(main, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblNewLabel = new Label(composite, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setText("Result Status:");
        this.text = new Text(composite, 8);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.text.setText(this.result.getStatus().toString());
        this.text.setFont(JFaceResources.getFont((String)"Courier New"));
        Group grpPerformedcommits = new Group(main, 0);
        grpPerformedcommits.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpPerformedcommits.setText("Performed Commits");
        TreeViewer succViewer = new TreeViewer((Composite)grpPerformedcommits);
        Tree succTree = succViewer.getTree();
        succTree.setBounds(0, 22, 460, 130);
        succViewer.setAutoExpandLevel(2);
        this.fillTreeView(succViewer, this.successfulPicks);
        Group grpOpenCommits = new Group(main, 0);
        grpOpenCommits.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpOpenCommits.setText("Open Commits");
        TreeViewer openViewer = new TreeViewer((Composite)grpOpenCommits);
        Tree openTree = openViewer.getTree();
        openTree.setBounds(10, 22, 460, 90);
        openViewer.setAutoExpandLevel(2);
        this.fillTreeView(openViewer, this.openPicks);
        this.btnPush = new Button(main, 32);
        this.btnPush.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnPush.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (!CherryPickResultDialog.this.btnPush.getSelection()) {
                    CherryPickResultDialog.this.lblHint.setText("Hint: Dont't forget to push your picked branch to the remote Repository!");
                } else {
                    CherryPickResultDialog.this.lblHint.setText("");
                }
                main.layout(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.btnPush.setText("Push automatically to server");
        this.btnPush.setSelection(true);
        Group grpCheckoutSettings = new Group(main, 0);
        grpCheckoutSettings.setText("Reconcile settings");
        grpCheckoutSettings.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        grpCheckoutSettings.setLayout((Layout)new GridLayout(1, false));
        Combo cmbCheckoutAction = new Combo((Composite)grpCheckoutSettings, 32);
        cmbCheckoutAction.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        cmbCheckoutAction.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectedItem) {
                CherryPickResultDialog.this.currentAction = null;
                if (selectedItem != null) {
                    CherryPickResultDialog.this.currentAction = CheckoutAction.getAction(((Combo)selectedItem.getSource()).getText());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        cmbCheckoutAction.setBounds(76, 22, 300, 16);
        String[] checkoutActions = CheckoutAction.getActions();
        cmbCheckoutAction.setItems(checkoutActions);
        int selectionIndex = this.determineSelectionIndex(checkoutActions, CheckoutAction.LOAD_XML.getValue());
        cmbCheckoutAction.select(selectionIndex);
        this.lblHint = new Label(main, 0);
        this.lblHint.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        if (this.result.getStatus() == CherryPickResult.CherryPickStatus.FAILED) {
            this.lblHint.setText("Something wicked happended!\nThe cherrypick terribly failed :-/\nGo to history view to reset your branch.");
            this.text.setForeground(parent.getDisplay().getSystemColor(3));
        }
        if (this.result.getStatus() == CherryPickResult.CherryPickStatus.OK) {
            this.text.setForeground(parent.getDisplay().getSystemColor(6));
        }
        if (this.result.getStatus() == CherryPickResult.CherryPickStatus.CONFLICTING) {
            this.lblHint.setText("There is a conflict in your pick.\nPlease resolve the conflict in Git Staging view,\ncommit your change and resume the cherrypick!");
            this.text.setForeground(parent.getDisplay().getSystemColor(9));
        }
        return main;
    }

    private int determineSelectionIndex(String[] checkoutActions, String searchValue) {
        int selectionIndex = 0;
        String[] stringArray = checkoutActions;
        int n = checkoutActions.length;
        int n2 = 0;
        while (n2 < n) {
            String action = stringArray[n2];
            if (action == searchValue) break;
            ++selectionIndex;
            ++n2;
        }
        return selectionIndex;
    }

    protected CherryPickResultDialog(Shell parentShell, IProgressMonitor monitor, Repository repository, PaCherryPickResult cpResult) {
        super(parentShell);
        this.monitor = monitor;
        this.repository = repository;
        this.result = cpResult;
        this.successfulPicks = cpResult.getSuccessfulPicks();
        this.openPicks = cpResult.getOpenPicks();
    }

    protected void okPressed() {
        CherryPickResult.CherryPickStatus status = CherryPick.getInstance().getCherryPickResult().getStatus();
        if (status == CherryPickResult.CherryPickStatus.OK && this.btnPush.getSelection()) {
            try {
                Repository repository = PaGit.getInstance().getGit().getRepository();
                PushBranchWizard wizard = null;
                Ref ref = null;
                String fullBranch = repository.getFullBranch();
                if (fullBranch != null && fullBranch.startsWith("refs/heads/")) {
                    ref = repository.exactRef(fullBranch);
                }
                if (ref != null) {
                    wizard = new PushBranchWizard(repository, ref);
                } else {
                    ObjectId id = repository.resolve(repository.getFullBranch());
                    wizard = new PushBranchWizard(repository, id);
                }
                new PushWizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard).open();
                if (this.currentAction != CheckoutAction.NONE) {
                    try {
                        this.performReconcileJob(repository, this.currentAction, this.monitor);
                    }
                    catch (InvocationTargetException e) {
                        this.logger.error("An error occured during reconcile after cherrypick", (Throwable)e);
                    }
                }
            }
            catch (IOException ex) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)ex.getMessage(), (String)ex.getLocalizedMessage()));
            }
        }
        super.okPressed();
    }

    private void performReconcileJob(Repository repository, CheckoutAction checkoutAction, IProgressMonitor monitor) throws InvocationTargetException {
        IProject[] projects = ProjectUtil.getProjects((Repository)repository);
        ArrayList<IProject> affectedProjects = new ArrayList<IProject>(Arrays.asList(projects));
        if (checkoutAction.equals((Object)CheckoutAction.FULL_RECONCILE)) {
            Activator.getDefault().getProjectManager().closeProjects(affectedProjects, monitor);
        }
        this.executeDbBinaryOperation(repository, checkoutAction, SubMonitor.convert((IProgressMonitor)monitor, (String)"database reconcile and artifact update", (int)1));
        if (checkoutAction.equals((Object)CheckoutAction.FULL_RECONCILE)) {
            Activator.getDefault().getProjectManager().openProjects(affectedProjects, monitor);
        }
    }

    public void executeDbBinaryOperation(Repository repository, CheckoutAction checkoutAction, SubMonitor subMonitorArtifacts) throws InvocationTargetException {
        DbAndBinaryOperation updateDbBinaryOp = new DbAndBinaryOperation(repository, checkoutAction);
        updateDbBinaryOp.setProgressMonitor(subMonitorArtifacts);
        updateDbBinaryOp.execute();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("CherryPick Result: " + this.result.getStatus());
    }

    private void fillTreeView(TreeViewer treeViewer, List<RevCommit> commits) {
        TreeViewerColumn treeViewerColumn_2 = new TreeViewerColumn(treeViewer, 0);
        TreeColumn trclmnNewColumn_2 = treeViewerColumn_2.getColumn();
        trclmnNewColumn_2.setWidth(80);
        trclmnNewColumn_2.setText("CommitID");
        treeViewerColumn_2.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new NameLabelProvider()));
        TreeViewerColumn treeViewerColumn_1 = new TreeViewerColumn(treeViewer, 0);
        TreeColumn trclmnNewColumn_1 = treeViewerColumn_1.getColumn();
        trclmnNewColumn_1.setWidth(200);
        trclmnNewColumn_1.setText("Message");
        trclmnNewColumn_1.setAlignment(16384);
        treeViewerColumn_1.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new MessageLabelProvider()));
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(treeViewer, 0);
        TreeColumn trclmnNewColumn = treeViewerColumn.getColumn();
        trclmnNewColumn.setWidth(100);
        trclmnNewColumn.setText("Author");
        trclmnNewColumn.setAlignment(16384);
        treeViewerColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AuthorLabelProvider()));
        TreeViewerColumn dateColumn = new TreeViewerColumn(treeViewer, 0);
        TreeColumn trclmnDateColumn = dateColumn.getColumn();
        trclmnDateColumn.setWidth(70);
        trclmnDateColumn.setText("Date");
        trclmnDateColumn.setAlignment(16384);
        dateColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DateLabelProvider()));
        treeViewer.setContentProvider((IContentProvider)new CommitProvider());
        treeViewer.setInput(commits);
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.getTree().setLinesVisible(true);
    }

    class AuthorLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        AuthorLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof RevCommit) {
                RevCommit commit = (RevCommit)element;
                return new StyledString(commit.getAuthorIdent().getName());
            }
            return null;
        }
    }

    public class CommitProvider
    implements ITreeContentProvider {
        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    class DateLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private DateFormat dateLabelFormat = DateFormat.getDateInstance();

        public StyledString getStyledText(Object element) {
            if (element instanceof RevCommit) {
                RevCommit commit = (RevCommit)element;
                return new StyledString(this.dateLabelFormat.format(commit.getCommitterIdent().getWhen()));
            }
            return null;
        }
    }

    class MessageLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        MessageLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof RevCommit) {
                RevCommit commit = (RevCommit)element;
                return new StyledString(commit.getFullMessage().replace("\n", " "));
            }
            return null;
        }
    }

    class NameLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        NameLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof RevCommit) {
                RevCommit commit = (RevCommit)element;
                return new StyledString(commit.getName().substring(0, 8));
            }
            return null;
        }
    }
}

