/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.git.util.PaBranchName;
import com.proalpha.git.util.PaRepository;
import com.proalpha.pds.gitutils.mylyn.CheckoutAction;
import com.proalpha.pds.gitutils.mylyn.FeatureBranchSettings;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectBranchesPage
extends WizardPage {
    private final Logger logger = LoggerFactory.getLogger(SelectBranchesPage.class);
    private FeatureBranchSettings settings;
    private Text txtSrcBranch;
    private Text txtTargetBranch;
    private Button btnUpdateSrcBranch;
    private Button btnUpdateTargetBranch;
    private Button btnEditSrcBranchname;
    private Button btnEditTargetBranchname;
    private Combo cmbCheckoutAction;
    private Label lblSrcBranchInfo;
    private Label lblTargetBranchInfo;
    private TargetBranchStatus targetBranchStatus;
    private List<String> serverBranches;

    public SelectBranchesPage(FeatureBranchSettings settings) {
        super(SelectBranchesPage.class.getName());
        this.settings = settings;
        this.setTitle("Branch Selection");
        this.setMessage("Select the branches to checkout or rather create", 1);
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.proalpha.pds.gitutils"), (IPath)new Path("icons/pA-logox72.png"), Collections.emptyMap());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setBackgroundMode(1);
        GridData gd_grp = new GridData(0x1000000, 128, true, false, 1, 1);
        gd_grp.heightHint = 200;
        gd_grp.widthHint = 450;
        Group grp = new Group(container, 0);
        grp.setLayoutData((Object)gd_grp);
        grp.setText("Branch settings");
        grp.setBackgroundMode(1);
        GridData gd_co_grp = new GridData(0x1000000, 128, true, false, 1, 1);
        gd_co_grp.heightHint = 40;
        gd_co_grp.widthHint = 450;
        Group coSettinggrp = new Group(container, 0);
        coSettinggrp.setLayoutData((Object)gd_co_grp);
        coSettinggrp.setText("Checkout settings");
        coSettinggrp.setBackgroundMode(1);
        this.cmbCheckoutAction = new Combo((Composite)coSettinggrp, 32);
        this.cmbCheckoutAction.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectedItem) {
                String currentAction = null;
                if (selectedItem != null && (currentAction = ((Combo)selectedItem.getSource()).getText()) != null) {
                    SelectBranchesPage.this.settings.setCheckoutAction(CheckoutAction.getAction(currentAction));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cmbCheckoutAction.setBounds(76, 22, 300, 16);
        this.cmbCheckoutAction.setItems(CheckoutAction.getActions());
        Label lblSrcBranch = new Label((Composite)grp, 64);
        lblSrcBranch.setText("Source");
        lblSrcBranch.setBounds(10, 22, 60, 15);
        this.txtSrcBranch = new Text((Composite)grp, 2048);
        this.txtSrcBranch.setBounds(76, 19, 212, 21);
        this.txtSrcBranch.setText(this.settings.getSourceBranch() == null ? "" : this.settings.getSourceBranch());
        this.txtSrcBranch.setEnabled(false);
        this.txtSrcBranch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SelectBranchesPage.this.txtSrcBranch.getText().length() != 0) {
                    SelectBranchesPage.this.settings.setSourceBranch(SelectBranchesPage.this.txtSrcBranch.getText());
                }
                SelectBranchesPage.this.updateDependentFields();
                SelectBranchesPage.this.setPageComplete(SelectBranchesPage.this.targetBranchStatus == TargetBranchStatus.LOCAL || SelectBranchesPage.this.targetBranchStatus == TargetBranchStatus.REMOTE || SelectBranchesPage.this.isSourceBranchValid());
            }
        });
        this.btnEditSrcBranchname = new Button((Composite)grp, 32);
        this.btnEditSrcBranchname.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectBranchesPage.this.txtSrcBranch.setEnabled(SelectBranchesPage.this.btnEditSrcBranchname.getSelection());
                if (!SelectBranchesPage.this.btnEditSrcBranchname.getSelection()) {
                    SelectBranchesPage.this.settings.deriveDefaultSourceBranch();
                    SelectBranchesPage.this.txtSrcBranch.setText(SelectBranchesPage.this.settings.getSourceBranch());
                }
            }
        });
        this.btnEditSrcBranchname.setBounds(314, 22, 60, 16);
        this.btnEditSrcBranchname.setText("modify");
        this.btnUpdateSrcBranch = new Button((Composite)grp, 32);
        this.btnUpdateSrcBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectBranchesPage.this.settings.setUpdateSourceBranch(SelectBranchesPage.this.btnUpdateSrcBranch.getSelection());
                SelectBranchesPage.this.updateDependentFields();
            }
        });
        this.btnUpdateSrcBranch.setBounds(384, 22, 60, 16);
        this.btnUpdateSrcBranch.setText("update");
        this.lblSrcBranchInfo = new Label((Composite)grp, 64);
        this.lblSrcBranchInfo.setBounds(76, 49, 330, 60);
        this.lblSrcBranchInfo.setForeground(container.getDisplay().getSystemColor(16));
        Label lblTargetBranch = new Label((Composite)grp, 64);
        lblTargetBranch.setText("Target");
        lblTargetBranch.setBounds(10, 123, 60, 15);
        this.txtTargetBranch = new Text((Composite)grp, 2048);
        this.txtTargetBranch.setBounds(76, 120, 212, 21);
        this.txtTargetBranch.setEnabled(false);
        this.txtTargetBranch.setText(this.settings.getTargetBranch() == null ? "" : this.settings.getTargetBranch());
        this.txtTargetBranch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SelectBranchesPage.this.txtTargetBranch.getText().length() != 0) {
                    SelectBranchesPage.this.settings.setTargetBranch(SelectBranchesPage.this.txtTargetBranch.getText());
                }
                SelectBranchesPage.this.updateTargetBranchStatus();
                SelectBranchesPage.this.updateDependentFields();
                SelectBranchesPage.this.setPageComplete(SelectBranchesPage.this.targetBranchStatus == TargetBranchStatus.LOCAL || SelectBranchesPage.this.targetBranchStatus == TargetBranchStatus.REMOTE || SelectBranchesPage.this.isSourceBranchValid());
            }
        });
        this.btnEditTargetBranchname = new Button((Composite)grp, 32);
        this.btnEditTargetBranchname.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectBranchesPage.this.txtTargetBranch.setEnabled(SelectBranchesPage.this.btnEditTargetBranchname.getSelection());
                if (!SelectBranchesPage.this.btnEditTargetBranchname.getSelection()) {
                    SelectBranchesPage.this.settings.deriveDefaultTargetBranch();
                    SelectBranchesPage.this.txtTargetBranch.setText(SelectBranchesPage.this.settings.getTargetBranch());
                }
            }
        });
        this.btnEditTargetBranchname.setBounds(314, 123, 60, 16);
        this.btnEditTargetBranchname.setText("modify");
        this.btnUpdateTargetBranch = new Button((Composite)grp, 32);
        this.btnUpdateTargetBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectBranchesPage.this.settings.setUpdateTargetBranch(SelectBranchesPage.this.btnUpdateTargetBranch.getSelection());
                SelectBranchesPage.this.updateDependentFields();
            }
        });
        this.btnUpdateTargetBranch.setBounds(384, 123, 60, 16);
        this.btnUpdateTargetBranch.setText("update");
        this.lblTargetBranchInfo = new Label((Composite)grp, 64);
        this.lblTargetBranchInfo.setBounds(76, 150, 330, 60);
        this.lblTargetBranchInfo.setForeground(container.getDisplay().getSystemColor(16));
        new Label(container, 0);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialize();
        }
    }

    private void initialize() {
        this.serverBranches = this.getBranchesFromServer();
        this.updateTargetBranchStatus();
        this.txtSrcBranch.setText(this.settings.getSourceBranch() == null ? "" : this.settings.getSourceBranch());
        this.txtTargetBranch.setText(this.settings.getTargetBranch() == null ? "" : this.settings.getTargetBranch());
        this.btnUpdateSrcBranch.setSelection(this.settings.isUpdateSourceBranch());
        this.btnUpdateTargetBranch.setSelection(this.settings.isUpdateTargetBranch());
        this.cmbCheckoutAction.setText(this.settings.getCheckoutAction().toString());
    }

    private void updateDependentFields() {
        StringBuffer sb = new StringBuffer();
        for (String s : this.getSourceBranchInfo()) {
            sb.append(s);
            sb.append("\n");
        }
        this.lblSrcBranchInfo.setText(sb.toString());
        sb = new StringBuffer();
        for (String s : this.getTargetBranchInfo()) {
            sb.append(s);
            sb.append("\n");
        }
        this.lblTargetBranchInfo.setText(sb.toString());
    }

    private boolean isSourceBranchValid() {
        if (this.settings == null) {
            return false;
        }
        return PaRepository.getLocalBranches((Repository)this.settings.getRepository()).contains(this.settings.getSourceBranch());
    }

    private void updateTargetBranchStatus() {
        if (this.settings.getRepository() == null) {
            this.targetBranchStatus = TargetBranchStatus.UNKNOWN;
        }
        this.targetBranchStatus = PaRepository.isValidRef((Repository)this.settings.getRepository(), (String)this.settings.getTargetBranch()) && PaRepository.getLocalBranches((Repository)this.settings.getRepository()).contains(this.settings.getTargetBranch()) ? TargetBranchStatus.LOCAL : (PaRepository.getRemoteBranches((Repository)this.settings.getRepository()).contains(this.settings.getTargetBranch()) || this.serverBranches.contains(this.settings.getTargetBranch()) ? TargetBranchStatus.REMOTE : TargetBranchStatus.MISSING);
    }

    private List<String> getSourceBranchInfo() {
        ArrayList<String> infos = new ArrayList<String>();
        if (!this.isSourceBranchValid()) {
            infos.add("The source branch does not exist!");
        }
        if (this.targetBranchStatus == TargetBranchStatus.LOCAL || this.targetBranchStatus == TargetBranchStatus.REMOTE) {
            infos.add("The source branch will not be used, because the target branch exists.");
        } else if (this.targetBranchStatus == TargetBranchStatus.MISSING) {
            infos.add("The source branch will be branched off.");
            if (!this.settings.isUpdateSourceBranch()) {
                infos.add("Warning: Your new target branch is probably not based on the newest version of the source branch.");
            }
        }
        return infos;
    }

    private List<String> getTargetBranchInfo() {
        ArrayList<String> infos = new ArrayList<String>();
        if (this.targetBranchStatus == TargetBranchStatus.UNKNOWN) {
            return infos;
        }
        if (this.targetBranchStatus == TargetBranchStatus.LOCAL) {
            infos.add("The target branch already exists in the local repository and will be checked out.");
            if (!this.settings.isUpdateTargetBranch()) {
                infos.add("Warning: The target branch will not be updated. It is probably outdated.");
            }
        } else if (this.targetBranchStatus == TargetBranchStatus.REMOTE) {
            infos.add("The target branch already exists on server and will be fetched/checked out.");
        } else {
            infos.add("The target branch does not exist and will be created.");
        }
        return infos;
    }

    private List<String> getBranchesFromServer() {
        ArrayList<String> branches = new ArrayList<String>();
        try {
            Set remotes = this.settings.getRepository().getRemoteNames();
            if (remotes.iterator().hasNext()) {
                String remote = (String)remotes.iterator().next();
                String url = this.settings.getRepository().getConfig().getString("remote", remote, "url");
                Collection refs = Git.lsRemoteRepository().setRemote(url).setHeads(true).call();
                for (Ref ref : refs) {
                    branches.add(PaBranchName.getShortBranchName((String)ref.getName(), (Repository)this.settings.getRepository()));
                }
            }
        }
        catch (GitAPIException e) {
            this.logger.error(" InvalidRemoteException occured", (Throwable)e);
        }
        return branches;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    private static enum TargetBranchStatus {
        UNKNOWN,
        LOCAL,
        REMOTE,
        MISSING;

    }
}

