/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.search;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.search.GitGrepSearchQuery;
import com.proalpha.pds.gitutils.search.GitGrepSearchSettings;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewContentProvider;
import org.eclipse.egit.ui.internal.repository.RepositoryTreeNodeLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitGrepSearchPage
extends DialogPage
implements ISearchPage {
    private final Logger logger = LoggerFactory.getLogger(GitGrepSearchPage.class);
    private static final String PAGE_NAME = "pAGitGrepSearchPage";
    private static final String HISTORY_STORE = "HISTORY";
    private static final int HISTORY_SIZE = 1;
    private Text txtMatchesFile;
    private Spinner txtMaxFinds;
    private Button btnCaseSensitive;
    private Combo cmbObjectType;
    private CheckboxTableViewer repositoryViewer;
    private ISearchPageContainer container;
    private List<GitGrepSearchSettings> savedSettings = new ArrayList<GitGrepSearchSettings>(1);
    private Combo cmbSearchPhrase;

    public void createControl(Composite parent) {
        this.loadSettings();
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        Label lblContainingText = new Label(main, 0);
        lblContainingText.setText("Containing text:");
        new Label(main, 0);
        this.cmbSearchPhrase = new Combo(main, 2052);
        GridData gdCmbSearchPhrase = new GridData(4, 4, true, false, 1, 1);
        gdCmbSearchPhrase.widthHint = this.convertWidthInCharsToPixels(10);
        this.cmbSearchPhrase.setLayoutData((Object)gdCmbSearchPhrase);
        this.cmbSearchPhrase.setFocus();
        this.cmbSearchPhrase.addModifyListener(event -> this.checkOK());
        this.btnCaseSensitive = new Button(main, 32);
        this.btnCaseSensitive.setText("Case sensitive");
        Label lblHint = new Label(main, 0);
        lblHint.setText("(* = any string, ? = any character, \\\\ = escape for literals: * ? \\\\)");
        Button help = new Button(main, 0);
        help.setText("Git Search Help");
        help.addListener(13, event -> {
            if (event.type == 13 && Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI("https://git-scm.com/docs/git-grep"));
                }
                catch (IOException | URISyntaxException e) {
                    this.logger.error("Error occured while opening git grep help", (Throwable)e);
                }
            }
        });
        Group grpScope = new Group(main, 0);
        GridData gdGrpScope = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdGrpScope.heightHint = 77;
        gdGrpScope.widthHint = 475;
        grpScope.setLayoutData((Object)gdGrpScope);
        grpScope.setText("Scope");
        Label lblMatchesFile = new Label((Composite)grpScope, 0);
        lblMatchesFile.setBounds(10, 18, 122, 15);
        lblMatchesFile.setText("Objectname (can-do):");
        this.txtMatchesFile = new Text((Composite)grpScope, 2048);
        this.txtMatchesFile.setBounds(139, 15, 150, 21);
        this.txtMatchesFile.setText("**/*.*");
        Label lblObjecttype = new Label((Composite)grpScope, 0);
        lblObjecttype.setBounds(10, 44, 70, 15);
        lblObjecttype.setText("Objecttype:");
        this.cmbObjectType = new Combo((Composite)grpScope, 0);
        this.cmbObjectType.setItems(new String[]{"ALL", "PDI", "SRC", "SRC_PDI"});
        this.cmbObjectType.setBounds(139, 41, 60, 23);
        this.cmbObjectType.setText("ALL");
        Label lblMaxfinds = new Label((Composite)grpScope, 0);
        lblMaxfinds.setBounds(10, 70, 100, 15);
        lblMaxfinds.setText("Maxfinds (1 - 999):");
        this.txtMaxFinds = new Spinner((Composite)grpScope, 2048);
        this.txtMaxFinds.setBounds(139, 67, 40, 21);
        this.txtMaxFinds.setSize(50, 20);
        this.txtMaxFinds.setValues(100, 1, 999, 0, 50, 100);
        this.txtMaxFinds.addListener(24, event -> {
            try {
                if (Integer.parseInt(this.txtMaxFinds.getText()) > this.txtMaxFinds.getMaximum()) {
                    this.txtMaxFinds.setSelection(this.txtMaxFinds.getMaximum());
                } else if (Integer.parseInt(this.txtMaxFinds.getText()) < this.txtMaxFinds.getMinimum()) {
                    this.txtMaxFinds.setSelection(this.txtMaxFinds.getMinimum());
                }
            }
            catch (NumberFormatException e) {
                this.txtMaxFinds.setSelection(this.txtMaxFinds.getMinimum());
            }
        });
        new Label(main, 0);
        Group repositoryGroup = new Group(main, 0);
        repositoryGroup.setBackgroundMode(1);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)repositoryGroup);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)repositoryGroup);
        this.repositoryViewer = CheckboxTableViewer.newCheckList((Composite)repositoryGroup, (int)2820);
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)new RepositoryTreeNodeLabelProvider());
        this.repositoryViewer.setContentProvider((IContentProvider)new RepositoriesViewContentProvider());
        this.repositoryViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.repositoryViewer.addCheckStateListener(event -> {
            this.repositoryViewer.setAllChecked(false);
            this.repositoryViewer.setChecked(event.getElement(), true);
            this.checkOK();
        });
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 135).applyTo(this.repositoryViewer.getControl());
        repositoryGroup.setText("Repositories:");
        this.setControl((Control)main);
        Dialog.applyDialogFont((Control)main);
    }

    public boolean performAction() {
        GitGrepSearchSettings searchSettings = new GitGrepSearchSettings();
        if (this.txtMatchesFile.getText().length() > 0) {
            searchSettings.setFileNamePhrase(this.txtMatchesFile.getText());
        }
        searchSettings.setTextPhrase(this.cmbSearchPhrase.getText());
        searchSettings.setFileType(this.cmbObjectType.getText());
        searchSettings.setCaseSensitive(this.btnCaseSensitive.getSelection());
        searchSettings.setMaxFinds(Integer.parseInt(this.txtMaxFinds.getText()));
        Object[] objectArray = this.repositoryViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            try {
                searchSettings.setRepositoryPath(((RepositoryNode)checkedElement).getRepository().getDirectory().getAbsolutePath());
                searchSettings.setBranchName(((RepositoryNode)checkedElement).getRepository().getBranch());
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        this.savedSettings.add(0, searchSettings);
        GitGrepSearchQuery newQuery = new GitGrepSearchQuery(searchSettings);
        NewSearchUI.runQueryInBackground((ISearchQuery)newQuery);
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    private ISearchPageContainer getContainer() {
        return this.container;
    }

    public void dispose() {
        this.storeSettings();
        super.dispose();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.cmbSearchPhrase.setItems(this.getSavedSearchPhrases());
            this.cmbSearchPhrase.setText(this.savedSettings.get(0).getTextPhrase());
            this.txtMatchesFile.setText(this.savedSettings.get(0).getFileNamePhrase());
            this.txtMaxFinds.setSelection(this.savedSettings.get(0).getMaxFinds());
            this.btnCaseSensitive.setSelection(this.savedSettings.get(0).isCaseSensitive());
            this.cmbObjectType.setText(this.savedSettings.get(0).getFileType());
            File file = new File(this.savedSettings.get(0).getRepositoryPath());
            if (file.exists()) {
                try {
                    RepositoryNode node = new RepositoryNode(null, org.eclipse.egit.core.Activator.getDefault().getRepositoryCache().lookupRepository(file));
                    this.repositoryViewer.setChecked((Object)node, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.checkOK();
        }
        super.setVisible(visible);
    }

    private String[] getSavedSearchPhrases() {
        int size = this.savedSettings.size();
        String[] testPhrases = new String[size];
        int iCount = 0;
        while (iCount < size) {
            testPhrases[iCount] = this.savedSettings.get(iCount).getTextPhrase();
            ++iCount;
        }
        return testPhrases;
    }

    private void checkOK() {
        boolean isOk = false;
        if (this.cmbSearchPhrase.getText().length() > 0 && this.repositoryViewer.getCheckedElements().length > 0) {
            isOk = true;
        }
        this.getContainer().setPerformActionEnabled(isOk);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(PAGE_NAME);
        if (section == null) {
            section = dialogSettings.addNewSection(PAGE_NAME);
        }
        return section;
    }

    private void storeSettings() {
        int minSize = Math.min(this.savedSettings.size(), 1);
        IDialogSettings ds = this.getDialogSettings();
        ds.put("HISTORY_SIZE", minSize);
        int iCount = 0;
        while (iCount < minSize) {
            this.savedSettings.get(iCount).save(ds.addNewSection(HISTORY_STORE + iCount));
            ++iCount;
        }
    }

    private void loadSettings() {
        IDialogSettings ds = this.getDialogSettings();
        try {
            int histSize = ds.getInt("HISTORY_SIZE");
            int iCount = 0;
            while (iCount < histSize) {
                IDialogSettings histSettings = ds.getSection(HISTORY_STORE + iCount);
                if (histSettings != null) {
                    this.savedSettings.add(GitGrepSearchSettings.load(histSettings));
                }
                ++iCount;
            }
        }
        catch (Exception ignored) {
            this.savedSettings.add(GitGrepSearchSettings.init());
        }
    }
}

