/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.external;

import com.proalpha.pds.gitutils.external.DbAndBinaryOperation;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbAndBinaryJob
extends Job {
    private final Logger logger = LoggerFactory.getLogger(DbAndBinaryJob.class);
    private final DbAndBinaryOperation operation;

    public DbAndBinaryJob(DbAndBinaryOperation operation) {
        super("Running database reconcile and update of binaries");
        this.operation = operation;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            SubMonitor progressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"checking for relevant updates on current branch...", (int)1);
            this.operation.setProgressMonitor(progressMonitor);
            this.operation.execute();
            DbAndBinaryJob.showResultDialog(this.operation);
        }
        catch (InvocationTargetException e) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)e.getCause().getMessage(), (String)e.getCause().getLocalizedMessage());
                }
            });
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (JobFamilies.CHECKOUT.equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }

    public static void showResultDialog(final DbAndBinaryOperation op) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (op == null) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Load database and binaries", (String)"Something wicked happened: There is no result of the job");
                } else if (op.getCallExitValue() == 0) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Load database and binaries", (String)"Reconcile of database and update of artifacts terminated successfully");
                } else {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Load database and binaries", (String)String.format("Error while running update of database and artifacts (exit value=%s): %s", op.getCallExitValue(), op.getErrMessage()));
                }
            }
        });
    }
}

