/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.proalpha.git.grep.GitCliGrep;
import com.proalpha.git.grep.GrepConfig;
import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.checks.RepositoryTools;
import com.proalpha.pds.paconnector.PaProject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CompileBranchHandler
extends AbstractHandler {
    private static final String COMPILER_FILES = "compiler.pro,compiler.str,compiler.inp";
    private static final String COMP_BRANCH_FILES = "compile all changed branch files";
    private static final Integer MAX_GIT_GREP_SEARCH_COUNT = 50;
    private static final Integer RESULTLIST_MAX_SEARCH_COUNT = 1000;
    private List<String> userexittypes = Arrays.asList("c", "u", "q", "x", "y", "z");
    private List<String> pasourcefiletypes = Arrays.asList("cdf", "cls", "df", "fld", "i", "if", "lib", "tdf", "pds", "w", "p");
    private List<String> allsourcefiletypes = new ArrayList<String>();
    private List<String> ignorefiletypes = Arrays.asList("pdi", "xsd", "cdf");
    private String patempdir = "";
    private String compilerimpfile = "compiler.inp";
    private String gitRepo = "";
    private GrepConfig config = new GrepConfig();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTools repositoryTools = new RepositoryTools(event);
        PaProject paProject = repositoryTools.getPaProject();
        this.config.setSearchScope(GrepConfig.SearchScope.SRC);
        this.config.setBranch(repositoryTools.getBranch());
        this.config.setFilenameonly(true);
        this.config.setIgnoreCase(true);
        this.config.setFileFilter("*");
        this.setGitRepo(repositoryTools.getDirectory());
        this.config.setLimit(1000);
        this.setGitRepo(repositoryTools.getDirectory());
        this.setCompilerimpfile("branchfiles.inp");
        if (!this.checkPreconditions(paProject)) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)COMP_BRANCH_FILES, (String)"There is no active proALPHA project associated with this git repository.\n\nIs the OE project opened and proALPHA running?");
            return null;
        }
        List<String> checkList = repositoryTools.getChangedFilesWithPath();
        if (!checkList.isEmpty()) {
            try {
                if (!this.writeInputFile(checkList)) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)COMP_BRANCH_FILES, (String)"No files to compile found.");
                    return null;
                }
            }
            catch (IOException e) {
                return null;
            }
            paProject.getBridge().startCompilerOpt(this.getCompilerInputFilename(), Boolean.valueOf(true));
        } else {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)COMP_BRANCH_FILES, (String)"No changed files found. compile will not be performed.");
        }
        return null;
    }

    private boolean checkPreconditions(PaProject paProject) {
        if (paProject == null || !paProject.isAvailable()) {
            this.patempdir = "";
            return false;
        }
        this.patempdir = paProject.getBridge().getpAStartupParam("temp", "");
        return this.deleteCompilerFiles();
    }

    private boolean deleteCompilerFiles() {
        File resultFile;
        List<String> fileList = Arrays.asList(COMPILER_FILES);
        for (String filename : fileList) {
            resultFile = new Path(this.patempdir).append(filename).toFile();
            if (!resultFile.isFile()) continue;
            try {
                Files.delete(resultFile.toPath());
            }
            catch (IOException e) {
                return false;
            }
        }
        resultFile = new Path(this.patempdir).append(this.getCompilerimpfile()).toFile();
        if (resultFile.isFile()) {
            try {
                Files.delete(resultFile.toPath());
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    private boolean writeInputFile(List<String> checkList) throws IOException {
        Boolean haswritten = false;
        FileWriter fileWriter = new FileWriter(this.getCompilerInputFilename());
        try (PrintWriter printWriter = new PrintWriter(fileWriter);){
            if (this.allsourcefiletypes.isEmpty()) {
                this.fillpasourcefiletypes();
            }
            List<String> fullcompilelist = this.extendcompilelist(checkList);
            for (String filename : fullcompilelist) {
                printWriter.println(filename);
                haswritten = true;
            }
            if (checkList.size() > 10000) {
                printWriter.println("*");
            }
            boolean bl = haswritten;
            return bl;
        }
    }

    private List<String> getdependentcyFiles(List<String> filenames, Integer depdt, List<String> resList) {
        String searchname = "";
        if ((depdt = Integer.valueOf(depdt + 1)) >= 20) {
            return resList;
        }
        if (resList.size() > RESULTLIST_MAX_SEARCH_COUNT) {
            return resList;
        }
        ArrayList<String> searchList = new ArrayList<String>();
        for (String filename : filenames) {
            String fileext = FilenameUtils.getExtension((String)filename).toLowerCase();
            if (this.ignorefiletypes.contains(fileext) || !fileext.equals("") && !this.allsourcefiletypes.contains(fileext) || resList.contains(filename)) continue;
            searchname = this.getSearchName(filename);
            if (searchname.endsWith("[.]w") || searchname.endsWith("[.]p")) {
                resList.add(filename);
                continue;
            }
            if (searchname.contains("]cls[")) {
                resList.add(searchname.replace("[.]", "/"));
                continue;
            }
            searchList.add(searchname);
        }
        if (searchList.isEmpty()) {
            return resList;
        }
        List<String> newFiles = this.getdependentcyfromGit(searchList);
        resList = this.getdependentcyFiles(newFiles, depdt, resList);
        return resList;
    }

    private List<String> getdependentcyfromGit(List<String> searchlist) {
        ArrayList<String> alldependencies = new ArrayList<String>();
        String searchFileList = "";
        searchFileList = "-e " + searchlist.get(0);
        if (searchlist.size() > 1) {
            for (String singlefile : searchlist) {
                searchFileList = String.valueOf(searchFileList) + " --or -e " + singlefile;
            }
        }
        try {
            GitCliGrep grep = new GitCliGrep(this.getGitRepo(), searchFileList, this.config);
            grep.setGitCLI(Activator.getDefault().getPreferenceStore().getString("PaGitExe"));
            List results = grep.retriveResultLines();
            for (String foundfile : results) {
                if (foundfile.indexOf(58) > -1) {
                    foundfile = foundfile.substring(foundfile.indexOf(58) + 1);
                }
                if (foundfile.lastIndexOf("src/") >= 0) {
                    foundfile = foundfile.substring(foundfile.lastIndexOf("src/") + 4);
                }
                if (alldependencies.contains(foundfile)) continue;
                alldependencies.add(foundfile);
            }
        }
        catch (IOException e) {
            return alldependencies;
        }
        return alldependencies;
    }

    private String getSearchName(String filename) {
        String basename = FilenameUtils.getBaseName((String)filename).toLowerCase();
        if (basename.length() <= 1) {
            return "";
        }
        String fileext = FilenameUtils.getExtension((String)filename).toLowerCase();
        String exittype = basename.substring(basename.length() - 1);
        String prePath = filename.substring(0, filename.lastIndexOf(47) + 1);
        if (fileext.equals("cls")) {
            prePath = prePath.replace("/", "[.]");
            if (basename.endsWith("std")) {
                return String.valueOf(prePath) + basename.substring(0, basename.length() - 3);
            }
            if (this.userexittypes.contains(exittype)) {
                return String.valueOf(prePath) + basename.substring(basename.length() - 2);
            }
            return String.valueOf(prePath) + basename;
        }
        if (fileext.endsWith("w") || fileext.endsWith("p")) {
            return String.valueOf(prePath) + basename + "[.]" + fileext.substring(fileext.length() - 1);
        }
        if (fileext.length() > 0) {
            return String.valueOf(prePath) + basename + "[.]" + fileext.substring(0, 1);
        }
        return String.valueOf(prePath) + basename;
    }

    private void fillpasourcefiletypes() {
        for (String filetype : this.pasourcefiletypes) {
            for (String exittype : this.userexittypes) {
                this.allsourcefiletypes.add(String.valueOf(exittype) + "x" + filetype.substring(0, 1));
            }
            this.allsourcefiletypes.add(filetype);
        }
    }

    private List<String> extendcompilelist(List<String> filelist) {
        ArrayList<String> fullcompilelist = new ArrayList<String>();
        List<String> basenameslist = new ArrayList<String>();
        basenameslist = this.getdependentcyFiles(filelist, 0, basenameslist);
        for (String basename : basenameslist) {
            basename = basename.substring(basename.lastIndexOf(47) + 1);
            if ((basename = basename.replace("[.]", ".")).lastIndexOf(46) > 0) {
                basename = basename.substring(0, basename.lastIndexOf(46));
            }
            fullcompilelist.add(String.valueOf(basename) + "*");
        }
        return fullcompilelist;
    }

    private String getCompilerInputFilename() {
        File compimpfile = new Path(this.patempdir).append(this.getCompilerimpfile()).toFile();
        return compimpfile.toString();
    }

    public String getCompilerimpfile() {
        return this.compilerimpfile;
    }

    public void setCompilerimpfile(String compilerimpfile) {
        this.compilerimpfile = compilerimpfile;
    }

    public String getGitRepo() {
        return this.gitRepo;
    }

    public void setGitRepo(String gitRepo) {
        this.gitRepo = gitRepo;
    }
}

