/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.proalpha.git.grep.GitCliGrep;
import com.proalpha.git.grep.GrepConfig;
import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.checks.RepositoryTools;
import com.proalpha.pds.paconnector.userexit.UserExitFileTypes;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.Path;

public class CollectBranchDependencyFiles {
    private static final Integer RESULTLIST_MAX_SEARCH_COUNT = 1000;
    private List<String> ignorefiletypes = Arrays.asList("pdi", "xsd", "cdf");
    private UserExitFileTypes userexitfiletypes = new UserExitFileTypes();
    private String gitRepoDir = "";
    private String compilerFileName = "";
    private GrepConfig config = new GrepConfig();

    public CollectBranchDependencyFiles(RepositoryTools repositoryTools, String compilerFileName) {
        this.gitRepoDir = repositoryTools.getDirectory();
        this.compilerFileName = compilerFileName;
        this.config.setSearchScope(GrepConfig.SearchScope.SRC);
        this.config.setBranch(repositoryTools.getBranch());
        this.config.setFilenameonly(true);
        this.config.setIgnoreCase(true);
        this.config.setFileFilter("*");
        this.config.setLimit(1000);
    }

    private List<String> extendcompilelist(List<String> filelist) {
        ArrayList<String> fullcompilelist = new ArrayList<String>();
        List<String> basenameslist = new ArrayList<String>();
        basenameslist = this.getdependentcyFiles(filelist, 0, basenameslist);
        for (String basename : basenameslist) {
            basename = basename.substring(basename.lastIndexOf(47) + 1);
            if ((basename = basename.replace("[.]", ".")).lastIndexOf(46) > 0) {
                basename = basename.substring(0, basename.lastIndexOf(46));
            }
            fullcompilelist.add(String.valueOf(basename) + "*");
        }
        return fullcompilelist;
    }

    private List<String> getdependentcyFiles(List<String> filenames, Integer depdt, List<String> resList) {
        String searchname = "";
        if ((depdt = Integer.valueOf(depdt + 1)) >= 20) {
            return resList;
        }
        if (resList.size() > RESULTLIST_MAX_SEARCH_COUNT) {
            return resList;
        }
        ArrayList<String> searchList = new ArrayList<String>();
        for (String filename : filenames) {
            String fileext = FilenameUtils.getExtension((String)filename).toLowerCase();
            if (this.ignorefiletypes.contains(fileext) || !fileext.equals("") && !this.userexitfiletypes.getAllsourcefiletypes().contains(fileext) || resList.contains(filename)) continue;
            searchname = this.getSearchName(filename);
            if (searchname.endsWith("[.]w") || searchname.endsWith("[.]p")) {
                resList.add(filename);
                continue;
            }
            if (searchname.contains("]cls[")) {
                resList.add(searchname.replace("[.]", "/"));
                continue;
            }
            searchList.add(searchname);
        }
        if (searchList.isEmpty()) {
            return resList;
        }
        List<String> newFiles = this.getdependentcyfromGit(searchList);
        resList = this.getdependentcyFiles(newFiles, depdt, resList);
        return resList;
    }

    private String getSearchName(String filename) {
        String basename = FilenameUtils.getBaseName((String)filename).toLowerCase();
        if (basename.length() <= 1) {
            return "";
        }
        String fileext = FilenameUtils.getExtension((String)filename).toLowerCase();
        String exittype = basename.substring(basename.length() - 1);
        String prePath = filename.substring(0, filename.lastIndexOf(47) + 1);
        if (fileext.equals("cls")) {
            prePath = prePath.replace("/", "[.]");
            if (basename.endsWith("std")) {
                return String.valueOf(prePath) + basename.substring(0, basename.length() - 3);
            }
            if (this.userexitfiletypes.getAllsourcefiletypes().contains(exittype)) {
                return String.valueOf(prePath) + basename.substring(basename.length() - 2);
            }
            return String.valueOf(prePath) + basename;
        }
        if (fileext.endsWith("w") || fileext.endsWith("p")) {
            return String.valueOf(prePath) + basename + "[.]" + fileext.substring(fileext.length() - 1);
        }
        if (fileext.length() > 0) {
            return String.valueOf(prePath) + basename + "[.]" + fileext.substring(0, 1);
        }
        return String.valueOf(prePath) + basename;
    }

    private List<String> getdependentcyfromGit(List<String> searchlist) {
        ArrayList<String> alldependencies = new ArrayList<String>();
        StringBuilder searchFileList = new StringBuilder();
        searchFileList.append("-e " + searchlist.get(0));
        if (searchlist.size() > 1) {
            for (String singlefile : searchlist) {
                searchFileList.append(" --or -e " + singlefile);
            }
        }
        try {
            GitCliGrep grep = new GitCliGrep(this.gitRepoDir, searchFileList.toString(), this.config);
            grep.setGitCLI(Activator.getDefault().getPreferenceStore().getString("PaGitExe"));
            List results = grep.retriveResultLines();
            for (String foundfile : results) {
                if (foundfile.indexOf(58) > -1) {
                    foundfile = foundfile.substring(foundfile.indexOf(58) + 1);
                }
                if (foundfile.lastIndexOf("src/") >= 0) {
                    foundfile = foundfile.substring(foundfile.lastIndexOf("src/") + 4);
                }
                if (alldependencies.contains(foundfile)) continue;
                alldependencies.add(foundfile);
            }
        }
        catch (IOException e) {
            return alldependencies;
        }
        return alldependencies;
    }

    public void writeInputFile(List<String> checkList) throws IOException {
        File resultFile;
        Boolean haswritten = false;
        FileWriter fileWriter = new FileWriter(this.compilerFileName);
        try (PrintWriter printWriter = new PrintWriter(fileWriter);){
            List<String> fullcompilelist = this.extendcompilelist(checkList);
            for (String filename : fullcompilelist) {
                printWriter.println(filename);
                haswritten = true;
            }
            if (checkList.size() > 10000) {
                printWriter.println("*");
            }
        }
        if (!haswritten.booleanValue() && (resultFile = new Path(this.compilerFileName).toFile()).isFile()) {
            Files.delete(resultFile.toPath());
        }
    }
}

