/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaProject;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.ui.handlers.HandlerUtil;

public class RepositoryTools {
    private Repository repository;

    public RepositoryTools(Repository repository) {
        this.repository = repository;
    }

    public RepositoryTools(ExecutionEvent event) {
        RepositoryTreeNode treenode = null;
        try {
            treenode = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (treenode != null) {
            this.repository = treenode.getRepository();
        }
    }

    public List<?> getSelectedNodes(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    public List<String> getStagedFiles() {
        Status status = null;
        ArrayList<String> stagesFiles = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Git git = new Git(this.repository);){
                status = git.status().call();
                for (String file : status.getChanged()) {
                    if (file.contains("/")) {
                        stagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    stagesFiles.add(file);
                }
                for (String file : status.getAdded()) {
                    if (file.contains("/")) {
                        stagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    stagesFiles.add(file);
                }
                for (String file : status.getRemoved()) {
                    if (file.contains("/")) {
                        stagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    stagesFiles.add(file);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException | NoWorkTreeException e) {
            e.printStackTrace();
        }
        return stagesFiles;
    }

    public List<String> getUnstagedFiles() {
        Status status = null;
        ArrayList<String> unStagesFiles = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Git git = new Git(this.repository);){
                status = git.status().call();
                for (String file : status.getUntracked()) {
                    if (file.contains("/")) {
                        unStagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    unStagesFiles.add(file);
                }
                for (String file : status.getModified()) {
                    if (file.contains("/")) {
                        unStagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    unStagesFiles.add(file);
                }
                for (String file : status.getConflicting()) {
                    if (file.contains("/")) {
                        unStagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    unStagesFiles.add(file);
                }
                for (String file : status.getMissing()) {
                    if (file.contains("/")) {
                        unStagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    unStagesFiles.add(file);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException | NoWorkTreeException e) {
            e.printStackTrace();
        }
        return unStagesFiles;
    }

    public List<String> getChangedFilesWithPath() {
        Status status = null;
        ArrayList<String> changedFiles = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Git git = new Git(this.repository);){
                status = git.status().call();
                for (String file : status.getModified()) {
                    if (file.contains("src/")) {
                        changedFiles.add(file.substring(file.lastIndexOf("src/") + 4));
                        continue;
                    }
                    changedFiles.add(file);
                }
                for (String file : status.getConflicting()) {
                    if (file.contains("src/")) {
                        changedFiles.add(file.substring(file.lastIndexOf("src/") + 4));
                        continue;
                    }
                    changedFiles.add(file);
                }
                for (String file : status.getAdded()) {
                    if (file.contains("src/")) {
                        changedFiles.add(file.substring(file.lastIndexOf("src/") + 4));
                        continue;
                    }
                    changedFiles.add(file);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException | NoWorkTreeException e) {
            e.printStackTrace();
        }
        return changedFiles;
    }

    public String getDirectory() {
        return this.repository.getDirectory().getPath();
    }

    public String getBranch() {
        try {
            return this.repository.getBranch();
        }
        catch (IOException e) {
            return "";
        }
    }

    public PaProject getPaProject() {
        long countSeparator = this.repository.getDirectory().getAbsolutePath().codePoints().filter(ch -> ch == System.getProperty("file.separator").toCharArray()[0]).count();
        String[] filePathArray = this.repository.getDirectory().getAbsolutePath().split(Matcher.quoteReplacement(System.getProperty("file.separator")));
        IProject project = null;
        project = countSeparator > 3L ? ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(filePathArray[filePathArray.length - 4]) + "-" + filePathArray[filePathArray.length - 3]) : ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(filePathArray[filePathArray.length - 2]) + "-" + filePathArray[filePathArray.length - 1]);
        return Activator.getDefault().getProjectManager().getPaProject(project);
    }

    public List<String> getBranchDiffFiles() {
        List diff;
        String branch = this.getBranch();
        String master_branch = "refs/heads/master";
        if (branch.split(Pattern.quote(".")).length > 1) {
            master_branch = String.valueOf(branch.split(Pattern.quote("."))[0]) + ".master";
        }
        master_branch = this.extendBanchName(master_branch);
        branch = this.extendBanchName(branch);
        AbstractTreeIterator oldTreeParser = RepositoryTools.prepareTreeParser(this.repository, branch);
        AbstractTreeIterator newTreeParser = RepositoryTools.prepareTreeParser(this.repository, master_branch);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Git git = new Git(this.repository);){
                diff = git.diff().setOldTree(oldTreeParser).setNewTree(newTreeParser).call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException e) {
            return null;
        }
        try {
            ArrayList<String> changedFiles = new ArrayList<String>();
            for (DiffEntry entry : diff) {
                String change_type = entry.getChangeType().toString();
                if (change_type.equals("ADD") || change_type.equals("MODIFY")) {
                    changedFiles.add(Paths.get(entry.getNewPath(), new String[0]).getFileName().toString());
                    continue;
                }
                changedFiles.add(Paths.get(entry.getOldPath(), new String[0]).getFileName().toString());
            }
            return changedFiles;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    private static AbstractTreeIterator prepareTreeParser(Repository repository, String branch) throws IOException {
        Ref branchref = repository.exactRef(branch);
        if (branchref != null) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (RevWalk walk = new RevWalk(repository);){
                RevCommit commit = walk.parseCommit((AnyObjectId)branchref.getObjectId());
                RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
                CanonicalTreeParser cronTreeParser = new CanonicalTreeParser();
                Throwable throwable2 = null;
                Object var10_13 = null;
                try (ObjectReader reader = repository.newObjectReader();){
                    cronTreeParser.reset(reader, (AnyObjectId)tree.getId());
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                walk.dispose();
                return cronTreeParser;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        System.out.println("Branch not found: " + branch);
        return null;
    }

    private String extendBanchName(String branch) {
        if (!branch.startsWith("refs/heads/")) {
            branch = "refs/heads/" + branch;
        }
        return branch;
    }
}

