/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.proalpha.pds.gitutils.checks.CollectBranchDependencyFiles;
import com.proalpha.pds.gitutils.checks.RepositoryTools;
import com.proalpha.pds.paconnector.PaProject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CompileBranchJob
extends Job {
    private static final String COMP_BRANCH_FILES = "compile branch files";
    private CollectBranchDependencyFiles collectBranchDependencyFiles = null;
    private String compilerFileName = "";
    List<String> checkList = new ArrayList<String>();
    PaProject paProject = null;

    public CompileBranchJob(String name, RepositoryTools repositoryTools, List<String> checkList, String compilerFileName) {
        super(name);
        this.collectBranchDependencyFiles = new CollectBranchDependencyFiles(repositoryTools, compilerFileName);
        this.paProject = repositoryTools.getPaProject();
        this.checkList = checkList;
        this.compilerFileName = compilerFileName;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)COMP_BRANCH_FILES, (int)10);
        try {
            this.collectBranchDependencyFiles.writeInputFile(this.checkList);
            subMonitor.worked(0);
            File compimpfile = new Path(this.compilerFileName).toFile();
            if (!compimpfile.exists()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)COMP_BRANCH_FILES, (String)"No files to compile found."));
            } else {
                this.paProject.getBridge().startCompilerOpt(this.compilerFileName, Boolean.valueOf(true));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

