/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.proalpha.pds.gitutils.checks.CollectBranchDependencyFiles;
import com.proalpha.pds.gitutils.checks.CompileBranchJob;
import com.proalpha.pds.gitutils.checks.RepositoryTools;
import com.proalpha.pds.paconnector.PaProject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CompileBranchHandler
extends AbstractHandler {
    private static final String COMP_BRANCH_FILES = "compile branch files";
    CollectBranchDependencyFiles branchDeptCollector;
    private String patempdir = "";
    private String compilerimpfile = "compiler.inp";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<String> comittedFiles;
        RepositoryTools repositoryTools = new RepositoryTools(event);
        PaProject paProject = repositoryTools.getPaProject();
        if (!this.checkPreconditions(paProject)) {
            return null;
        }
        this.setCompilerimpfile(String.format("%s_branchfiles.inp", repositoryTools.getBranch()));
        List<String> checkList = repositoryTools.getChangedFilesWithPath();
        try {
            comittedFiles = repositoryTools.getBranchchangedFiles();
        }
        catch (IOException e) {
            return null;
        }
        for (String file : comittedFiles) {
            checkList.add(file);
        }
        if (!checkList.isEmpty()) {
            CompileBranchJob branchDeptCollectorJob = new CompileBranchJob("Collect branch dependency files", repositoryTools, checkList, this.getCompilerInputFilename());
            branchDeptCollectorJob.setUser(true);
            branchDeptCollectorJob.schedule();
        } else {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)COMP_BRANCH_FILES, (String)"No changed files found. compile will not be performed.");
        }
        return null;
    }

    private boolean checkPreconditions(PaProject paProject) {
        this.patempdir = "";
        if (paProject == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)COMP_BRANCH_FILES, (String)"There is no active proALPHA project associated with this git repository.");
            return false;
        }
        if (!paProject.isAvailable()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)COMP_BRANCH_FILES, (String)"proALPHA not available! \n\nIs the OE project opened and proALPHA running?");
            return false;
        }
        this.patempdir = paProject.getBridge().getpAStartupParam("temp", "");
        return true;
    }

    private boolean deleteCompilerFile() {
        File resultFile = new Path(this.getCompilerInputFilename()).toFile();
        if (resultFile.isFile()) {
            try {
                Files.delete(resultFile.toPath());
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    private String getCompilerInputFilename() {
        File compimpfile = new Path(this.patempdir).append(this.getCompilerimpfile()).toFile();
        return compimpfile.toString();
    }

    public String getCompilerimpfile() {
        return this.compilerimpfile;
    }

    public void setCompilerimpfile(String compilerimpfile) {
        this.compilerimpfile = compilerimpfile;
        this.deleteCompilerFile();
    }
}

