/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.checks.CollectBranchDependencyFiles;
import com.proalpha.pds.gitutils.checks.RepositoryTools;
import com.proalpha.pds.paconnector.PaProject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileBranchJob
extends Job {
    private static final String COMP_BRANCH_FILES = "compile branch files";
    private static final String LAST_PROCEDURE_ENV_NAME = "LASTPROCEDURE";
    private CollectBranchDependencyFiles collectBranchDependencyFiles = null;
    private String compilerFileName = "";
    private Integer maxFileCount = 0;
    private Logger logger;
    List<String> checkList = new ArrayList<String>();
    PaProject paProject = null;

    public CompileBranchJob(String name, RepositoryTools repositoryTools, List<String> checkList, String compilerFileName) {
        super(name);
        this.collectBranchDependencyFiles = new CollectBranchDependencyFiles(repositoryTools, compilerFileName);
        this.paProject = repositoryTools.getPaProject();
        this.checkList = checkList;
        this.compilerFileName = compilerFileName;
        this.maxFileCount = this.getMaxCompileCount();
        this.logger = LoggerFactory.getLogger(PaProject.class);
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)COMP_BRANCH_FILES, (int)10);
        try {
            Integer found = this.collectBranchDependencyFiles.writeInputFile(this.checkList);
            subMonitor.worked(0);
            File compimpfile = new Path(this.compilerFileName).toFile();
            if (!compimpfile.exists()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)COMP_BRANCH_FILES, (String)"No files to compile found."));
            } else if (found >= this.maxFileCount) {
                String line;
                this.logger.info("Programms to compile = " + found.toString());
                ArrayList<String> commands = new ArrayList<String>();
                StringBuilder paCcommand = new StringBuilder();
                paCcommand.append(String.valueOf(this.paProject.getBridge().getpAStartupParam("PROALPHADIR", "")) + "\\common\\startup\\server\\pa-adm.bat");
                paCcommand.append(" dev ");
                paCcommand.append(" multi-comp ");
                paCcommand.append("start ");
                paCcommand.append("-p \"UserID=system\" ");
                paCcommand.append("-p \"Password=compakt\" ");
                paCcommand.append("-n ");
                paCcommand.append("-pool active ");
                commands.add("CMD");
                commands.add("/C");
                commands.add(paCcommand.toString());
                ProcessBuilder pb = new ProcessBuilder(commands);
                String env_name = this.env_name_lastprocedure(pb.environment());
                pb.environment().put(env_name, this.compilerFileName);
                this.logger.debug(pb.environment().toString());
                this.logger.debug(pb.command().toString());
                Process p = pb.start();
                BufferedReader bir = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = bir.readLine()) != null) {
                    this.logger.info(line);
                }
            } else {
                this.paProject.getBridge().startCompilerOpt(this.compilerFileName, Boolean.valueOf(true));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private Integer getMaxCompileCount() {
        String maxCountPref = Activator.getDefault().getPreferenceStore().getString("SingleCompileMaxFileCount");
        try {
            return Integer.parseInt(maxCountPref);
        }
        catch (NumberFormatException e) {
            maxCountPref = "100";
            return 100;
        }
    }

    private String env_name_lastprocedure(Map<String, String> envparam) {
        for (Map.Entry<String, String> e : envparam.entrySet()) {
            if (!e.getKey().toUpperCase().equals(LAST_PROCEDURE_ENV_NAME)) continue;
            return e.getKey();
        }
        return LAST_PROCEDURE_ENV_NAME;
    }
}

