/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.external;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.mylyn.ActionResult;
import com.proalpha.pds.gitutils.mylyn.ReconcileActionSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbAndBinaryOperation {
    private static final String ERROR_OCCURED = "Error {0} occured";
    private final Logger logger = LoggerFactory.getLogger(DbAndBinaryOperation.class);
    private Repository repository;
    private ReconcileActionSettings recoActionSettings;
    private List<ActionResult> actionResults = new ArrayList<ActionResult>();
    private SubMonitor monitor;

    public DbAndBinaryOperation(Repository repository, ReconcileActionSettings recoSettings) {
        this.repository = repository;
        this.recoActionSettings = recoSettings;
    }

    public void execute() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                List<String> stages = DbAndBinaryOperation.this.recoActionSettings.getPaUpdateStages();
                DbAndBinaryOperation.this.monitor.setWorkRemaining(stages.size());
                String gitDir = DbAndBinaryOperation.this.repository.getDirectory().getAbsolutePath();
                File parentDir = new File(gitDir.substring(0, gitDir.lastIndexOf(File.separator)));
                String errorMsg = "";
                int callExitValue = -1;
                for (String stage : stages) {
                    DbAndBinaryOperation.this.monitor.setTaskName("Running action: " + stage);
                    ActionResult actionStageResult = new ActionResult(stage);
                    try {
                        Process process = DbAndBinaryOperation.this.createPaUpdateStageProcess(parentDir, stage, DbAndBinaryOperation.this.monitor);
                        if (process == null) continue;
                        DbAndBinaryOperation.this.parseOutputstream(DbAndBinaryOperation.this.monitor, actionStageResult, process);
                        DbAndBinaryOperation.this.monitor.worked(1);
                        callExitValue = process.waitFor();
                        if (callExitValue <= 0) continue;
                        DbAndBinaryOperation.this.parseErrorstream(actionStageResult, process);
                        errorMsg = MessageFormat.format("Error while running stage restore_repository of python package pa_update with exitcode {0}", callExitValue);
                        Activator.logToConsole(errorMsg);
                        DbAndBinaryOperation.this.logError(errorMsg, actionStageResult);
                        if (!stage.equals("updateartifacts")) continue;
                        DbAndBinaryOperation.this.restoreRepositoryToIntialCommit(parentDir, DbAndBinaryOperation.this.monitor);
                        break;
                    }
                    catch (IOException e) {
                        callExitValue = 1;
                        errorMsg = MessageFormat.format("Exception while running stage restore_repository of python package pa_update with exitcode {0} and {1}", callExitValue, e.getMessage());
                        DbAndBinaryOperation.this.logError(errorMsg, actionStageResult);
                    }
                    catch (InterruptedException e) {
                        errorMsg = MessageFormat.format(DbAndBinaryOperation.ERROR_OCCURED, e.getMessage());
                        DbAndBinaryOperation.this.logError(errorMsg, actionStageResult);
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        DbAndBinaryOperation.this.monitor.done();
                        DbAndBinaryOperation.this.actionResults.add(actionStageResult);
                    }
                }
                this.deleteReconcileFile(parentDir);
            }

            private void deleteReconcileFile(File parentDir) {
                Path reconcileFile = Paths.get(parentDir.getAbsolutePath(), "reconcile");
                try {
                    Files.delete(reconcileFile);
                }
                catch (Exception e) {
                    DbAndBinaryOperation.this.logger.error("an error occured while deleting reconcilefile in {}", (Object)reconcileFile);
                }
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)r);
    }

    private Process createPaUpdateStageProcess(File parentDir, String stage, SubMonitor monitor) {
        String errorMsg = "";
        ActionResult actionStageResult = new ActionResult(stage);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("python", "-u", "-m", "pa_update", "--stage", stage, "--topodir", parentDir.toString(), "--env", "dev");
        builder.directory(parentDir);
        builder.redirectErrorStream(true);
        builder.redirectInput(ProcessBuilder.Redirect.PIPE);
        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        Process process = null;
        try {
            this.logger.info("Start reconcile action: Running '{}' in {}", builder.command(), (Object)parentDir);
            process = builder.start();
            return process;
        }
        catch (IOException e) {
            Integer callExitValue = 1;
            errorMsg = MessageFormat.format("Exception while running stage {0} of python package pa_update with exitcode {1} and {2}", stage, callExitValue, e.getMessage());
            this.logError(errorMsg, actionStageResult);
            return process;
        }
    }

    private void restoreRepositoryToIntialCommit(File parentDir, SubMonitor monitor) {
        String errorMsg = "";
        ActionResult actionStageResult = new ActionResult("restore_repository");
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("python", "-u", "-m", "pa_update", "--stage", "restore_repository", "--topodir", parentDir.toString(), "--env", "dev");
        builder.directory(parentDir);
        builder.redirectErrorStream(true);
        builder.redirectInput(ProcessBuilder.Redirect.PIPE);
        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        try {
            try {
                Process p = builder.start();
                this.logger.info("Start restoring action: Running '{}' in {}", builder.command(), (Object)parentDir);
                this.parseOutputstream(monitor, actionStageResult, p);
                monitor.worked(1);
                Integer callExitValue = p.waitFor();
                if (callExitValue > 0) {
                    this.parseErrorstream(actionStageResult, p);
                    errorMsg = MessageFormat.format("Error while running stage restore_repository of python package pa_update with exitcode {0}", callExitValue);
                    Activator.logToConsole(errorMsg);
                    actionStageResult.addToLog(errorMsg);
                    actionStageResult.setStatus("FAIL");
                    this.logger.error("Error while running stage restore_repository of python package pa_update with exitcode {}", (Object)callExitValue);
                    this.displayError(errorMsg);
                }
                this.displayWarning();
            }
            catch (IOException e) {
                Integer callExitValue = 1;
                errorMsg = MessageFormat.format("Exception while running stage restore_repository of python package pa_update with exitcode {0} and {1}", callExitValue, e.getMessage());
                this.logError(errorMsg, actionStageResult);
                monitor.done();
                this.actionResults.add(actionStageResult);
            }
            catch (InterruptedException e) {
                errorMsg = MessageFormat.format(ERROR_OCCURED, e.getMessage());
                this.logError(errorMsg, actionStageResult);
                Thread.currentThread().interrupt();
                monitor.done();
                this.actionResults.add(actionStageResult);
            }
        }
        finally {
            monitor.done();
            this.actionResults.add(actionStageResult);
        }
    }

    private void logError(String errorMsg, ActionResult actionStageResult) {
        actionStageResult.addToLog(errorMsg);
        actionStageResult.setStatus("FAIL");
        this.logger.error(errorMsg);
    }

    private void displayWarning() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Repository Status", (String)"The repository was resetted to the branch of the artifacts commit-id.");
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseErrorstream(ActionResult actionStageResult, Process p) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStreamReader rErr = new InputStreamReader(p.getErrorStream());
            try {
                try (BufferedReader inErr = new BufferedReader(rErr);){
                    String line;
                    do {
                        if ((line = inErr.readLine()) == null) continue;
                        actionStageResult.addToLog(line);
                        Activator.logToConsole(line);
                    } while (line != null);
                }
                if (rErr == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (rErr == null) throw throwable;
                ((Reader)rErr).close();
                throw throwable;
            }
            ((Reader)rErr).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseOutputstream(SubMonitor monitor, ActionResult actionStageResult, Process p) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            InputStreamReader rOut = new InputStreamReader(p.getInputStream());
            try {
                try (BufferedReader inOut = new BufferedReader(rOut);){
                    String line;
                    do {
                        if ((line = inOut.readLine()) == null) continue;
                        int indexOfFourthSpace = StringUtils.ordinalIndexOf((String)line, (String)" ", (int)4);
                        if (indexOfFourthSpace > -1) {
                            monitor.setTaskName(line.substring(indexOfFourthSpace));
                        }
                        actionStageResult.addToLog(line);
                        Activator.logToConsole(line);
                    } while (line != null);
                }
                if (rOut == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (rOut == null) throw throwable;
                ((Reader)rOut).close();
                throw throwable;
            }
            ((Reader)rOut).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void displayError(final String errorMsg) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Repository Status", (String)MessageFormat.format("{0}. The repository and proalpha may be asynchronous! If errors occur, contact the IDE-Support", errorMsg));
            }
        });
    }

    public void setProgressMonitor(SubMonitor monitor) {
        this.monitor = monitor;
    }

    public List<ActionResult> getActionResults() {
        return this.actionResults;
    }
}

