/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.checks.CompileOptions;
import com.proalpha.pds.gitutils.checks.CompileType;
import com.proalpha.pds.gitutils.checks.RepositoryTools;
import com.proalpha.pds.paconnector.PaProject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileJob
extends Job {
    private static final String LAST_PROCEDURE_ENV_NAME = "LASTPROCEDURE";
    private Integer maxFileCount = 0;
    private Logger logger;
    private RepositoryTools repositoryTools = null;
    private CompileOptions options;
    private File compilerInputFile = null;

    public CompileJob(String name, RepositoryTools repositoryTools, CompileOptions options) {
        super(name);
        this.repositoryTools = repositoryTools;
        this.options = options;
        this.maxFileCount = this.getMaxCompileCount();
        this.logger = LoggerFactory.getLogger(PaProject.class);
    }

    private boolean checkPreconditions(PaProject paProject) {
        if (paProject == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Compile Job", (String)"There is no active proALPHA project associated with this git repository.");
                }
            });
            return false;
        }
        if (!paProject.isAvailable()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Compile Job", (String)"proALPHA not available! \n\nIs the OE project opened and proALPHA running?");
                }
            });
            return false;
        }
        return true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!this.checkPreconditions(this.repositoryTools.getPaProject())) {
            return Status.CANCEL_STATUS;
        }
        String paTmpDir = this.repositoryTools.getPaProject().getBridge().getpAStartupParam("temp", "");
        this.compilerInputFile = new Path(paTmpDir).append(this.options.compilerInputFileName).toFile();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Compile Job", (int)3);
        try {
            try {
                subMonitor.worked(0);
                this.deleteCompilerFile(this.compilerInputFile);
                if (this.createCompInputFile()) {
                    List<String> filesToCompile = this.readCompilerInputFile();
                    subMonitor.worked(1);
                    this.runCompiler(filesToCompile);
                    if (this.options.type == CompileType.DELTA) {
                        try {
                            ObjectId head = this.repositoryTools.getRepository().resolve("HEAD");
                            Activator.writeObjectCodeInfoFile(this.repositoryTools.getRepository(), head.getName());
                        }
                        catch (IOException e) {
                            this.logger.error("Error while writing objectcodeinfo file: {}\n Stack:\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                IStatus iStatus = Status.CANCEL_STATUS;
                subMonitor.done();
                return iStatus;
            }
        }
        finally {
            subMonitor.done();
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createCompInputFile() {
        Integer callExitValue = -1;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (this.options.type == CompileType.BRANCH) {
            builder.command("python", "-m", "pa_update.compiler", "-r", this.repositoryTools.getRepository().getWorkTree().getAbsolutePath(), "--branch", "--no-compile", "--input-file", this.compilerInputFile.getAbsolutePath());
        }
        if (this.options.type == CompileType.DIFF) {
            builder.command("python", "-m", "pa_update.compiler", "-r", this.repositoryTools.getRepository().getWorkTree().getAbsolutePath(), "--from", this.options.commit1, "--to", this.options.commit2, "--no-compile", "--input-file", this.compilerInputFile.getAbsolutePath());
        }
        if (this.options.type == CompileType.DELTA) {
            builder.command("python", "-m", "pa_update.compiler", "-r", this.repositoryTools.getRepository().getWorkTree().getAbsolutePath(), "--delta", "--no-compile", "--input-file", this.compilerInputFile.getAbsolutePath());
        }
        builder.redirectErrorStream(true);
        builder.redirectInput(ProcessBuilder.Redirect.PIPE);
        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        try {
            String errorMsg;
            String line;
            Throwable throwable;
            Process p;
            block29: {
                p = builder.start();
                this.logger.info("Start of compiler file generation:  Running '{}'", builder.command());
                Throwable throwable2 = null;
                throwable = null;
                try {
                    InputStreamReader rOut = new InputStreamReader(p.getInputStream());
                    try {
                        try (BufferedReader inOut = new BufferedReader(rOut);){
                            do {
                                if ((line = inOut.readLine()) == null) continue;
                                Activator.logToConsole(line);
                            } while (line != null);
                        }
                        if (rOut == null) break block29;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        if (rOut == null) throw throwable2;
                        ((Reader)rOut).close();
                        throw throwable2;
                    }
                    ((Reader)rOut).close();
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            callExitValue = p.waitFor();
            if (callExitValue <= 0) return true;
            InputStreamReader rErr = new InputStreamReader(p.getErrorStream());
            throwable = null;
            Object var6_14 = null;
            try (BufferedReader inErr = new BufferedReader(rErr);){
                do {
                    if ((line = inErr.readLine()) == null) continue;
                    Activator.logToConsole(line);
                } while (line != null);
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
            if (callExitValue > 1) {
                errorMsg = MessageFormat.format("Error while generating compiler input file {0} for git repo {1}\n\nSee console output for more information.", this.compilerInputFile.getAbsolutePath(), this.repositoryTools.getRepository().getWorkTree().getAbsolutePath());
                Activator.logToConsole(errorMsg);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Compile Job", (String)errorMsg);
                    }
                });
            }
            if (callExitValue != 1) return false;
            errorMsg = "No files to compile";
            Activator.logToConsole("No files to compile");
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Compile Job", (String)"No files to compile");
                }
            });
            return false;
        }
        catch (IOException e) {
            String errorMsg = MessageFormat.format("Exception while running python package pa_update.compiler with exitcode {0} and {1}", callExitValue, e.getMessage());
            this.logger.error(errorMsg);
            return false;
        }
        catch (InterruptedException e) {
            String errorMsg = MessageFormat.format("Error {0} occured", e.getMessage());
            this.logger.error(errorMsg);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private Integer getMaxCompileCount() {
        String maxCountPref = Activator.getDefault().getPreferenceStore().getString("SingleCompileMaxFileCount");
        try {
            return Integer.parseInt(maxCountPref);
        }
        catch (NumberFormatException e) {
            maxCountPref = "100";
            return 100;
        }
    }

    private String envNameLastprocedure(Map<String, String> envparam) {
        for (Map.Entry<String, String> e : envparam.entrySet()) {
            if (!e.getKey().toUpperCase().equals(LAST_PROCEDURE_ENV_NAME)) continue;
            return e.getKey();
        }
        return LAST_PROCEDURE_ENV_NAME;
    }

    private List<String> readCompilerInputFile() {
        ArrayList<String> resultList = new ArrayList<String>();
        if (!this.compilerInputFile.exists()) {
            return resultList;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(this.compilerInputFile));){
                String line = reader.readLine();
                while (line != null) {
                    resultList.add(line);
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resultList;
    }

    private boolean deleteCompilerFile(File compFile) {
        if (compFile.isFile()) {
            try {
                Files.delete(compFile.toPath());
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    private void runCompiler(List<String> filesToCompile) throws IOException {
        this.logger.info("Programms to compile = {}", (Object)filesToCompile.toString());
        if (filesToCompile.size() >= this.maxFileCount || filesToCompile.size() == 1 && filesToCompile.get(0).equals("*")) {
            String line;
            ArrayList<String> commands = new ArrayList<String>();
            StringBuilder paCcommand = new StringBuilder();
            paCcommand.append(String.valueOf(this.repositoryTools.getPaProject().getBridge().getpAStartupParam("PROALPHADIR", "")) + "\\common\\startup\\server\\pa-adm.bat");
            paCcommand.append(" dev ");
            paCcommand.append(" multi-comp ");
            paCcommand.append("start ");
            paCcommand.append("-p \"UserID=system\" ");
            paCcommand.append("-p \"Password=compakt\" ");
            paCcommand.append("-n ");
            paCcommand.append("-pool active ");
            commands.add("CMD");
            commands.add("/C");
            commands.add(paCcommand.toString());
            ProcessBuilder pb = new ProcessBuilder(commands);
            String env_name = this.envNameLastprocedure(pb.environment());
            pb.environment().put(env_name, this.compilerInputFile.getAbsolutePath());
            this.logger.debug(pb.environment().toString());
            this.logger.debug(pb.command().toString());
            Process p = pb.start();
            BufferedReader bir = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = bir.readLine()) != null) {
                this.logger.info(line);
            }
        } else {
            this.repositoryTools.getPaProject().getBridge().startCompilerOpt(this.compilerInputFile.getAbsolutePath(), Boolean.valueOf(true));
        }
    }
}

