/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.proalpha.pds.gitutils.checks.CompileBranchesWizard;
import com.proalpha.pds.gitutils.checks.RepositoryTools;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileBranchesDiffHandler<T extends RepositoryTreeNode<?>>
extends AbstractHandler {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTools reptools = new RepositoryTools(event);
        if (reptools.getRepository() != null) {
            CompileBranchesWizard wizzard = new CompileBranchesWizard(reptools.getRepository());
            WizardDialog wdl = new WizardDialog(this.getShell(event), (IWizard)wizzard);
            if (wdl.open() == 0) {
                this.logger.debug("Ok pressed");
            } else {
                this.logger.debug("Cancel pressed");
            }
        } else {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"no repository found", (String)"Error while get git repo. no repo selected / found");
        }
        return null;
    }

    public Shell getShell(ExecutionEvent event) {
        return HandlerUtil.getActiveShell((ExecutionEvent)event);
    }
}

