/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.git.tests;

import com.proalpha.git.tests.PaBranchNameTest;
import com.proalpha.git.tests.PaGitGrepTest;
import com.proalpha.git.tests.PaGitTransTest;
import com.proalpha.git.tests.PaIssueConveyanceTest;
import com.proalpha.git.tests.PaIssueExplorerTest;
import com.proalpha.git.tests.PaRepositoryTest;
import com.proalpha.pds.gitutils.pagit.PaGit;
import com.proalpha.pds.gitutils.pagit.exceptions.PaGitGrepException;
import com.proalpha.pds.gitutils.pagit.util.PaBranchName;
import com.proalpha.pds.gitutils.pagit.util.PaIssueExplorer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={PaBranchNameTest.class, PaGitGrepTest.class, PaGitTransTest.class, PaIssueConveyanceTest.class, PaIssueExplorerTest.class, PaRepositoryTest.class})
public class PaGitTest {
    public static final String GIT_DIRECTORY = String.valueOf(System.getProperty("user.dir")) + "\\resources\\pa-unit";
    public static final String TMP_GIT_DIRECTORY = String.valueOf(System.getProperty("user.dir")) + "\\tmp\\unit-test";
    public static final String REP_URL = "https://git.proalpha.com/scm/test/unit-test.git";
    private static final String GIT_USER = "proalpha_unittest";
    private static final String GIT_PASSWORD = "MC3gTN7fqluqPAY7rBff";
    public static final String COPY_REP_URL = "https://git.proalpha.com/scm/test/unit-test-tmp.git";
    public static UsernamePasswordCredentialsProvider credentials;

    @BeforeClass
    public static void globalSetup() throws GitAPIException, IOException {
        credentials = new UsernamePasswordCredentialsProvider(GIT_USER, GIT_PASSWORD);
        if (new File(TMP_GIT_DIRECTORY).exists()) {
            FileUtils.deleteQuietly((File)new File(TMP_GIT_DIRECTORY));
        }
        ((CloneCommand)Git.cloneRepository().setDirectory(new File(TMP_GIT_DIRECTORY)).setURI(REP_URL).setBare(false).setCloneAllBranches(true).setCredentialsProvider((CredentialsProvider)credentials)).call();
        PaGit.init(Git.open((File)new File(TMP_GIT_DIRECTORY)));
        PaGit.getInstance().setCredentialProvider((CredentialsProvider)credentials);
        PaGit.getInstance().setProgressMonitor((ProgressMonitor)new TextProgressMonitor((Writer)new PrintWriter(System.out)));
        for (Ref ref : PaGit.getInstance().getGit().branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call()) {
            try {
                PaGit.getInstance().getGit().branchCreate().setStartPoint(ref.getName()).setName(PaBranchName.getShortBranchName(ref.getName())).call();
            }
            catch (RefAlreadyExistsException refAlreadyExistsException) {
                // empty catch block
            }
        }
        PaIssueExplorer.DATE_OF_ARAMIS_GOLIVE = "01.01.1970";
    }

    @AfterClass
    public static void globalCleanup() throws GitAPIException, IOException {
        PaGit.getInstance().close();
        FileUtils.deleteQuietly((File)new File(TMP_GIT_DIRECTORY));
    }

    @Test
    public void testRepository() throws IOException, PaGitGrepException {
        assert (new File(TMP_GIT_DIRECTORY).exists());
    }
}

