/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.model.ijra;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.proalpha.pds.gitutils.pagit.PaGitConfig;
import com.proalpha.pds.gitutils.pagit.model.ijra.JiraSprint;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraIssue {
    private final Logger logger = LoggerFactory.getLogger(JiraIssue.class);
    private Map<String, Object> issue = null;
    private ArrayList<JiraSprint> sprints = null;

    public JiraIssue(Map<String, Object> issue) {
        this.issue = issue;
    }

    public JiraIssue(InputStream is) {
        try {
            this.issue = (Map)new ObjectMapper().readValue(is, HashMap.class);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
    }

    public boolean isInWflState(String[] states) {
        if (this.issue == null || this.getStatusName() == null) {
            return false;
        }
        List<String> statesLowerCase = Arrays.asList(states);
        statesLowerCase.replaceAll(String::toLowerCase);
        return statesLowerCase.contains(this.getStatusName().toLowerCase());
    }

    public boolean isForVersion(String version) {
        return true;
    }

    public Map<String, Object> getIssue() {
        return this.issue;
    }

    public Map<Object, Object> getFields() {
        return this.getFields(true);
    }

    public Map<Object, Object> getFields(boolean versionedRep) {
        Map<Object, Object> fields = new LinkedHashMap<Object, Object>();
        if (versionedRep && this.issue != null && this.issue.containsKey("versionedRepresentations")) {
            fields = (Map)this.issue.get("versionedRepresentations");
        } else if (!versionedRep && this.issue != null && this.issue.containsKey("fields")) {
            fields = (Map)this.issue.get("fields");
        }
        return fields;
    }

    public String getKey() {
        if (this.issue != null) {
            return (String)this.issue.get("key");
        }
        return null;
    }

    public String getStatusName() {
        Map status;
        if (this.getFields().containsKey("status") && (status = (Map)this.getFields().get("status")) != null) {
            return (String)((Map)status.get("1")).get("name");
        }
        return null;
    }

    public List<JiraSprint> getSprints() {
        Map sprintCustomFieldEntry;
        ArrayList<JiraSprint> jiraSprints = new ArrayList<JiraSprint>();
        String sprintField = PaGitConfig.getStringFromConfig("jira.sprintfield");
        if (sprintField.isEmpty()) {
            sprintField = "customfield_10004";
        }
        if (this.sprints == null && this.getFields().containsKey(sprintField) && (sprintCustomFieldEntry = (Map)this.getFields().get(sprintField)) != null) {
            ArrayList jsonSprints = (ArrayList)sprintCustomFieldEntry.get("2");
            for (Map jsonSprint : jsonSprints) {
                JiraSprint newSprint = (JiraSprint)new ObjectMapper().convertValue((Object)jsonSprint, JiraSprint.class);
                if (newSprint == null) continue;
                jiraSprints.add(newSprint);
            }
            this.sprints = jiraSprints;
        }
        return this.sprints;
    }

    public JiraSprint getActiveSprint() {
        ArrayList jiraSprints = (ArrayList)this.getSprints();
        for (JiraSprint jSprint : jiraSprints) {
            if (!jSprint.getState().matches("active")) continue;
            return jSprint;
        }
        return null;
    }

    public String getActiveSprintName() {
        JiraSprint jSprint = this.getActiveSprint();
        if (jSprint != null) {
            return jSprint.getName();
        }
        return null;
    }

    public List<Map<String, Object>> getSubtasks() {
        Map subtaskFieldEntry;
        ArrayList jsonSubtasks = new ArrayList();
        if (this.getFields().containsKey("subtasks") && (subtaskFieldEntry = (Map)this.getFields().get("subtasks")) != null) {
            jsonSubtasks = (ArrayList)subtaskFieldEntry.get("1");
        }
        return jsonSubtasks;
    }

    public boolean hasSubtasks() {
        return !((ArrayList)this.getSubtasks()).isEmpty();
    }

    public boolean hasSubtask(String key) {
        ArrayList jsonSubTasks = (ArrayList)this.getSubtasks();
        for (Map jsonSubtask : jsonSubTasks) {
            if (!jsonSubtask.get("key").toString().equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public String getParentKey() {
        Map parentFieldEntry;
        if (this.getFields(false).containsKey("parent") && (parentFieldEntry = (Map)this.getFields(false).get("parent")) != null) {
            return parentFieldEntry.get("key").toString();
        }
        return null;
    }
}

