/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.model.server;

import com.proalpha.pds.gitutils.pagit.util.PaBranchName;
import com.proalpha.pds.gitutils.pagit.util.bitbucket.BitbucketRestCallGetBranchList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GitServerRepository {
    protected String name;
    protected String description;
    protected String project = "";
    protected ServerType serverType;
    protected List<String> availableRefs = new ArrayList<String>();

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public void setServerType(ServerType serverType) {
        this.serverType = serverType;
    }

    public void setAvailableRefs(List<String> availableRefs) {
        this.availableRefs = availableRefs;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProject() {
        return this.project;
    }

    public String getDisplayName() {
        if (this.serverType == ServerType.BITBUCKET) {
            return String.valueOf(this.project) + '/' + this.name;
        }
        return this.name;
    }

    public List<String> getAvailableRefs() {
        if (this.serverType == ServerType.BITBUCKET && this.availableRefs.isEmpty()) {
            this.loadRefsOfBitbucketRepository();
        }
        return this.availableRefs;
    }

    private void loadRefsOfBitbucketRepository() {
        BitbucketRestCallGetBranchList restcall = new BitbucketRestCallGetBranchList();
        restcall.setSubUrl(String.format("projects/%s/repos/%s/branches", this.getProject(), this.getName()));
        restcall.execute();
        this.availableRefs.addAll((Collection)restcall.getRestResponse());
    }

    public void addRef(String availableRef) {
        this.availableRefs.add(availableRef);
    }

    public List<String> getBranches() {
        ArrayList<String> result = new ArrayList<String>();
        for (String ref : this.getAvailableRefs()) {
            if (!ref.startsWith("refs/heads/")) continue;
            result.add(PaBranchName.getBranchName(ref));
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof GitServerRepository)) {
            return false;
        }
        GitServerRepository otherRepo = (GitServerRepository)other;
        return otherRepo.getName().equals(this.getName()) && otherRepo.getProject().equals(this.getProject());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static enum ServerType {
        GITBLIT,
        BITBUCKET;

    }
}

