/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.oauth.util;

import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.collect.ImmutableMap;
import com.proalpha.pds.gitutils.pagit.oauth.util.AtlassianOAuthClient;
import com.proalpha.pds.gitutils.pagit.oauth.util.Command;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthClient {
    private final Logger logger = LoggerFactory.getLogger(OAuthClient.class);
    private final Map<Command, Function<List<String>, Optional<Exception>>> actionHandlers;
    private final AtlassianOAuthClient atlassianOAuthClient;
    private HttpResponse response;

    public HttpResponse getResponse() {
        return this.response;
    }

    public OAuthClient(AtlassianOAuthClient atlassianOAuthClient) {
        this.atlassianOAuthClient = atlassianOAuthClient;
        this.actionHandlers = ImmutableMap.builder().put((Object)Command.REQUEST, this::handleGetRequest).build();
    }

    public void execute(Command action, List<String> arguments) {
        this.actionHandlers.getOrDefault((Object)action, this::handleUnknownCommand).apply(arguments).ifPresent(ex -> this.logger.error(ex.getMessage()));
    }

    private Optional<Exception> handleUnknownCommand(List<String> arguments) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Command not supported. Only {} are supported. Supplied arguments: {}", (Object)Command.names(), arguments);
        }
        return Optional.empty();
    }

    private Optional<Exception> handleGetRequest(List<String> arguments) {
        String url = arguments.get(0);
        try {
            OAuthParameters parameters = this.atlassianOAuthClient.getParameters();
            this.response = OAuthClient.getResponseFromUrl(parameters, new GenericUrl(url));
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
    }

    private static HttpResponse getResponseFromUrl(OAuthParameters parameters, GenericUrl appUrl) throws IOException {
        HttpRequestFactory requestFactory = new NetHttpTransport().createRequestFactory((HttpRequestInitializer)parameters);
        HttpRequest request = requestFactory.buildGetRequest(appUrl);
        return request.execute();
    }
}

