/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.util.bitbucket;

import com.google.api.client.http.HttpResponse;
import com.proalpha.pds.gitutils.pagit.PaGitConfig;
import com.proalpha.pds.gitutils.pagit.oauth.util.AtlassianOAuthClient;
import com.proalpha.pds.gitutils.pagit.oauth.util.Command;
import com.proalpha.pds.gitutils.pagit.oauth.util.OAuthClient;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BitbucketRestCall<T> {
    private final Logger logger = LoggerFactory.getLogger(BitbucketRestCall.class);
    private final String baseUrl = PaGitConfig.getStringFromConfig("bitbucket.server");
    private final String path = PaGitConfig.getStringFromConfig("bitbucket.path");
    private final AtlassianOAuthClient atlassianOAuthClient = new AtlassianOAuthClient(AtlassianOAuthClient.ApplicationType.bitbucket);
    private final OAuthClient client = new OAuthClient(this.atlassianOAuthClient);
    private static final Integer PAGE_SIZE = 100;
    private T restResponse;
    private String subUrl;
    private Integer startEntry = 0;

    public T getRestResponse() {
        return this.restResponse;
    }

    public String getSubUrl() {
        return this.subUrl;
    }

    public void setSubUrl(String subUrl) {
        this.subUrl = subUrl;
    }

    public Integer getStartEntry() {
        return this.startEntry;
    }

    public void setStartEntry(Integer startEntry) {
        this.startEntry = startEntry;
    }

    public void execute() {
        String requestUrl = this.buildUrl();
        ArrayList<String> parameter = new ArrayList<String>();
        parameter.add(requestUrl);
        this.client.execute(Command.REQUEST, parameter);
        HttpResponse response = this.client.getResponse();
        try {
            this.restResponse = this.parseRestResponse(response);
        }
        catch (IOException e) {
            this.logger.debug(e.getMessage());
        }
    }

    private String buildUrl() {
        StringBuilder sb = new StringBuilder(this.baseUrl);
        sb.append(this.path);
        sb.append(this.subUrl);
        sb.append("?limit=");
        sb.append(PAGE_SIZE);
        sb.append("&start=");
        sb.append(this.startEntry);
        return sb.toString();
    }

    protected abstract T parseRestResponse(HttpResponse var1) throws IOException;
}

