/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.util.jira;

import com.google.api.client.http.HttpResponse;
import com.proalpha.pds.gitutils.pagit.PaGitConfig;
import com.proalpha.pds.gitutils.pagit.model.ijra.JiraIssue;
import com.proalpha.pds.gitutils.pagit.oauth.util.AtlassianOAuthClient;
import com.proalpha.pds.gitutils.pagit.oauth.util.Command;
import com.proalpha.pds.gitutils.pagit.oauth.util.OAuthClient;
import java.io.InputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraRestCall {
    private final Logger logger = LoggerFactory.getLogger(JiraRestCall.class);
    private final String url;
    private final String path;

    public JiraRestCall(String url) {
        this.url = url;
        this.path = PaGitConfig.getStringFromConfig("jira.path");
    }

    public JiraRestCall() {
        this(PaGitConfig.getStringFromConfig("jira.server"));
    }

    public JiraIssue getIssue(String key) {
        JiraIssue issue = null;
        String jiraURL = String.valueOf(this.url) + this.path + key + "?expand=versionedRepresentations";
        try {
            AtlassianOAuthClient jiraOAuthClient = new AtlassianOAuthClient(AtlassianOAuthClient.ApplicationType.jira);
            OAuthClient client = new OAuthClient(jiraOAuthClient);
            ArrayList<String> parameter = new ArrayList<String>();
            parameter.add(jiraURL);
            client.execute(Command.REQUEST, parameter);
            HttpResponse response = client.getResponse();
            Throwable throwable = null;
            Object var9_11 = null;
            try (InputStream in = response.getContent();){
                issue = new JiraIssue(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
        }
        return issue;
    }
}

