/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.git.tests;

import com.proalpha.pds.gitutils.pagit.util.PaBranchName;
import org.junit.Assert;
import org.junit.Test;

public class PaBranchNameTest {
    @Test
    public void isValidRef() {
        assert (PaBranchName.isValidRef("71.UT-1"));
        assert (PaBranchName.isValidRef("master"));
        assert (PaBranchName.isValidRef("71c01"));
        assert (PaBranchName.isValidRef("71c01.UT-1"));
        assert (PaBranchName.isValidRef("71.master"));
        assert (PaBranchName.isValidRef("refs/heads/71.UT-1"));
        assert (PaBranchName.isValidRef("refs/heads/master"));
        assert (PaBranchName.isValidRef("refs/heads/71.master"));
        Assert.assertFalse((boolean)PaBranchName.isValidRef("abc"));
        Assert.assertFalse((boolean)PaBranchName.isValidRef("71.abc"));
        Assert.assertFalse((boolean)PaBranchName.isValidRef("71.UT-abc"));
        Assert.assertFalse((boolean)PaBranchName.isValidRef("71c01.abc"));
        Assert.assertFalse((boolean)PaBranchName.isValidRef("71c01.UT-abc"));
    }

    @Test
    public void testFeatureBranchCheck() {
        assert (PaBranchName.isFeatureBranch("71.UT-1"));
        assert (PaBranchName.isFeatureBranch("UT-1"));
        assert (PaBranchName.isFeatureBranch("UNIT-1"));
        Assert.assertFalse((boolean)PaBranchName.isFeatureBranch("master"));
        Assert.assertFalse((boolean)PaBranchName.isFeatureBranch("71.master"));
        assert (PaBranchName.isFeatureBranch("refs/heads/71.UT-1"));
        Assert.assertFalse((boolean)PaBranchName.isFeatureBranch("refs/heads/master"));
        Assert.assertFalse((boolean)PaBranchName.isFeatureBranch("refs/heads/71.master"));
        Assert.assertFalse((boolean)PaBranchName.isFeatureBranch("refs/heads/71.XYZ_Sprint_1"));
        Assert.assertFalse((boolean)PaBranchName.isFeatureBranch("71.XYZ_Sprint_1"));
        Assert.assertFalse((boolean)PaBranchName.isFeatureBranch("refs/heads/XYZ_Sprint_1"));
        Assert.assertFalse((boolean)PaBranchName.isFeatureBranch("XYZ_Sprint_1"));
    }

    @Test
    public void testSprintBranchCheck() {
        Assert.assertFalse((boolean)PaBranchName.isSprintBranch("71.UT-1"));
        Assert.assertFalse((boolean)PaBranchName.isSprintBranch("UT-1"));
        Assert.assertFalse((boolean)PaBranchName.isSprintBranch("UNIT-1"));
        Assert.assertFalse((boolean)PaBranchName.isSprintBranch("master"));
        Assert.assertFalse((boolean)PaBranchName.isSprintBranch("71.master"));
        Assert.assertFalse((boolean)PaBranchName.isSprintBranch("refs/heads/71.UT-1"));
        Assert.assertFalse((boolean)PaBranchName.isSprintBranch("refs/heads/master"));
        Assert.assertFalse((boolean)PaBranchName.isSprintBranch("refs/heads/71.master"));
        assert (PaBranchName.isSprintBranch("refs/heads/71.XYZ_Sprint_1"));
        assert (PaBranchName.isSprintBranch("71.XYZ_Sprint_1"));
        assert (PaBranchName.isSprintBranch("refs/heads/XYZ_Sprint_1"));
        assert (PaBranchName.isSprintBranch("XYZ_Sprint_1"));
    }

    @Test
    public void testMasterBranchCheck() {
        Assert.assertFalse((boolean)PaBranchName.isMasterBranch("71.UT-1"));
        assert (PaBranchName.isMasterBranch("master"));
        assert (PaBranchName.isMasterBranch("71.master"));
        Assert.assertFalse((boolean)PaBranchName.isMasterBranch("refs/heads/UT-1"));
        assert (PaBranchName.isMasterBranch("refs/heads/master"));
        assert (PaBranchName.isMasterBranch("refs/heads/71.master"));
        Assert.assertFalse((boolean)PaBranchName.isMasterBranch("refs/heads/71.XYZ_Sprint_1"));
        Assert.assertFalse((boolean)PaBranchName.isMasterBranch("71.XYZ_Sprint_1"));
        Assert.assertFalse((boolean)PaBranchName.isMasterBranch("refs/heads/XYZ_Sprint_1"));
        Assert.assertFalse((boolean)PaBranchName.isMasterBranch("XYZ_Sprint_1"));
    }

    @Test
    public void testCodeFreezeCheck() {
        Assert.assertFalse((boolean)PaBranchName.isCodeFreezeBranch("UT-1"));
        Assert.assertFalse((boolean)PaBranchName.isCodeFreezeBranch("master"));
        assert (PaBranchName.isCodeFreezeBranch("71b01"));
        Assert.assertFalse((boolean)PaBranchName.isCodeFreezeBranch("refs/heads/UT-1"));
        Assert.assertFalse((boolean)PaBranchName.isCodeFreezeBranch("refs/heads/master"));
        assert (PaBranchName.isCodeFreezeBranch("refs/heads/71b01"));
    }

    @Test
    public void testGetIssue() {
        Assert.assertNull((Object)PaBranchName.getIssue("71.master"));
        Assert.assertNull((Object)PaBranchName.getIssue("refs/heads/71.master"));
        Assert.assertNull((Object)PaBranchName.getIssue("71b01"));
        Assert.assertNull((Object)PaBranchName.getIssue("refs/heads.71b01"));
        Assert.assertEquals((Object)"UNIT-1", (Object)PaBranchName.getIssue("71.UNIT-1"));
        Assert.assertEquals((Object)"UNIT-1", (Object)PaBranchName.getIssue("UNIT-1"));
        Assert.assertEquals((Object)"UNIT-1", (Object)PaBranchName.getIssue("refs/heads/71.UNIT-1"));
        Assert.assertEquals((Object)"UT-2", (Object)PaBranchName.getIssue("71.UT-2"));
        Assert.assertEquals((Object)"UT-2", (Object)PaBranchName.getIssue("refs/heads/71.UT-2"));
        Assert.assertEquals((Object)"UT-2", (Object)PaBranchName.getIssue("71b01.UT-2"));
        Assert.assertEquals((Object)"UT-2", (Object)PaBranchName.getIssue("refs/heads/71b01.UT-2"));
    }

    @Test
    public void testGetVersion() {
        Assert.assertEquals((Object)"71", (Object)PaBranchName.getVersion("71.master"));
        Assert.assertEquals((Object)"71", (Object)PaBranchName.getVersion("refs/heads/71.master"));
        Assert.assertEquals((Object)"71b01", (Object)PaBranchName.getVersion("71b01"));
        Assert.assertEquals((Object)"71b01", (Object)PaBranchName.getVersion("refs/heads/71b01"));
        Assert.assertEquals((Object)"71", (Object)PaBranchName.getVersion("71.UT-2"));
        Assert.assertEquals((Object)"71", (Object)PaBranchName.getVersion("refs/heads/71.UT-2"));
        Assert.assertEquals((Object)"71b01", (Object)PaBranchName.getVersion("71b01.UT-2"));
        Assert.assertEquals((Object)"71b01", (Object)PaBranchName.getVersion("refs/heads/71b01.UT-2"));
        Assert.assertNull((Object)PaBranchName.getVersion("71.DOES_NOT_EXIST"));
    }

    @Test
    public void testGetBranchName() {
        Assert.assertEquals((Object)"71.UT-2", (Object)PaBranchName.getBranchName("71.UT-2"));
        Assert.assertEquals((Object)"origin/71.UT-2", (Object)PaBranchName.getBranchName("refs/remotes/origin/71.UT-2"));
        Assert.assertEquals((Object)"origin/71.UT-2", (Object)PaBranchName.getBranchName("origin/71.UT-2"));
        Assert.assertEquals((Object)"71.UT-2", (Object)PaBranchName.getBranchName("refs/heads/71.UT-2"));
        Assert.assertEquals((Object)"71.DOES_NOT_EXIST", (Object)PaBranchName.getBranchName("71.DOES_NOT_EXIST"));
        Assert.assertEquals((Object)"71.UT-2", (Object)PaBranchName.getBranchName("refs/heads/71.UT-2"));
        Assert.assertEquals((Object)"71.DOES_NOT_EXIST", (Object)PaBranchName.getBranchName("71.DOES_NOT_EXIST"));
        Assert.assertEquals((Object)"origin/DOES_NOT_EXIST", (Object)PaBranchName.getBranchName("origin/DOES_NOT_EXIST"));
        Assert.assertEquals((Object)"origin/DOES_NOT_EXIST", (Object)PaBranchName.getBranchName("refs/remotes/origin/DOES_NOT_EXIST"));
    }

    @Test
    public void testGetShortBranchName() {
        Assert.assertEquals((Object)"71.UT-2", (Object)PaBranchName.getShortBranchName("71.UT-2"));
        Assert.assertEquals((Object)"71.UT-2", (Object)PaBranchName.getShortBranchName("refs/remotes/origin/71.UT-2"));
        Assert.assertEquals((Object)"71.UT-2", (Object)PaBranchName.getShortBranchName("origin/71.UT-2"));
        Assert.assertEquals((Object)"71.UT-2", (Object)PaBranchName.getShortBranchName("refs/heads/71.UT-2"));
        Assert.assertEquals((Object)"71.DOES_NOT_EXIST", (Object)PaBranchName.getShortBranchName("71.DOES_NOT_EXIST"));
        Assert.assertEquals((Object)"71.UT-2", (Object)PaBranchName.getShortBranchName("refs/heads/71.UT-2"));
        Assert.assertEquals((Object)"71.DOES_NOT_EXIST", (Object)PaBranchName.getShortBranchName("71.DOES_NOT_EXIST"));
        Assert.assertEquals((Object)"DOES_NOT_EXIST", (Object)PaBranchName.getShortBranchName("origin/DOES_NOT_EXIST"));
        Assert.assertEquals((Object)"DOES_NOT_EXIST", (Object)PaBranchName.getShortBranchName("refs/remotes/origin/DOES_NOT_EXIST"));
    }
}

