/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.git.tests;

import com.proalpha.pds.gitutils.pagit.util.PaBranchName;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class PaGitHookServerTest {
    private static final String GIT_USER = "proalpha_unittest";
    private static final String GIT_PASSWORD = "MC3gTN7fqluqPAY7rBff";
    private static final String GIT_MAIL = "IDE2010Support@proalpha.de";
    private static final String TMP_GIT_DIRECTORY = String.valueOf(System.getProperty("user.dir")) + "\\tmp\\unit-test-tmp";
    private static final String REP_URL = "https://git.proalpha.com/scm/test/unit-test-tmp.git";
    private static Map<String, String> branches = new HashMap<String, String>();
    private static Git git;
    private static UsernamePasswordCredentialsProvider credentials;

    @BeforeClass
    public static void globalSetup() throws GitAPIException, IOException {
        credentials = new UsernamePasswordCredentialsProvider(GIT_USER, GIT_PASSWORD);
        if (new File(TMP_GIT_DIRECTORY).exists()) {
            FileUtils.deleteQuietly((File)new File(TMP_GIT_DIRECTORY));
        }
        ((CloneCommand)Git.cloneRepository().setDirectory(new File(TMP_GIT_DIRECTORY)).setURI(REP_URL).setBare(false).setCloneAllBranches(true).setCredentialsProvider((CredentialsProvider)credentials)).call();
        git = Git.open((File)new File(TMP_GIT_DIRECTORY));
        for (Ref ref : git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call()) {
            String branch = PaBranchName.getShortBranchName(ref.getName(), git.getRepository());
            branches.put(branch, ref.getObjectId().name());
            git.branchCreate().setForce(true).setStartPoint(ref.getName()).setName(branch).call();
        }
    }

    @AfterClass
    public static void globalCleanup() throws GitAPIException, IOException {
        git.close();
        FileUtils.deleteQuietly((File)new File(TMP_GIT_DIRECTORY));
    }

    private static void reset() throws CheckoutConflictException, GitAPIException {
        git.reset().setMode(ResetCommand.ResetType.HARD).call();
        for (String branch : branches.keySet()) {
            String id = branches.get(branch);
            if (id != null) {
                git.checkout().setName(PaBranchName.getShortBranchName(branch, git.getRepository())).setForce(true).call();
                git.reset().setMode(ResetCommand.ResetType.HARD).setRef(id).call();
                git.checkout().setName("master").setForce(true).call();
            } else {
                git.branchDelete().setBranchNames(new String[]{branch}).call();
            }
            RefSpec refSpec = new RefSpec().setSource(id).setDestination("refs/heads/" + branch);
            ((PushCommand)git.push().setRefSpecs(new RefSpec[]{refSpec}).setForce(true).setCredentialsProvider((CredentialsProvider)credentials)).setRemote("origin").call();
        }
        Collection refs = ((LsRemoteCommand)Git.lsRemoteRepository().setHeads(false).setCredentialsProvider((CredentialsProvider)credentials)).setRemote(REP_URL).call();
        for (Ref ref : refs) {
            String branch = PaBranchName.getShortBranchName(ref.getName(), git.getRepository());
            if (branches.containsKey(branch)) continue;
            RefSpec refSpec = new RefSpec().setSource(null).setDestination(ref.getName());
            ((PushCommand)git.push().setRefSpecs(new RefSpec[]{refSpec}).setForce(true).setCredentialsProvider((CredentialsProvider)credentials)).setRemote("origin").call();
        }
    }

    private boolean isPushOk(String ref) throws GitAPIException {
        RefSpec refSpec = new RefSpec().setDestination(ref);
        Iterable results = ((PushCommand)git.push().setRefSpecs(new RefSpec[]{refSpec}).setCredentialsProvider((CredentialsProvider)credentials)).setRemote("origin").call();
        if (!results.iterator().hasNext()) {
            return false;
        }
        PushResult result = (PushResult)results.iterator().next();
        System.out.println("Answer of push: " + result.getMessages());
        return result.getRemoteUpdate(ref).getStatus() == RemoteRefUpdate.Status.UP_TO_DATE || result.getRemoteUpdate(ref).getStatus() == RemoteRefUpdate.Status.OK;
    }

    @Test
    public void testValidBranchName() throws CheckoutConflictException, FileNotFoundException, GitAPIException {
        try {
            String ref = "refs/heads/71.TST-146";
            Assert.assertTrue((String)"Push was rejected, but the branch should already exist and was not be updated. This is always a successful action", (boolean)this.isPushOk(ref));
            ref = "refs/heads/81.master";
            Assert.assertFalse((String)"Push was accepted,  but we disallow pushes to the master branches.", (boolean)this.isPushOk(ref));
            ref = "refs/heads/72c03";
            Assert.assertFalse((String)"Push was accepted, but we disallow pushes to code-freeze branches.", (boolean)this.isPushOk(ref));
            ref = "refs/heads/TST-146";
            Assert.assertTrue((String)"Push was rejected, but the branch is a valid feature branch.", (boolean)this.isPushOk(ref));
            ref = "refs/heads/72.my-really-cool-branch";
            Assert.assertFalse((String)"Push was accepted, but the branch name is invalid.", (boolean)this.isPushOk(ref));
        }
        finally {
            PaGitHookServerTest.reset();
        }
    }

    @Test
    public void testBranchSyntax() throws InvalidRemoteException, TransportException, GitAPIException {
        try {
            String ref = "refs/heads/TST-1";
            Assert.assertTrue((String)"Push was rejected, but the branch name is valid.", (boolean)this.isPushOk(ref));
            ref = "refs/heads/71.UT-FORBIDDEN";
            Assert.assertFalse((String)"Push was accepted, but the branch name is not valid.", (boolean)this.isPushOk(ref));
            ref = "refs/heads/71TST-1";
            Assert.assertFalse((String)"Push was accepted, but the branch name is not valid.", (boolean)this.isPushOk(ref));
            ref = "refs/heads.71f";
            Assert.assertFalse((String)"Push was accepted, but the branch name is not valid.", (boolean)this.isPushOk(ref));
            ref = "refs/heads.71";
            Assert.assertFalse((String)"Push was accepted, but the branch name is not valid.", (boolean)this.isPushOk(ref));
        }
        finally {
            PaGitHookServerTest.reset();
        }
    }

    @Test
    public void testcommitMsgBranchName() throws GitAPIException, FileNotFoundException {
        try {
            Assert.assertTrue((String)"Push was rejected, but the commit msg has a issue key.", (boolean)this.performTextualChange("refs/heads/71.TST-146", "TST-146.txt", "TST-146: Unit test..."));
            Assert.assertTrue((String)"Push was rejected, but the commit message has a valid issue key.", (boolean)this.performTextualChange("refs/heads/72.TST-146", "TST-147.txt", "TST-147: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, but the commit msg's issue key differ.", (boolean)this.performTextualChange("refs/heads/71.TST-93", "TST-146.txt", "TST-146: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, but the commit is on the master branch that is only updated via pull request.", (boolean)this.performTextualChange("refs/heads/71.master", "TST-93.txt", "TST-93: Unit test..."));
            Assert.assertFalse((String)"Push was acce\ufffdted, but the commit is on a code freeze branch that is only updated via pull request", (boolean)this.performTextualChange("refs/heads/71c03", "TST-93.txt", "TST-93: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, but the commit message's issue key is different from the branch name.", (boolean)this.performTextualChange("refs/heads/72.TST-93", "TST-146.txt", "TST-146: Unit test..."));
        }
        finally {
            PaGitHookServerTest.reset();
        }
    }

    @Test
    public void testcommitMsgIssueKey() throws GitAPIException, FileNotFoundException {
        try {
            Assert.assertTrue((String)"Push was rejected, but the commit msg has a issue key.", (boolean)this.performTextualChange("refs/heads/71.TST-146", "TST-146.txt", "TST-146: Unit test..."));
            Assert.assertTrue((String)"Push was rejected, but the commit msg has a issue key.", (boolean)this.performTextualChange("refs/heads/72.TST-146", "TST-147.txt", "TST-147: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, but the commit msg has no issue key.", (boolean)this.performTextualChange("refs/heads/72.TST-146", "TST-146.txt", "Unit test..."));
            Assert.assertFalse((String)"Push was accepted, but the commit msg has no issue key.", (boolean)this.performTextualChange("refs/heads/71.TST-146", "TST-146.txt", "Unit test..."));
            Assert.assertFalse((String)"Push was accepted, but the commit msg is on master branch.", (boolean)this.performTextualChange("refs/heads/71.master", "TST-93.txt", "TST-93: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, but the commit msg has no issue key.", (boolean)this.performTextualChange("refs/heads/71.master", "TST-146.txt", "Unit test..."));
        }
        finally {
            PaGitHookServerTest.reset();
        }
    }

    @Test
    public void testJiraVersion() {
    }

    @Test
    public void testJiraWfl() throws GitAPIException, FileNotFoundException {
        try {
            Assert.assertTrue((String)"Push was rejected, though the JIRA workflow and the issues appearance in the current sprint should allow a push.", (boolean)this.performTextualChange("refs/heads/72.TST-146", "TST-146.txt", "TST-146: Unit test..."));
            Assert.assertTrue((String)"Push was rejected, though the JIRA workflow and the issues appearance in the current sprint should allow a push.", (boolean)this.performTextualChange("refs/heads/72.TST-147", "TST-147.txt", "TST-147: Unit test..."));
            Assert.assertTrue((String)"Push was rejected, though the JIRA workflow and the issues appearance in the current sprint should allow a push cause TST-147 is a subtask of TST-146.", (boolean)this.performTextualChange("refs/heads/72.TST-146", "TST-147.txt", "TST-147: Unit test..."));
            Assert.assertTrue((String)"Push was rejected, because the JIRA issue is not in the current sprint, but we now accept such cases to allow call processing outside the scope of a sprint.", (boolean)this.performTextualChange("refs/heads/71.TST-92", "TST-92.txt", "TST-92: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, though the JIRA issue is not in the current sprint.", (boolean)this.performTextualChange("refs/heads/71.TST-91", "tst-91.txt", "TST-91: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, though the JIRA issue is not in the current sprint.", (boolean)this.performTextualChange("refs/heads/71.TST-93", "tst-93.txt", "TST-93: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, but the jira workflow is not open for commits on feature branch.", (boolean)this.performTextualChange("refs/heads/72.TST-91", "tst-91.txt", "TST-91: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, but the jira workflow is not open for commits on feature branch.", (boolean)this.performTextualChange("refs/heads/72.TST-93", "tst-93.txt", "TST-93: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, though no manual update of master should be allowed", (boolean)this.performTextualChange("refs/heads/71.master", "TST-146.txt", "TST-146: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, though no manual update of master should be allowed", (boolean)this.performTextualChange("refs/heads/71.master", "tst-162.txt", "TST-162: Unit test..."));
        }
        finally {
            PaGitHookServerTest.reset();
        }
    }

    @Test
    public void testSprintBranchCommits() throws GitAPIException, FileNotFoundException {
        try {
            Assert.assertTrue((String)"Push was rejected, though the JIRA workflow and the issues appearance in the current sprint should allow a push cause TST-147 is a subtask of TST-146.", (boolean)this.performTextualChange("refs/heads/71.TestBoar_Sprint_2", "TST-147.txt", "TST-147: Unit test..."));
            Assert.assertTrue((String)"Push was rejected, though the JIRA workflow and the issues appearance in the current sprint should allow a push cause TST-147 is a subtask of TST-146.", (boolean)this.performTextualChange("refs/heads/71.TestBoar_Sprint_2", "TST-146.txt", "TST-146: Unit test..."));
            Assert.assertTrue((String)"Push was rejected, though the JIRA workflow and the issues appearance in the current sprint should allow a push cause TST-147 is a subtask of TST-146.", (boolean)this.performTextualChange("refs/heads/72.TestBoar_Sprint_2", "TST-147.txt", "TST-147: Unit test..."));
            Assert.assertTrue((String)"Push was rejected, though the JIRA workflow and the issues appearance in the current sprint should allow a push cause TST-147 is a subtask of TST-146.", (boolean)this.performTextualChange("refs/heads/72.TestBoar_Sprint_2", "TST-146.txt", "TST-146: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, though the committed issue is not in the SprintJIRA workflow and the issues appearance in the current sprint should allow a push cause TST-147 is a subtask of TST-146.", (boolean)this.performTextualChange("refs/heads/72.TestBoar_Sprint_2", "TST-91.txt", "TST-91: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, though the committed issue is not in the SprintJIRA workflow and the issues appearance in the current sprint should allow a push cause TST-147 is a subtask of TST-146.", (boolean)this.performTextualChange("refs/heads/71.TestBoar_Sprint_2", "TST-91.txt", "TST-91: Unit test..."));
            Assert.assertFalse((String)"Push was rejected, though the sprint branch on which does not belong to a valid sprint.", (boolean)this.performTextualChange("refs/heads/71.TestBoar_Sprint_9999", "TST-147.txt", "TST-147: Unit test..."));
            Assert.assertFalse((String)"Push was rejected, though the sprint branch on which does not belong to a valid sprint.", (boolean)this.performTextualChange("refs/heads/71.TestBoar_Sprint_9999", "TST-146.txt", "TST-146: Unit test..."));
        }
        finally {
            PaGitHookServerTest.reset();
        }
    }

    @Ignore
    @Test
    public void testFileSize() throws GitAPIException, FileNotFoundException {
        try {
            Assert.assertTrue((String)"Push was rejected, though the added file is not too large.", (boolean)this.performTextualChange("refs/heads/71.TST-146", "TST-146a.txt", 10000, "TST-146: Unit test..."));
            Assert.assertTrue((String)"Push was rejected, though the added file, which is actually very large, is on the white list", (boolean)this.performTextualChange("refs/heads/71.TST-146", "TST-146b.pdi", 10000000, "TST-146: Unit test..."));
            Assert.assertTrue((String)"Push was rejected, though the added file is not too large.", (boolean)this.performTextualChange("refs/heads/71.TST-146", "TST-147d.txt", 10000, "TST-147: Unit test..."));
            Assert.assertTrue((String)"Push was rejected, though the added file, which is actually very large, is on the white list", (boolean)this.performTextualChange("refs/heads/71.TST-146", "TST-147e.pdi", 10000000, "TST-147: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, though the added file is too large and not on the whitelist", (boolean)this.performTextualChange("refs/heads/71.TST-146", "TST-146c.abc", 10000000, "TST-146: Unit test..."));
        }
        finally {
            PaGitHookServerTest.reset();
        }
    }

    @Ignore
    @Test
    public void testFileBinarity() throws GitAPIException, FileNotFoundException, IOException {
        try {
            Assert.assertTrue((String)"Push was rejected, though the added file, which is actually binary, is on the white list", (boolean)this.performBinaryChange("refs/heads/71.TST-146", "TST-146.pdi", 10000, "TST-146: Unit test..."));
            Assert.assertTrue((String)"Push was rejected, though the added file, which is actually binary, is on the white list", (boolean)this.performBinaryChange("refs/heads/72.TST-146", "TST-146.pdi", 10000, "TST-146: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, though the added file is binary.", (boolean)this.performBinaryChange("refs/heads/71.TST-146", "TST-146.bin", 10000, "TST-146: Unit test..."));
            Assert.assertFalse((String)"Push was accepted, though the added file is binary.", (boolean)this.performBinaryChange("refs/heads/72.TST-146", "TST-146.bin", 10000, "TST-146: Unit test..."));
        }
        finally {
            PaGitHookServerTest.reset();
        }
    }

    private void createBinaryFile(String name, int size) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(String.valueOf(TMP_GIT_DIRECTORY) + "\\" + name));){
            int i = 0;
            while (i < size) {
                ((OutputStream)output).write(0);
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createTextFile(String name, int size) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(String.valueOf(TMP_GIT_DIRECTORY) + "\\" + name);
        int i = 0;
        while (i < size) {
            writer.print('A');
            ++i;
        }
        writer.close();
    }

    private boolean performTextualChange(String ref, String file, String message) throws GitAPIException, FileNotFoundException {
        return this.performTextualChange(ref, file, 1, message);
    }

    private boolean performTextualChange(String ref, String file, int size, String message) throws GitAPIException, FileNotFoundException {
        this.checkoutBranch(ref);
        this.createTextFile(file, size);
        git.add().addFilepattern(file).call();
        git.commit().setAuthor(GIT_USER, GIT_MAIL).setCommitter(GIT_USER, GIT_MAIL).setMessage(message).call();
        return this.isPushOk(ref);
    }

    private boolean performBinaryChange(String ref, String file, int size, String message) throws GitAPIException, FileNotFoundException, IOException {
        this.checkoutBranch(ref);
        this.createBinaryFile(file, size);
        git.add().addFilepattern(file).call();
        git.commit().setAuthor(GIT_USER, GIT_MAIL).setCommitter(GIT_USER, GIT_MAIL).setMessage(message).call();
        return this.isPushOk(ref);
    }

    private void checkoutBranch(String refName) throws GitAPIException {
        List refs = git.branchList().call();
        for (Ref ref : refs) {
            if (!refName.equals(ref.getName())) continue;
            git.checkout().setCreateBranch(false).setForce(true).setName(PaBranchName.getShortBranchName(refName, git.getRepository())).call();
            return;
        }
        git.checkout().setCreateBranch(true).setForce(true).setName(PaBranchName.getShortBranchName(refName, git.getRepository())).call();
    }
}

