/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.git.tests;

import com.proalpha.pds.gitutils.pagit.PaGit;
import com.proalpha.pds.gitutils.pagit.exceptions.PaGitTransException;
import com.proalpha.pds.gitutils.pagit.util.PaGitTransaction;
import java.io.IOException;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.junit.Assert;
import org.junit.Test;

public class PaGitTransTest {
    @Test
    public void testVerySimpleRollback() throws IOException, GitAPIException, PaGitTransException {
        String branch = PaGit.getInstance().getGit().getRepository().getBranch();
        String origCommitId = PaGit.getInstance().getGit().getRepository().resolve("HEAD").getName();
        PaGitTransaction trans = new PaGitTransaction(branch);
        PaGit.getInstance().getGit().commit().setMessage("UR-1: Unit test to rollback").call();
        String imCommitId = PaGit.getInstance().getGit().getRepository().resolve("HEAD").getName();
        trans.rollback();
        Assert.assertFalse((String)"The intermediate commit id is the same as the original commit id, i.e., the test case could not apply a commit", (origCommitId == imCommitId ? 1 : 0) != 0);
        Assert.assertEquals((String)"The original commit id is different from the final commit id, i.e., the rollback was not successful\t", (Object)origCommitId, (Object)PaGit.getInstance().getGit().getRepository().resolve("HEAD").getName());
    }

    @Test
    public void testVerySimpleRollbackWithBranchChange() throws IOException, GitAPIException, PaGitTransException {
        String branchToChange = PaGit.getInstance().getGit().getRepository().getBranch();
        String branchToSwitchTo = null;
        for (Ref r : PaGit.getInstance().getGit().branchList().call()) {
            if (r.getName().endsWith(branchToChange)) continue;
            branchToSwitchTo = r.getName();
            break;
        }
        if (branchToSwitchTo == null) {
            for (Ref r : PaGit.getInstance().getGit().branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call()) {
                if (r.getName().endsWith(branchToChange)) continue;
                PaGit.getInstance().getGit().branchCreate().setForce(true).setName("unit-tmp").setStartPoint(r.getName()).call();
                branchToSwitchTo = "refs/heads/unit-tmp";
                break;
            }
        }
        Assert.assertNotNull((String)"No branch to switch to, i.e., the repository seems to have one branch only?", branchToSwitchTo);
        String origCommitIdOfFirstBranch = PaGit.getInstance().getGit().getRepository().resolve(branchToChange).getName();
        String origCommitIdOfSndBranch = PaGit.getInstance().getGit().getRepository().resolve(branchToSwitchTo).getName();
        PaGitTransaction trans = new PaGitTransaction(branchToChange);
        PaGit.getInstance().getGit().commit().setMessage("UR-1: Unit test to rollback with changing the branch").call();
        String imCommitIdOfFirstBranch = PaGit.getInstance().getGit().getRepository().resolve("HEAD").getName();
        PaGit.getInstance().getGit().checkout().setName(branchToSwitchTo).setStartPoint(branchToSwitchTo).call();
        String imCommitIdOfSndBranch = PaGit.getInstance().getGit().getRepository().resolve("HEAD").getName();
        trans.rollback();
        String finalCommitIdOfFirstBranch = PaGit.getInstance().getGit().getRepository().resolve(branchToChange).getName();
        String finalCommitIdOfSndBranch = PaGit.getInstance().getGit().getRepository().resolve(branchToSwitchTo).getName();
        Assert.assertEquals((String)"The rollback action changed the branch that was checked out by the test case.", (Object)branchToSwitchTo, (Object)PaGit.getInstance().getGit().getRepository().getFullBranch());
        Assert.assertFalse((String)"The intermediate commit id is the same as the original commit id, i.e., the test case could not apply a commit.", (origCommitIdOfFirstBranch == imCommitIdOfFirstBranch ? 1 : 0) != 0);
        Assert.assertEquals((String)"The original commit id is different from the final commit id, i.e., the rollback was not successful.", (Object)origCommitIdOfFirstBranch, (Object)finalCommitIdOfFirstBranch);
        Assert.assertEquals((String)"The original commit id is different from the final commit id, i.e., the rollback was not successful.", (Object)origCommitIdOfFirstBranch, (Object)finalCommitIdOfFirstBranch);
        Assert.assertEquals((String)"The tip's commit id of the branch we changed differs after changing to the branch? It seems that a branch, which should not be touched changed?", (Object)origCommitIdOfSndBranch, (Object)imCommitIdOfSndBranch);
        Assert.assertEquals((String)"The tip's commit id of the branch we changed after the end of this test case? It seems that a branch, which should not be touched changed?", (Object)origCommitIdOfSndBranch, (Object)finalCommitIdOfSndBranch);
    }

    @Test
    public void testSimpleRollback() throws IOException, GitAPIException, PaGitTransException {
        String branch = PaGit.getInstance().getGit().getRepository().getBranch();
        String origCommitId = PaGit.getInstance().getGit().getRepository().resolve("HEAD").getName();
        PaGitTransaction trans = new PaGitTransaction(branch);
        PaGit.getInstance().getGit().commit().setMessage("UR-1: Unit test to rollback - 1").call();
        PaGit.getInstance().getGit().commit().setMessage("UR-1: Unit test to rollback - 2").call();
        PaGit.getInstance().getGit().commit().setMessage("UR-1: Unit test to rollback - 3").call();
        String imCommitId = PaGit.getInstance().getGit().getRepository().resolve("HEAD").getName();
        trans.rollback();
        Assert.assertFalse((String)"The intermediate commit id is the same as the original commit id, i.e., the test case could not apply a commit", (origCommitId == imCommitId ? 1 : 0) != 0);
        Assert.assertEquals((String)"The original commit id is different from the final commit id, i.e., the rollback was not successful\t", (Object)origCommitId, (Object)PaGit.getInstance().getGit().getRepository().resolve("HEAD").getName());
    }
}

