/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.git.tests;

import com.proalpha.pds.gitutils.pagit.PaGit;
import com.proalpha.pds.gitutils.pagit.commands.PaIssueConveyanceCommand;
import com.proalpha.pds.gitutils.pagit.exceptions.PaCherryPickException;
import com.proalpha.pds.gitutils.pagit.model.grep.PaCherryPickResult;
import com.proalpha.pds.gitutils.pagit.util.PaCommitMsg;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class PaIssueConveyanceTest {
    private List<String> getListOfChangedFiles(RevCommit c) throws IOException {
        RevTree prevCommitTree = null;
        RevTree thisCommitTree = c.getTree();
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (RevWalk revWalk = new RevWalk(PaGit.getInstance().getGit().getRepository());){
            prevCommitTree = revWalk.parseCommit((AnyObjectId)c.getParent(0).getId()).getTree();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        ArrayList<String> result = new ArrayList<String>();
        throwable2 = null;
        Object var6_9 = null;
        try (DiffFormatter diffFormatter = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);){
            diffFormatter.setRepository(PaGit.getInstance().getGit().getRepository());
            List diffEntries = diffFormatter.scan(prevCommitTree, thisCommitTree);
            for (DiffEntry diff : diffEntries) {
                FileHeader fileHeader = diffFormatter.toFileHeader(diff);
                for (Edit edit : fileHeader.toEditList()) {
                    if (edit.getType() == Edit.Type.EMPTY || result.contains(fileHeader.getNewPath())) continue;
                    result.add(fileHeader.getNewPath());
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        return result;
    }

    @Test
    public void testCherryPickFail() throws IOException, GitAPIException {
        PaCherryPickException e;
        block5: {
            Git git = PaGit.getInstance().getGit();
            Ref ref = git.checkout().setName("71.CPT-2").call();
            e = null;
            try {
                try {
                    PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-0").setSourceRef("refs/heads/71.CPT-1").setTargetRef("refs/heads/71.CPT-master").setTargetIssue("CPT-Master").call();
                }
                catch (PaCherryPickException pge) {
                    e = pge;
                    git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
                throw throwable;
            }
            git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
        }
        Assert.assertNotNull((Object)((Object)e));
    }

    @Test
    public void testCherryPickFail2() throws IOException, GitAPIException {
        PaCherryPickException e;
        block5: {
            Git git = PaGit.getInstance().getGit();
            Ref ref = git.checkout().setName("71.CPT-1").call();
            e = null;
            try {
                try {
                    PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-0").setSourceRef("refs/heads/71.CPT-9999999").setTargetRef("refs/heads/71.CPT-1").setTargetIssue("CPT-1").call();
                }
                catch (PaCherryPickException pge) {
                    e = pge;
                    git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
                throw throwable;
            }
            git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
        }
        Assert.assertNotNull((Object)((Object)e));
    }

    @Test
    public void testCherryPickFail3() throws IOException, GitAPIException {
        PaCherryPickException e = null;
        try {
            PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-0").setSourceRef("refs/heads/71.CPT-1").setTargetRef("71.CPT-99999").setTargetIssue("CPT-99999").call();
        }
        catch (PaCherryPickException pge) {
            e = pge;
        }
        Assert.assertNotNull((Object)((Object)e));
    }

    @Test
    public void testCherryPickFail4() throws IOException, GitAPIException {
        PaCherryPickException e;
        block11: {
            Ref ref;
            Git git;
            block9: {
                git = PaGit.getInstance().getGit();
                ref = git.checkout().setName("71.CPT-1").call();
                e = null;
                try {
                    try {
                        PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-0").setSourceRef("refs/heads/71.CPT-1").setTargetRef("refs/remotes/origin/71.CPT-1").setTargetIssue("CPT-1").call();
                    }
                    catch (PaCherryPickException pge) {
                        e = pge;
                        git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
                    throw throwable;
                }
                git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
            }
            Assert.assertNotNull((Object)((Object)e));
            try {
                try {
                    PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-0").setSourceRef("refs/heads/71.CPT-1").setTargetRef("origin/71.CPT-1").setTargetIssue("CPT-1").call();
                }
                catch (PaCherryPickException pge) {
                    e = pge;
                    git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
                    break block11;
                }
            }
            catch (Throwable throwable) {
                git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
                throw throwable;
            }
            git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
        }
        Assert.assertNotNull((Object)((Object)e));
    }

    @Test
    public void testSimpleCherryPick1() throws IOException, GitAPIException {
        Git git = PaGit.getInstance().getGit();
        Ref ref = git.checkout().setStartPoint("master").setCreateBranch(true).setName("71.CPT_tmp-2").call();
        try {
            PaCherryPickResult result = PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-1").setSourceRef("refs/remotes/origin/71.CPT-1").setTargetRef(git.getRepository().getFullBranch()).setTargetIssue("CPT-1").call();
            Assert.assertEquals((long)1L, (long)result.getSuccessfulPicks().size());
            Assert.assertEquals((Object)"f295fd2390312a1f0a938480068285784ce8e5f6", (Object)result.getSuccessfulPicks().get(0).name());
            Assert.assertEquals((long)0L, (long)result.getOpenPicks().size());
            RevCommit commit = null;
            Throwable throwable = null;
            Object var6_7 = null;
            try (RevWalk walk = new RevWalk(git.getRepository());){
                ObjectId oid = PaGit.getInstance().getGit().getRepository().resolve("HEAD");
                commit = walk.parseCommit((AnyObjectId)oid);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            assert (this.getListOfChangedFiles(commit).contains("cpt-1.txt"));
        }
        finally {
            git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
        }
    }

    @Test
    public void testSimpleCherryPick2() throws IOException, GitAPIException {
        Git git = PaGit.getInstance().getGit();
        Ref ref = git.checkout().setStartPoint("master").setCreateBranch(true).setName("71.CPT_tmp-3").call();
        try {
            PaCherryPickResult result = PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-3").setSourceRef("refs/remotes/origin/71.CPT-3").setTargetRef(git.getRepository().getFullBranch()).setTargetIssue("CPT-3").call();
            Assert.assertEquals((long)4L, (long)result.getSuccessfulPicks().size());
            Assert.assertEquals((Object)"bad70708f42d474af9dbcfea18fd478aa1cfc07e", (Object)result.getSuccessfulPicks().get(0).name());
            Assert.assertEquals((Object)"6b8036880f08365f8c52aa9f27f7a26d8c41c989", (Object)result.getSuccessfulPicks().get(1).name());
            Assert.assertEquals((Object)"182bcc02b644396ab4e9783f05f3cd4f021b8283", (Object)result.getSuccessfulPicks().get(2).name());
            Assert.assertEquals((Object)"aa011296f4e76f1ff382953964fffca0a1dc4494", (Object)result.getSuccessfulPicks().get(3).name());
            Assert.assertEquals((long)0L, (long)result.getOpenPicks().size());
        }
        finally {
            git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
        }
    }

    @Test
    public void testSimpleCherryPickEmpty() throws IOException, GitAPIException {
        Git git = PaGit.getInstance().getGit();
        Ref ref = git.checkout().setName("71.CPT-1").call();
        PaCherryPickResult result = PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-0").setSourceRef("refs/remotes/origin/71.CPT-master").setTargetRef(git.getRepository().getFullBranch()).setTargetIssue("CPT-1").call();
        try {
            Assert.assertEquals((long)0L, (long)result.getSuccessfulPicks().size());
            Assert.assertEquals((long)0L, (long)result.getOpenPicks().size());
        }
        finally {
            git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
        }
    }

    @Test
    public void testCherryPickConflict() throws IOException, GitAPIException {
        Git git = PaGit.getInstance().getGit();
        Ref ref = git.checkout().setName("71.CPT-5").call();
        PaCherryPickResult result = PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-1").setSourceRef("refs/remotes/origin/71.CPT-1").setTargetRef(git.getRepository().getFullBranch()).setTargetIssue("CPT-5").call();
        try {
            Assert.assertEquals((Object)CherryPickResult.CherryPickStatus.CONFLICTING, (Object)result.getStatus());
            Assert.assertEquals((long)0L, (long)result.getSuccessfulPicks().size());
            Assert.assertEquals((long)1L, (long)result.getOpenPicks().size());
            Assert.assertEquals((Object)"f295fd2390312a1f0a938480068285784ce8e5f6", (Object)result.getOpenPicks().get(0).name());
            Assert.assertEquals((long)1L, (long)git.status().call().getConflicting().size());
            assert (git.status().call().getConflicting().contains("cpt-1.txt"));
        }
        finally {
            git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
        }
    }

    @Test
    public void testCherryPickConflictWithContinue() throws IOException, GitAPIException {
        Git git = PaGit.getInstance().getGit();
        Ref ref = git.checkout().setName("71.CPT-10").call();
        PaIssueConveyanceCommand cmd = PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-11").setSourceRef("refs/remotes/origin/71.CPT-11").setTargetRef(git.getRepository().getFullBranch()).setTargetIssue("CPT-10");
        try {
            PaCherryPickResult result = cmd.call();
            Assert.assertEquals((Object)CherryPickResult.CherryPickStatus.CONFLICTING, (Object)result.getStatus());
            Assert.assertEquals((long)1L, (long)result.getSuccessfulPicks().size());
            Assert.assertEquals((Object)"8ffbc3460089ce9f7fa74c10a3c93d89b868458e", (Object)result.getSuccessfulPicks().get(0).getName());
            Assert.assertEquals((long)2L, (long)result.getOpenPicks().size());
            Assert.assertEquals((Object)"3ef842fc1aca136dbe00ff42db94aaf419c5c8ec", (Object)result.getOpenPicks().get(0).getName());
            Assert.assertEquals((Object)"89173f5078831435a5abcbfd3e10d2e6d69f7153", (Object)result.getOpenPicks().get(1).getName());
            git.add().addFilepattern("cpt-10.txt").call();
            git.commit().setMessage(PaCommitMsg.getCherryPickMsg("CPT-10", result.getOpenPicks().get(0).getFullMessage(), result.getOpenPicks().get(0).getId().name())).setAuthor(result.getOpenPicks().get(0).getAuthorIdent()).setNoVerify(true).call();
            result = cmd.call();
            Assert.assertEquals((Object)CherryPickResult.CherryPickStatus.OK, (Object)result.getStatus());
            Assert.assertEquals((long)3L, (long)result.getSuccessfulPicks().size());
            Assert.assertEquals((Object)"8ffbc3460089ce9f7fa74c10a3c93d89b868458e", (Object)result.getSuccessfulPicks().get(0).getName());
            Assert.assertEquals((Object)"3ef842fc1aca136dbe00ff42db94aaf419c5c8ec", (Object)result.getSuccessfulPicks().get(1).getName());
            Assert.assertEquals((Object)"89173f5078831435a5abcbfd3e10d2e6d69f7153", (Object)result.getSuccessfulPicks().get(2).getName());
            Assert.assertEquals((long)0L, (long)result.getOpenPicks().size());
        }
        finally {
            git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
        }
    }

    @Test
    public void testCherryPickTwice() throws IOException, GitAPIException {
        Git git = PaGit.getInstance().getGit();
        Ref ref = git.checkout().setStartPoint("master").setCreateBranch(true).setName("71.CPT_tmp-1").call();
        try {
            PaCherryPickResult result = PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-1").setSourceRef("refs/remotes/origin/71.CPT-1").setTargetRef(git.getRepository().getFullBranch()).setTargetIssue("CPT-12").call();
            Assert.assertEquals((Object)CherryPickResult.CherryPickStatus.OK, (Object)result.getStatus());
            Assert.assertEquals((long)1L, (long)result.getSuccessfulPicks().size());
            Assert.assertEquals((Object)"f295fd2390312a1f0a938480068285784ce8e5f6", (Object)result.getSuccessfulPicks().get(0).name());
            Assert.assertEquals((long)0L, (long)result.getOpenPicks().size());
            result = PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-1").setSourceRef("refs/remotes/origin/71.CPT-1").setTargetRef(git.getRepository().getFullBranch()).setTargetIssue("CPT-12").call();
            Assert.assertEquals((Object)CherryPickResult.CherryPickStatus.OK, (Object)result.getStatus());
            Assert.assertEquals((long)0L, (long)result.getOpenPicks().size());
        }
        finally {
            git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
        }
    }

    @Test
    public void testCherryPickWithEmptyCommit() throws IOException, GitAPIException {
        Git git = PaGit.getInstance().getGit();
        Ref ref = git.checkout().setName("71.CPT-6").call();
        try {
            PaCherryPickResult result = PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-1").setSourceRef("refs/remotes/origin/71.CPT-1").setTargetRef(git.getRepository().getFullBranch()).setTargetIssue("CPT-6").call();
            Assert.assertEquals((long)1L, (long)result.getSuccessfulPicks().size());
            Assert.assertEquals((Object)"f295fd2390312a1f0a938480068285784ce8e5f6", (Object)result.getSuccessfulPicks().get(0).name());
            Assert.assertEquals((long)0L, (long)result.getOpenPicks().size());
            RevCommit commit = null;
            Throwable throwable = null;
            Object var6_7 = null;
            try (RevWalk walk = new RevWalk(git.getRepository());){
                ObjectId oid = PaGit.getInstance().getGit().getRepository().resolve("HEAD");
                commit = walk.parseCommit((AnyObjectId)oid);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            assert (this.getListOfChangedFiles(commit).isEmpty());
        }
        finally {
            git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
        }
    }

    @Test
    public void testCherryPickWithAutoMerge() throws IOException, GitAPIException {
        Git git = PaGit.getInstance().getGit();
        Ref ref = git.checkout().setName("71.CPT-8").call();
        try {
            PaCherryPickResult result = PaGit.getInstance().paIssueConveyenceCommand().setIssue("CPT-9").setSourceRef("refs/remotes/origin/71.CPT-9").setTargetRef(git.getRepository().getFullBranch()).setTargetIssue("CPT-8").call();
            Assert.assertEquals((Object)CherryPickResult.CherryPickStatus.OK, (Object)result.getStatus());
            Assert.assertEquals((long)1L, (long)result.getSuccessfulPicks().size());
            Assert.assertEquals((Object)"7542d66823cc8f8faf99088b2befcc7fec0ee682", (Object)result.getSuccessfulPicks().get(0).name());
            Assert.assertEquals((long)0L, (long)result.getOpenPicks().size());
            System.out.println("###################################");
            System.out.println("###################################");
            System.out.println("###################################");
            System.out.println("###################################");
            System.out.println(result.getNewHead().getFullMessage());
            System.out.println("###################################");
            System.out.println("###################################");
            System.out.println("###################################");
            System.out.println("###################################");
        }
        finally {
            git.reset().setRef(ref.getObjectId().name()).setMode(ResetCommand.ResetType.HARD).call();
        }
    }
}

