/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.git.tests;

import com.proalpha.pds.gitutils.pagit.util.PaIssueExplorer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.junit.Assert;
import org.junit.Test;

public class PaIssueExplorerTest {
    @Test
    public void testVerySimpleGetIssue() throws GitAPIException, IOException {
        List<RevCommit> commits = PaIssueExplorer.getCommitsOfIssue("origin/71.CPT-1", "CPT-1");
        Assert.assertEquals((long)1L, (long)commits.size());
        RevCommit c = commits.get(0);
        Assert.assertEquals((Object)"f295fd2390312a1f0a938480068285784ce8e5f6", (Object)c.getName());
    }

    @Test
    public void testSimpleGetIssue() throws GitAPIException, IOException {
        List<RevCommit> commits = PaIssueExplorer.getCommitsOfIssue("origin/71.CPT-2", "CPT-2");
        Assert.assertEquals((long)2L, (long)commits.size());
    }

    @Test
    public void testGetIssueAfterMerge() throws GitAPIException, IOException {
        List<RevCommit> commits = PaIssueExplorer.getCommitsOfIssue("origin/71.CPT-3", "CPT-3");
        Assert.assertEquals((long)4L, (long)commits.size());
        commits = PaIssueExplorer.getCommitsOfIssue("origin/71.CPT-master", "CPT-3");
        Assert.assertEquals((long)1L, (long)commits.size());
    }

    @Test
    public void testGetIssueWithSync() throws GitAPIException, IOException {
        List<RevCommit> commits = PaIssueExplorer.getCommitsOfIssue("origin/71.CPT-4", "CPT-4");
        Assert.assertEquals((long)3L, (long)commits.size());
    }

    @Test
    public void testGetIssueWithDifferentDateFilter() throws GitAPIException, IOException, ParseException {
        List<RevCommit> commits = PaIssueExplorer.getCommitsOfIssue("origin/71.CPT-3", "CPT-3", 10000, new SimpleDateFormat("dd.MM.yyyy").parse(PaIssueExplorer.DATE_OF_ARAMIS_GOLIVE));
        Assert.assertEquals((long)4L, (long)commits.size());
        commits = PaIssueExplorer.getCommitsOfIssue("origin/71.CPT-3", "CPT-3", 10000, new SimpleDateFormat("dd.MM.yyyy").parse("01.05.2019"));
        Assert.assertEquals((long)1L, (long)commits.size());
    }
}

