/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.git.tests;

import com.proalpha.pds.gitutils.pagit.exceptions.PaGitTransException;
import com.proalpha.pds.gitutils.pagit.model.ijra.JiraIssue;
import com.proalpha.pds.gitutils.pagit.model.ijra.JiraIssueCache;
import java.io.IOException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.junit.Assert;
import org.junit.Test;

public class PaJiraTest {
    private static final String ISSUE_WFL = "TST-91";
    private static final String ISSUE_SPRINT = "TST-146";
    private static final String ISSUE_SUBTASK = "TST-147";
    private static final String SPRINT_NAME = "TestBoar Sprint 2";

    @Test
    public void testGetJiraIssue() throws IOException, GitAPIException, PaGitTransException {
        JiraIssueCache cache = new JiraIssueCache();
        JiraIssue issue = cache.getIssue(ISSUE_WFL);
        Assert.assertTrue((String)"The issue is not in state TODO", (boolean)issue.isInWflState(new String[]{"open"}));
        Assert.assertEquals((String)"The returned key is wrong", (Object)ISSUE_WFL, (Object)issue.getKey());
    }

    @Test
    public void testGetJiraIssueSprint() throws IOException, GitAPIException, PaGitTransException {
        JiraIssueCache cache = new JiraIssueCache();
        JiraIssue issue = cache.getIssue(ISSUE_SPRINT);
        Assert.assertFalse((String)"The issue should have sprints but has none", (boolean)issue.getSprints().isEmpty());
        Assert.assertNotNull((String)"The issue should have an active sprint but has none", (Object)issue.getActiveSprint());
        Assert.assertEquals((String)"The returned sprintname is wrong", (Object)SPRINT_NAME, (Object)issue.getActiveSprintName());
        issue = cache.getIssue(ISSUE_WFL);
        Assert.assertTrue((String)"The issue should have sprints but has none", (boolean)issue.getSprints().isEmpty());
        Assert.assertNull((String)"The issue should have an active sprint but has none", (Object)issue.getActiveSprint());
        Assert.assertNotEquals((String)"The returned sprintname is wrong", (Object)SPRINT_NAME, (Object)issue.getActiveSprintName());
    }

    @Test
    public void testGetJiraIssueSubTask() throws IOException, GitAPIException, PaGitTransException {
        JiraIssueCache cache = new JiraIssueCache();
        JiraIssue issue = cache.getIssue(ISSUE_SPRINT);
        Assert.assertTrue((String)"The issue should have subtasks but we got false", (boolean)issue.hasSubtasks());
        Assert.assertNotNull((String)"The issue should have subtasks but we got empty list", issue.getSubtasks());
        Assert.assertNotNull((String)"The issue should have issue TST-147 as subtask but we got false", (Object)issue.hasSubtask(ISSUE_SUBTASK));
        issue = cache.getIssue(ISSUE_SUBTASK);
        Assert.assertNotNull((String)"The issue should have a parent TST-146 but we got null as parent key", (Object)issue.getParentKey());
        Assert.assertEquals((String)"The returned parent key is wrong", (Object)ISSUE_SPRINT, (Object)issue.getParentKey());
        issue = cache.getIssue(ISSUE_SUBTASK);
        Assert.assertFalse((String)"The issue should have NO subtasks but we got true", (boolean)issue.hasSubtasks());
        Assert.assertNotNull((String)"The issue should have NO subtasks but we got a filled subtask list", issue.getSubtasks());
        Assert.assertNotNull((String)"The issue shouldn't have issue TST-146 as subtask but we got true", (Object)issue.hasSubtask(ISSUE_SPRINT));
        issue = cache.getIssue(ISSUE_SPRINT);
        Assert.assertNull((String)"The issue should have no parent but we got a parent key", (Object)issue.getParentKey());
    }
}

