/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.git.tests;

import com.proalpha.pds.gitutils.pagit.PaGit;
import com.proalpha.pds.gitutils.pagit.util.PaRepository;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.StoredConfig;
import org.junit.Assert;
import org.junit.Test;

public class PaRepositoryTest {
    @Test
    public void testGetRemoteTrackingBranch() {
        Assert.assertEquals((Object)"origin/71.TST-146", (Object)PaRepository.getRemoteTrackingBranch("71.TST-146"));
        Assert.assertEquals((Object)"origin/71.TST-146", (Object)PaRepository.getRemoteTrackingBranch("refs/remotes/origin/71.TST-146"));
        Assert.assertEquals((Object)"origin/71.TST-146", (Object)PaRepository.getRemoteTrackingBranch("origin/71.TST-146"));
        Assert.assertEquals((Object)"origin/71.TST-146", (Object)PaRepository.getRemoteTrackingBranch("refs/heads/71.TST-146"));
        Assert.assertNull((Object)PaRepository.getRemoteTrackingBranch("71.DOES_NOT_EXIST"));
        Assert.assertNull((Object)PaRepository.getRemoteTrackingBranch("origin/DOES_NOT_EXIST"));
        Assert.assertNull((Object)PaRepository.getRemoteTrackingBranch("refs/remotes/origin/DOES_NOT_EXIST"));
    }

    @Test
    public void testGetLocalServerBranch() {
        Assert.assertEquals((Object)"71.TST-146", (Object)PaRepository.getLocalServerBranch("71.TST-146"));
        Assert.assertEquals((Object)"71.TST-146", (Object)PaRepository.getLocalServerBranch("refs/remotes/origin/71.TST-146"));
        Assert.assertEquals((Object)"71.TST-146", (Object)PaRepository.getLocalServerBranch("origin/71.TST-146"));
        Assert.assertEquals((Object)"71.TST-146", (Object)PaRepository.getLocalServerBranch("refs/heads/71.TST-146"));
        Assert.assertNull((Object)PaRepository.getLocalServerBranch("71.DOES_NOT_EXIST"));
        Assert.assertNull((Object)PaRepository.getLocalServerBranch("origin/DOES_NOT_EXIST"));
        Assert.assertNull((Object)PaRepository.getLocalServerBranch("refs/remotes/origin/DOES_NOT_EXIST"));
    }

    @Test
    public void testIsBranchValid() {
        assert (PaRepository.isValidRef("71.TST-146"));
        assert (PaRepository.isValidRef("refs/remotes/origin/71.TST-146"));
        assert (PaRepository.isValidRef("origin/71.TST-146"));
        assert (PaRepository.isValidRef("refs/heads/71.TST-146"));
        Assert.assertFalse((boolean)PaRepository.isValidRef("71.DOES_NOT_EXIST"));
        Assert.assertFalse((boolean)PaRepository.isValidRef("origin/71.DOES_NOT_EXIST"));
        Assert.assertFalse((boolean)PaRepository.isValidRef("refs/remotes/origin/71.DOES_NOT_EXIST"));
    }

    @Test
    public void testIsRemoteTrackingBranch() {
        Assert.assertFalse((boolean)PaRepository.isRemoteTrackingBranch("71.TST-146"));
        Assert.assertFalse((boolean)PaRepository.isRemoteTrackingBranch("refs/heads/71.TST-146"));
        assert (PaRepository.isRemoteTrackingBranch("refs/remotes/origin/71.TST-146"));
        assert (PaRepository.isRemoteTrackingBranch("origin/71.TST-146"));
        Assert.assertFalse((boolean)PaRepository.isRemoteTrackingBranch("71.DOES_NOT_EXIST"));
        assert (PaRepository.isRemoteTrackingBranch("origin/71.DOES_NOT_EXIST"));
        assert (PaRepository.isRemoteTrackingBranch("refs/remotes/origin/71.DOES_NOT_EXIST"));
    }

    @Test
    public void testConnectRemoteBranch() throws GitAPIException, IOException {
        StoredConfig config = PaGit.getInstance().getGit().getRepository().getConfig();
        Set remotes = null;
        String repTemp = PaRepository.connectRemoteBranch("https://git.proalpha.com/scm/test/unit-test-tmp.git", "71.TST-146");
        Assert.assertEquals((Object)"refs/remotes/_test/unit-test-tmp/71.TST-146", (Object)repTemp);
        remotes = config.getSubsections("remote");
        assert (remotes.contains("_test/unit-test-tmp"));
        assert (PaRepository.isValidRef("refs/remotes/_test/unit-test-tmp/71.TST-146"));
        PaRepository.disconnectRemote("_test/unit-test-tmp");
        remotes = config.getSubsections("remote");
        assert (!remotes.contains("_test/unit-test-tmp"));
        assert (!PaRepository.isValidRef("refs/remotes/_test/unit-test-tmp/71.TST-146"));
        repTemp = PaRepository.connectRemoteBranch("https://git.proalpha.com/scm/test/unit-test-tmp.git", "71.TST-146", "unit2");
        Assert.assertEquals((Object)"refs/remotes/unit2/71.TST-146", (Object)repTemp);
        remotes = config.getSubsections("remote");
        assert (remotes.contains("unit2"));
        assert (PaRepository.isValidRef("refs/remotes/unit2/71.TST-146"));
        PaRepository.disconnectRemote("unit2");
        remotes = config.getSubsections("remote");
        assert (!remotes.contains("unit2"));
        assert (!PaRepository.isValidRef("refs/remotes/unit2/71.TST-146"));
    }

    @Test
    public void testUpdateBranch() throws GitAPIException, IOException {
        String ref = "refs/remotes/origin/71.TST-146";
        PaGit.getInstance().getGit().branchDelete().setBranchNames(new String[]{ref}).call();
        Assert.assertNull((Object)PaGit.getInstance().getGit().getRepository().resolve(ref));
        PaRepository.updateBranch(ref);
        String newHash = PaGit.getInstance().getGit().getRepository().resolve(ref).name();
        Assert.assertEquals((Object)"3b508ce7552360059c470e1fa9ef1574bdb68b2a", (Object)newHash);
    }

    @Test
    public void testGetMasterBranches() {
        List<String> branches = PaRepository.getMasterBranches();
        Assert.assertEquals((long)2L, (long)branches.size());
        Assert.assertEquals((Object)"71.master", (Object)branches.get(0));
    }

    @Test
    public void testGetCodeFreezeBranches() {
        List<String> branches = PaRepository.getCodeFreezeBranches();
        Assert.assertEquals((long)1L, (long)branches.size());
        Assert.assertEquals((Object)"71c03", (Object)branches.get(0));
    }
}

