/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.common;

import com.proalpha.pds.gitutils.pagit.PaGit;
import com.proalpha.pds.gitutils.pagit.util.PaBranchName;
import com.proalpha.pds.gitutils.pagit.util.PaRepository;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.FetchOperation;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckoutOperation {
    private final Logger logger = LoggerFactory.getLogger(CheckoutOperation.class);
    protected static final String DEFAULT_SOURCE = "HEAD";
    protected String targetRef;
    protected String sourceRef;
    protected boolean updateTargetRef;
    protected boolean updateSourceRef;
    protected String remote;
    protected Repository repository;
    protected IProgressMonitor monitor;
    private CheckoutCommand cmd;
    protected MergeCommand mergeCmd;
    protected MergeResult mergeResult;

    public CheckoutOperation(Repository repository, String remote, String sourceRef, String targetRef, boolean updateSourceRef, boolean updateTargetRef) {
        this.repository = repository;
        this.sourceRef = sourceRef;
        this.targetRef = targetRef;
        this.updateSourceRef = updateSourceRef;
        this.updateTargetRef = updateTargetRef;
        this.remote = remote;
        PaGit.init(new Git(repository));
    }

    public CheckoutOperation(Repository repository, String targetRef) {
        this(repository, "origin", DEFAULT_SOURCE, targetRef, false, false);
    }

    public void run() throws InvocationTargetException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(MessageFormat.format("Checkout/creation of branch {0}", this.targetRef));
        }
        try {
            if (this.isLocalBranch(this.targetRef)) {
                this.checkoutLocalBranch();
            } else if (this.isServerBranch(this.targetRef)) {
                this.checkoutServerBranch();
            } else {
                this.createNewBranch();
            }
        }
        finally {
            PaGit.getInstance().close();
        }
    }

    protected boolean tryFetch(String ref) {
        RemoteConfig config;
        block5: {
            if (!this.isServerBranch(ref)) {
                return false;
            }
            config = this.getRemoteConfig();
            if (config != null) break block5;
            return false;
        }
        try {
            RefSpec spec = new RefSpec("+refs/heads/" + ref + ":refs/remotes/" + this.remote + "/" + ref);
            config.addFetchRefSpec(spec);
            FetchOperation op = new FetchOperation(this.repository, config, config.getTimeout(), false);
            op.setCredentialsProvider((CredentialsProvider)this.getCredentialProvider());
            op.run(this.monitor);
            return true;
        }
        catch (URISyntaxException ex) {
            this.logger.warn("The remote config seems to be strange", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            this.logger.warn("Error while running the fetch operation ()", (Throwable)ex);
        }
        return false;
    }

    protected RemoteConfig getRemoteConfig() throws URISyntaxException {
        List configs = RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig());
        for (RemoteConfig c : configs) {
            if (!c.getName().equals(this.remote)) continue;
            return c;
        }
        return null;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public CheckoutResult getResult() {
        if (this.cmd != null) {
            if (this.mergeResult == null || this.mergeResult.getMergeStatus() == MergeResult.MergeStatus.FAST_FORWARD || this.mergeResult.getMergeStatus() == MergeResult.MergeStatus.MERGED || this.mergeResult.getMergeStatus() == MergeResult.MergeStatus.ALREADY_UP_TO_DATE) {
                return this.cmd.getResult();
            }
            return CheckoutResult.ERROR_RESULT;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isLocalBranch(String ref) {
        try {
            Ref r;
            String shortRef = PaBranchName.getShortBranchName(ref);
            List refs = PaGit.getInstance().getGit().branchList().call();
            Iterator iterator = refs.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!PaBranchName.getShortBranchName((r = (Ref)iterator.next()).getName()).equals(shortRef));
            return true;
        }
        catch (GitAPIException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isServerBranch(String ref) {
        try {
            Ref r;
            String shortRef = PaBranchName.getShortBranchName(ref);
            Collection refs = ((LsRemoteCommand)PaGit.getInstance().getGit().lsRemote().setHeads(true).setTags(false).setCredentialsProvider((CredentialsProvider)this.getCredentialProvider())).setRemote(this.remote).call();
            Iterator iterator = refs.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!PaBranchName.getShortBranchName((r = (Ref)iterator.next()).getName()).equals(shortRef));
            return true;
        }
        catch (GitAPIException ex) {
            this.logger.error("Error while retrieving server branches.", (Throwable)ex);
        }
        return false;
    }

    protected EGitCredentialsProvider getCredentialProvider() {
        UserPasswordCredentials credentials = null;
        try {
            RemoteConfig config = this.getRemoteConfig();
            try {
                if (config != null) {
                    credentials = SecureStoreUtils.getCredentials((URIish)((URIish)config.getURIs().get(0)));
                }
            }
            catch (IllegalArgumentException ex) {
                this.logger.warn("Could not get credentials for the URI of following git repository: {}", config.getURIs().isEmpty() ? String.valueOf(config.getName()) + " - NO URI!" : config.getURIs().get(0));
            }
        }
        catch (URISyntaxException ex) {
            this.logger.warn("Could not get credentials for the URI due to URI syntax exception", (Throwable)ex);
        }
        if (credentials != null) {
            return new EGitCredentialsProvider(credentials.getUser(), credentials.getPassword());
        }
        return new EGitCredentialsProvider();
    }

    private void checkoutLocalBranch() throws InvocationTargetException {
        block5: {
            try {
                this.cmd = PaGit.getInstance().getGit().checkout().setName(this.targetRef);
                this.cmd.call();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(MessageFormat.format("Checkout of existing local branch {0} successful", this.targetRef));
                }
                if (!this.updateTargetRef || !this.tryFetch(this.targetRef)) break block5;
                this.mergeCmd = PaGit.getInstance().getGit().merge().setFastForward(MergeCommand.FastForwardMode.FF).include((AnyObjectId)this.repository.resolve(String.valueOf(this.remote) + "/" + this.targetRef));
                this.mergeResult = this.mergeCmd.call();
                if (!this.mergeResult.getMergeStatus().isSuccessful()) break block5;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(MessageFormat.format("Merge of remote branch {0} successful", String.valueOf(this.remote) + "/" + this.targetRef));
                    break block5;
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.error(MessageFormat.format("Error while updating local ref {0}  while merging", this.targetRef));
                }
                throw new InvocationTargetException(new Throwable("Merge into {0} failed"));
            }
            catch (IOException | GitAPIException e1) {
                this.logger.error(MessageFormat.format("Error while checkout of local branch {0}", this.targetRef), e1);
                throw new InvocationTargetException(e1.getCause() != null ? e1.getCause() : e1);
            }
        }
    }

    private void checkoutServerBranch() throws InvocationTargetException {
        try {
            this.tryFetch(this.targetRef);
            this.cmd = PaGit.getInstance().getGit().checkout().setCreateBranch(true).setName(this.targetRef).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint(String.valueOf(this.remote) + "/" + this.targetRef);
            this.cmd.call();
            this.logger.info(MessageFormat.format("Branch {0} created by checkout of remote branch {1}", this.targetRef, String.valueOf(this.remote) + "/" + this.targetRef));
        }
        catch (GitAPIException e1) {
            this.logger.error(MessageFormat.format("Error while checkout of server branch {0}", this.targetRef), (Throwable)e1);
            throw new InvocationTargetException(e1.getCause() != null ? e1.getCause() : e1);
        }
    }

    private void createNewBranch() throws InvocationTargetException {
        try {
            block10: {
                if (this.updateSourceRef && this.tryFetch(this.sourceRef) && !PaRepository.isRemoteTrackingBranch(this.sourceRef)) {
                    try {
                        PaGit.getInstance().getGit().checkout().setCreateBranch(false).setName(this.sourceRef).call();
                        this.mergeCmd = PaGit.getInstance().getGit().merge().setFastForward(MergeCommand.FastForwardMode.FF_ONLY).include((AnyObjectId)this.repository.resolve(String.valueOf(this.remote) + "/" + this.sourceRef));
                        this.mergeResult = this.mergeCmd.call();
                        if (this.mergeResult.getMergeStatus().isSuccessful()) {
                            if (this.logger.isInfoEnabled()) {
                                this.logger.info(MessageFormat.format("Merge of remote branch {0} successful", String.valueOf(this.remote) + "/" + this.targetRef));
                            }
                            break block10;
                        }
                        if (this.logger.isInfoEnabled()) {
                            this.logger.error(MessageFormat.format("Error while updating local ref {0}  while merging", this.targetRef));
                        }
                        throw new InvocationTargetException(new Throwable("Merge into {0} failed"));
                    }
                    catch (IOException | InvalidObjectIdException ioie) {
                        if (!this.logger.isWarnEnabled()) break block10;
                        this.logger.warn(MessageFormat.format("Source ref {0} could not be updated and/or merged into {1}.", this.sourceRef, this.targetRef), ioie);
                    }
                }
            }
            this.cmd = PaGit.getInstance().getGit().checkout().setCreateBranch(true).setName(this.targetRef).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.NOTRACK).setStartPoint(this.sourceRef);
            this.cmd.call();
            if (this.logger.isInfoEnabled()) {
                this.logger.info(MessageFormat.format("Creation of branch {0} by branching-off local branch {1}", this.targetRef, this.sourceRef));
            }
        }
        catch (GitAPIException e1) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(MessageFormat.format("Error while creating new local branch {0}", this.targetRef), (Throwable)e1);
            }
            throw new InvocationTargetException(e1.getCause() != null ? e1.getCause() : e1);
        }
    }
}

