/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit;

import com.proalpha.pds.gitutils.pagit.commands.PaIssueConveyanceCommand;
import com.proalpha.pds.gitutils.pagit.commands.PaIssueExtractCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaGit {
    private static final Logger logger = LoggerFactory.getLogger(PaGit.class);
    private static PaGit instance;
    private Git git;
    private CredentialsProvider credentialProvider = null;
    private ProgressMonitor progressMonitor = NullProgressMonitor.INSTANCE;

    private PaGit(Git git) {
        this.git = git;
    }

    private PaGit(Git git, String user, String password) {
        this.git = git;
        this.credentialProvider = new UsernamePasswordCredentialsProvider(user, password);
    }

    public static void init(Git git) {
        logger.debug("PaGit initialized without credentials.");
        instance = new PaGit(git);
    }

    public static void init(Git git, String user, String password) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("PaGit initialized with credentials for user %s.", user));
        }
        instance = new PaGit(git, user, password);
    }

    public void close() {
        if (this.git.getRepository() != null) {
            this.git.close();
        }
    }

    public static PaGit getInstance() {
        if (instance == null) {
            throw new NullPointerException("Before accessing the PaGit instance, init(...) has to be called.");
        }
        return instance;
    }

    public Git getGit() {
        return this.git;
    }

    public CredentialsProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    public void setCredentialProvider(CredentialsProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public PaIssueExtractCommand paIssueExtract() {
        return new PaIssueExtractCommand(this.git.getRepository());
    }

    public PaIssueConveyanceCommand paIssueConveyenceCommand() {
        return new PaIssueConveyanceCommand();
    }
}

