/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.model.grep;

import com.proalpha.pds.gitutils.pagit.model.grep.Result;
import com.proalpha.pds.gitutils.pagit.model.grep.ResultContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ResultContextStorage {
    private HashMap<ContextKey, ResultContext> contexts = new HashMap();
    private HashMap<Result, ResultContext> contextsByResult = new HashMap();

    ResultContextStorage() {
    }

    public ResultContext getContext(Result result) {
        if (this.contextsByResult.containsKey(result)) {
            return this.contextsByResult.get(result);
        }
        return null;
    }

    public List<String> getFiles() {
        ArrayList<String> files = new ArrayList<String>();
        for (Map.Entry<ContextKey, ResultContext> entry : this.contexts.entrySet()) {
            if (files.contains(entry.getValue().getFile())) continue;
            files.add(entry.getValue().getFile());
        }
        return files;
    }

    public List<String> getFiles(String branch) {
        ArrayList<String> files = new ArrayList<String>();
        for (Map.Entry<ContextKey, ResultContext> entry : this.contexts.entrySet()) {
            if (files.contains(entry.getValue().getFile()) || !branch.equals(entry.getValue().getBranch())) continue;
            files.add(entry.getValue().getFile());
        }
        return files;
    }

    public void addContext(Result result, ResultContext context) {
        if (this.contextsByResult.containsKey(result)) {
            return;
        }
        ContextKey key = new ContextKey(context.getBranch(), context.getFile(), context.getFunction());
        if (!this.contexts.containsKey(key)) {
            this.contexts.put(key, context);
        } else {
            result.setContext(this.contexts.get(key));
        }
        this.contextsByResult.put(result, this.contexts.get(key));
    }

    private class ContextKey {
        String branch;
        String file;
        String function;

        ContextKey(String branch, String file, String function) {
            this.branch = branch;
            this.file = file;
            this.function = function;
        }
    }
}

