/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.oauth.util;

import com.google.api.client.auth.oauth.OAuthRsaSigner;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.proalpha.pds.gitutils.pagit.oauth.util.AtlassianOAuthGetAccessToken;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public class AtlassianOAuthTokenFactory {
    protected final String accessTokenUrl;
    protected final String requestTokenUrl;

    public AtlassianOAuthTokenFactory(String appBaseUrl) {
        this.accessTokenUrl = String.valueOf(appBaseUrl) + "/plugins/servlet/oauth/access-token";
        this.requestTokenUrl = String.valueOf(appBaseUrl) + "/plugins/servlet/oauth/request-token";
    }

    public AtlassianOAuthGetAccessToken getAtlassianOAuthGetAccessToken(String tmpToken, String secret, String consumerKey, String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        AtlassianOAuthGetAccessToken accessToken = new AtlassianOAuthGetAccessToken(this.accessTokenUrl);
        accessToken.consumerKey = consumerKey;
        accessToken.signer = this.getOAuthRsaSigner(privateKey);
        accessToken.transport = new ApacheHttpTransport();
        accessToken.verifier = secret;
        accessToken.temporaryToken = tmpToken;
        return accessToken;
    }

    private OAuthRsaSigner getOAuthRsaSigner(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        OAuthRsaSigner oAuthRsaSigner = new OAuthRsaSigner();
        oAuthRsaSigner.privateKey = this.getPrivateKey(privateKey);
        return oAuthRsaSigner;
    }

    private PrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] privateBytes = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(keySpec);
    }
}

