/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.util;

import com.proalpha.pds.gitutils.pagit.PaGit;
import com.proalpha.pds.gitutils.pagit.PaGitConfig;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.lib.Repository;

public class PaBranchName {
    private PaBranchName() {
    }

    public static boolean isValidRef(String ref, Repository rep) {
        String shortRef = PaBranchName.getShortBranchName(ref, rep);
        return PaBranchName.isFeatureBranch(shortRef, rep) || PaBranchName.isMasterBranch(shortRef, rep) || PaBranchName.isCodeFreezeBranch(shortRef, rep);
    }

    public static boolean isValidRef(String ref) {
        return PaBranchName.isFeatureBranch(ref, PaGit.getInstance().getGit().getRepository()) || PaBranchName.isMasterBranch(ref, PaGit.getInstance().getGit().getRepository()) || PaBranchName.isCodeFreezeBranch(ref, PaGit.getInstance().getGit().getRepository());
    }

    public static boolean isFeatureBranch(String ref, Repository rep) {
        return PaBranchName.getShortBranchName(ref, rep).matches(PaGitConfig.getStringFromConfig("branch_name.feature"));
    }

    public static boolean isFeatureBranch(String ref) {
        return PaBranchName.isFeatureBranch(ref, PaGit.getInstance().getGit().getRepository());
    }

    public static boolean isMasterBranch(String ref, Repository rep) {
        return PaBranchName.getShortBranchName(ref, rep).toLowerCase().matches(PaGitConfig.getStringFromConfig("branch_name.master"));
    }

    public static boolean isMasterBranch(String ref) {
        return PaBranchName.isMasterBranch(ref, PaGit.getInstance().getGit().getRepository());
    }

    public static boolean isSprintBranch(String ref, Repository rep) {
        return PaBranchName.getShortBranchName(ref, rep).toLowerCase().matches(PaGitConfig.getStringFromConfig("branch_name.sprint"));
    }

    public static boolean isSprintBranch(String ref) {
        return PaBranchName.isSprintBranch(ref, PaGit.getInstance().getGit().getRepository());
    }

    public static boolean isCodeFreezeBranch(String ref) {
        return PaBranchName.isCodeFreezeBranch(ref, PaGit.getInstance().getGit().getRepository());
    }

    public static boolean isCodeFreezeBranch(String ref, Repository rep) {
        return PaBranchName.getShortBranchName(ref, rep).toLowerCase().matches(PaGitConfig.getStringFromConfig("branch_name.codefreeze"));
    }

    public static String getBranchName(String ref) {
        return Repository.shortenRefName((String)ref);
    }

    public static String getShortBranchName(String ref, Repository rep) {
        String shortName = PaBranchName.getBranchName(ref);
        for (String remote : rep.getRemoteNames()) {
            String remotePrefix = String.valueOf(remote) + "/";
            if (!shortName.startsWith(remotePrefix)) continue;
            return shortName.substring(remotePrefix.length());
        }
        return shortName;
    }

    public static String getShortBranchName(String ref) {
        return PaBranchName.getShortBranchName(ref, PaGit.getInstance().getGit().getRepository());
    }

    public static String getIssue(String ref) {
        return PaBranchName.getIssue(ref, PaGit.getInstance().getGit().getRepository());
    }

    public static String getIssue(String ref, Repository rep) {
        if (!PaBranchName.isFeatureBranch(ref, rep)) {
            return null;
        }
        String shortBranchName = PaBranchName.getShortBranchName(ref, rep);
        Pattern p = Pattern.compile("(.*\\.)?(" + PaGitConfig.getStringFromConfig("issue_key_format") + ")$");
        Matcher m = p.matcher(shortBranchName);
        if (m.find()) {
            return m.group(2);
        }
        return null;
    }

    public static String getVersion(String ref) {
        return PaBranchName.getVersion(ref, PaGit.getInstance().getGit().getRepository());
    }

    public static String getVersion(String ref, Repository rep) {
        String shortBranchName = PaBranchName.getShortBranchName(ref, rep);
        if (PaBranchName.isCodeFreezeBranch(shortBranchName, rep) || PaBranchName.isFeatureBranch(shortBranchName, rep) || PaBranchName.isMasterBranch(shortBranchName, rep) || PaBranchName.isSprintBranch(shortBranchName, rep)) {
            if (shortBranchName.indexOf(46) >= 0) {
                return shortBranchName.substring(0, shortBranchName.indexOf(46));
            }
            if (PaBranchName.isCodeFreezeBranch(shortBranchName, rep)) {
                return shortBranchName;
            }
        }
        return null;
    }
}

