/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.util;

import com.proalpha.pds.gitutils.pagit.PaGit;
import com.proalpha.pds.gitutils.pagit.exceptions.PaGitException;
import com.proalpha.pds.gitutils.pagit.util.PaBranchName;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.revwalk.filter.MessageRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaIssueExplorer {
    protected static final Logger logger = LoggerFactory.getLogger(PaIssueExplorer.class);
    public static final int MAX_COMMITS_IN_HISTORY = 10000;
    public static String DATE_OF_ARAMIS_GOLIVE = "31.05.2019";

    private PaIssueExplorer() {
    }

    public static String getFirstVersion(String version, String issue) {
        throw new UnsupportedOperationException("getFirstVersion is not yet implemented");
    }

    private static String getLastOriginTag(String ref) throws GitAPIException, IOException {
        String version = PaBranchName.getVersion(ref);
        if (version == null) {
            return null;
        }
        String bestMatchingTagName = null;
        if (PaBranchName.isCodeFreezeBranch(ref)) {
            bestMatchingTagName = String.valueOf(version) + ".origin";
        } else {
            List allTags = PaGit.getInstance().getGit().tagList().call();
            for (Ref tag : allTags) {
                if (!tag.getName().startsWith(version) || bestMatchingTagName != null && bestMatchingTagName.compareTo(tag.getName()) >= 0) continue;
                bestMatchingTagName = tag.getName();
            }
        }
        return bestMatchingTagName;
    }

    public static List<RevCommit> getCommitsOfIssue(String ref, String issue, int maxNoOfCommits, Date earliestCommits) throws GitAPIException, IOException {
        ArrayList<RevCommit> resultCommits = new ArrayList<RevCommit>();
        ObjectId id = PaGit.getInstance().getGit().getRepository().resolve(ref);
        ProgressMonitor monitor = PaGit.getInstance().getProgressMonitor();
        String lastOriginTag = PaIssueExplorer.getLastOriginTag(ref);
        if (id == null) {
            throw new PaGitException("Following branch could not be resolved: " + ref);
        }
        monitor.beginTask("Collecting commits", 0);
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try (RevWalk revWalk = new RevWalk(PaGit.getInstance().getGit().getRepository());){
                revWalk.markStart(revWalk.parseCommit((AnyObjectId)PaGit.getInstance().getGit().getRepository().resolve(ref)));
                if (lastOriginTag != null) {
                    revWalk.markUninteresting(revWalk.parseCommit((AnyObjectId)PaGit.getInstance().getGit().getRepository().resolve(lastOriginTag)));
                }
                revWalk.setRevFilter(AndRevFilter.create((RevFilter)AndRevFilter.create((RevFilter)MessageRevFilter.create((String)(String.valueOf(issue) + ":")), (RevFilter)MaxCountRevFilter.create((int)maxNoOfCommits)), (RevFilter)CommitTimeRevFilter.after((Date)earliestCommits)));
                for (RevCommit commit : revWalk) {
                    resultCommits.add(commit);
                    monitor.update(1);
                }
                Collections.reverse(resultCommits);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            monitor.endTask();
        }
        return resultCommits;
    }

    public static List<RevCommit> getCommitsOfIssue(String ref, String issue) throws GitAPIException, IOException {
        try {
            return PaIssueExplorer.getCommitsOfIssue(ref, issue, 10000, new SimpleDateFormat("dd.MM.yyyy").parse(DATE_OF_ARAMIS_GOLIVE));
        }
        catch (ParseException pex) {
            throw new PaGitException("Error while parsing the date format (should never happen): " + pex.getMessage());
        }
    }

    public static List<RevCommit> getNewCommits(Repository r, ReceiveCommand command) throws IOException {
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk rw = new RevWalk(r);){
            RevCommit c;
            ObjectId start = r.resolve(command.getOldId().getName());
            ObjectId end = r.resolve(command.getNewId().getName());
            if (end.equals((AnyObjectId)ObjectId.zeroId())) {
                return commits;
            }
            if (!start.equals((AnyObjectId)ObjectId.zeroId())) {
                rw.markUninteresting(rw.parseCommit((AnyObjectId)start));
            }
            rw.markStart(rw.parseCommit((AnyObjectId)end));
            Collection allRefs = r.getRefDatabase().getRefs("refs/heads/").values();
            while ((c = rw.next()) != null) {
                List existingRefs = RevWalkUtils.findBranchesReachableFrom((RevCommit)c, (RevWalk)rw, allRefs);
                if (existingRefs.isEmpty()) {
                    commits.add(c);
                    continue;
                }
                rw.markUninteresting(c);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return commits;
    }
}

