/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.git.PaGit;
import com.proalpha.pds.gitutils.common.CheckoutOperation;
import com.proalpha.pds.gitutils.external.DbAndBinaryOperation;
import com.proalpha.pds.gitutils.mylyn.ActionResult;
import com.proalpha.pds.gitutils.mylyn.FeatureBranchSettings;
import com.proalpha.pds.gitutils.mylyn.ReconcileActionSettings;
import com.proalpha.pds.paconnector.Activator;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureBranchOperation {
    private final Logger logger = LoggerFactory.getLogger(FeatureBranchOperation.class);
    private FeatureBranchSettings settings;
    private ReconcileActionSettings recoSettings;
    private IProgressMonitor monitor;
    private CheckoutOperation coOp;
    private DbAndBinaryOperation updateDbBinaryOp;

    public FeatureBranchOperation(FeatureBranchSettings settings) {
        this.settings = settings;
        this.recoSettings = new ReconcileActionSettings(this.settings.getCheckoutAction());
        PaGit.init((Git)new Git(settings.getRepository()));
    }

    public FeatureBranchOperation(FeatureBranchSettings settings, ReconcileActionSettings recoSettings) {
        this.settings = settings;
        this.recoSettings = recoSettings;
        PaGit.init((Git)new Git(settings.getRepository()));
    }

    public void execute() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)FeatureBranchOperation.this.monitor, (String)"pA feature branch creation", (int)10);
                    PaGit.getInstance().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)subMonitor.newChild(1)));
                    FeatureBranchOperation.this.coOp = new CheckoutOperation(FeatureBranchOperation.this.settings.getRepository(), "origin", FeatureBranchOperation.this.settings.getSourceBranch(), FeatureBranchOperation.this.settings.getTargetBranch(), FeatureBranchOperation.this.settings.isUpdateSourceBranch(), FeatureBranchOperation.this.settings.isUpdateTargetBranch());
                    FeatureBranchOperation.this.coOp.setProgressMonitor((IProgressMonitor)subMonitor);
                    FeatureBranchOperation.this.coOp.run();
                    subMonitor.worked(1);
                    if (!FeatureBranchOperation.this.recoSettings.getPaUpdateStages().isEmpty()) {
                        this.performReconcileJob(FeatureBranchOperation.this.settings.getRepository(), FeatureBranchOperation.this.recoSettings, (IProgressMonitor)subMonitor);
                    }
                }
                catch (InvocationTargetException e) {
                    FeatureBranchOperation.this.logger.error("An error {0} occured", (Throwable)e);
                }
            }

            public void performReconcileJob(Repository repository, ReconcileActionSettings recoSettings, IProgressMonitor monitor) {
                IProject[] projects = ProjectUtil.getProjects((Repository)repository);
                ArrayList<IProject> openedProjects = new ArrayList<IProject>(Arrays.asList(projects));
                SubMonitor subMonitorArtifacts = SubMonitor.convert((IProgressMonitor)monitor, (String)"database reconcile and artifact update", (int)recoSettings.getPaUpdateStages().size());
                if (recoSettings.isLoadDf()) {
                    Activator.getDefault().getProjectManager().closeProjects(openedProjects, subMonitorArtifacts);
                }
                FeatureBranchOperation.this.updateDbBinaryOp = new DbAndBinaryOperation(repository, recoSettings);
                FeatureBranchOperation.this.updateDbBinaryOp.setProgressMonitor(subMonitorArtifacts);
                FeatureBranchOperation.this.updateDbBinaryOp.execute();
                if (recoSettings.isLoadDf()) {
                    Activator.getDefault().getProjectManager().openProjects(openedProjects, subMonitorArtifacts);
                }
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)r);
    }

    public ISchedulingRule getSchedulingRule() {
        if (this.settings != null) {
            return RuleUtil.getRule((Repository)this.settings.getRepository());
        }
        return null;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public List<ActionResult> getResult() {
        ArrayList<ActionResult> results = new ArrayList<ActionResult>();
        if (this.updateDbBinaryOp != null) {
            results.addAll(this.updateDbBinaryOp.getActionResults());
        }
        if (this.coOp != null) {
            ActionResult checkoutResult = new ActionResult("checkout");
            if (this.coOp.getResult().getStatus() != CheckoutResult.Status.OK) {
                checkoutResult.setStatus("FAIL");
            }
            results.add(0, checkoutResult);
        }
        return results;
    }

    public FeatureBranchSettings getSettings() {
        return this.settings;
    }

    public void setSettings(FeatureBranchSettings settings) {
        this.settings = settings;
    }
}

