/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils;

import com.proalpha.git.model.PaCherryPickResult;
import com.proalpha.pds.gitutils.cherrypick.CherryPick;
import com.proalpha.pds.gitutils.common.Repository;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;

public class GitUtilsPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (property.equals("isConflict")) {
            PaCherryPickResult result = CherryPick.getInstance().getCherryPickResult();
            if (result == null) {
                return false;
            }
            return result.getStatus() == CherryPickResult.CherryPickStatus.CONFLICTING;
        }
        if (property.equals("isMergetoolApplicable") && receiver instanceof RepositoryTreeNode) {
            RepositoryTreeNode node = (RepositoryTreeNode)receiver;
            org.eclipse.jgit.lib.Repository repository = node.getRepository();
            Git git = new Git(repository);
            try {
                Set conflictingFiles = git.status().call().getConflicting();
                Repository.getInstance().setConflictingFiles(new ArrayList<String>(conflictingFiles));
                return !conflictingFiles.isEmpty();
            }
            catch (NoWorkTreeException e) {
                e.printStackTrace();
                return false;
            }
            catch (GitAPIException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (property.equals("isOngoingCherryPick")) {
            if (CherryPick.getInstance().getCherryPickCommand() != null) {
                RepositoryTreeNode node;
                org.eclipse.jgit.lib.Repository repository;
                org.eclipse.jgit.lib.Repository cpRepo = CherryPick.getInstance().getCherryPickCommand().getRepository();
                if (receiver instanceof RepositoryTreeNode && (repository = (node = (RepositoryTreeNode)receiver).getRepository()) != null) {
                    return cpRepo.equals(repository);
                }
            }
            System.out.println("Property tester: " + property + "=" + "false");
            return false;
        }
        if (property.equals("canStartNewCherryPick")) {
            return CherryPick.getInstance().getCherryPickCommand() == null;
        }
        if (property.equals("isConsRepo")) {
            RepositoryTreeNode node;
            org.eclipse.jgit.lib.Repository repository;
            String url;
            return receiver instanceof RepositoryTreeNode && (url = (repository = (node = (RepositoryTreeNode)receiver).getRepository()).getConfig().getString("remote", "origin", "url")).contains("conpr");
        }
        return false;
    }
}

