/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector;

import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.IOpenEdgeProjectListener;
import com.openedge.pdt.project.OEProject;
import com.openedge.pdt.project.OEProjectPlugin;
import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.utils.CheckPythonModules;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaProjectManager {
    private final Logger logger = LoggerFactory.getLogger(PaProjectManager.class);
    private OpenEdgeProjectListener projectListener;
    private List<PaProject> paProjects = new CopyOnWriteArrayList<PaProject>();
    private Boolean pythonVersionChecked = false;

    public List<PaProject> getPaProjects() {
        return this.paProjects;
    }

    public PaProjectManager() {
        this.projectListener = new OpenEdgeProjectListener();
        OEProjectPlugin.getDefault().getProjectManager().addOpenEdgeProjectListener((IOpenEdgeProjectListener)this.projectListener);
        this.checkPythonVersions();
        this.addOpenProjects();
    }

    private void addOpenProjects() {
        List<IProject> projects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        for (IProject project : projects) {
            if (!project.isOpen()) continue;
            OEProject oeProject = (OEProject)OEProjectPlugin.getDefault().getOpenEdgeModel().getOpenEdgeProject(project);
            this.addPaProject((IOpenEdgeProject)oeProject);
        }
    }

    public void addPaProject(IOpenEdgeProject oeProject) {
        if (this.canAddPaProject(oeProject)) {
            PaProject paProject = new PaProject((OEProject)oeProject);
            this.paProjects.add(paProject);
            this.checkPythonVersions();
        }
    }

    public void addPaProject(PaProject paProject) {
        if (this.canAddPaProject((IOpenEdgeProject)paProject.getOeProject())) {
            this.paProjects.add(paProject);
            this.checkPythonVersions();
        }
    }

    private boolean canAddPaProject(IOpenEdgeProject oeProject) {
        try {
            return oeProject.getProject().hasNature("com.proalpha.pds.ui.proalphaNature");
        }
        catch (CoreException e) {
            return false;
        }
    }

    public void removePaProject(IOpenEdgeProject oeProject) {
        this.paProjects.forEach(paProject -> {
            if (paProject.getOeProject().equals((Object)oeProject)) {
                paProject.dispose();
                this.paProjects.remove(paProject);
            }
        });
    }

    public void openProjects(List<IProject> affectedProjects, SubMonitor monitor) {
        for (IProject iProject : affectedProjects) {
            SubMonitor subMonitor = monitor.newChild(1);
            subMonitor.subTask(MessageFormat.format("Opening project {0}", iProject.getName()));
            try {
                try {
                    iProject.open((IProgressMonitor)subMonitor);
                }
                catch (CoreException e) {
                    this.logger.error("Error while opening project {}", (Object)iProject);
                    subMonitor.done();
                    continue;
                }
            }
            catch (Throwable throwable) {
                subMonitor.done();
                throw throwable;
            }
            subMonitor.done();
        }
    }

    public void closeProjects(List<IProject> affectedProjects, SubMonitor monitor) {
        for (IProject iProject : affectedProjects) {
            SubMonitor subMonitor = monitor.newChild(1);
            subMonitor.subTask(MessageFormat.format("Closing project {0}", iProject.getName()));
            try {
                try {
                    iProject.close((IProgressMonitor)subMonitor);
                }
                catch (CoreException e) {
                    this.logger.error("Error while closing project {}", (Object)iProject);
                    subMonitor.done();
                    continue;
                }
            }
            catch (Throwable throwable) {
                subMonitor.done();
                throw throwable;
            }
            subMonitor.done();
        }
    }

    public PaProject getPaProject(IOpenEdgeProject oeProject) {
        for (PaProject paProject : this.paProjects) {
            if (!paProject.getOeProject().equals((Object)oeProject)) continue;
            return paProject;
        }
        return null;
    }

    public PaProject getPaProject(IProject iProject) {
        OEProject oeProject = (OEProject)OEProjectPlugin.getDefault().getOpenEdgeModel().getOpenEdgeProject(iProject);
        for (PaProject paProject : this.paProjects) {
            if (!paProject.getOeProject().equals((Object)oeProject)) continue;
            return paProject;
        }
        return null;
    }

    public PaProject getPaProjectByTextSelection() {
        ISelection selection;
        PaProject paProject = null;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        ISelectionService service = (ISelectionService)activeWorkbenchWindow.getService(ISelectionService.class);
        if (service != null && (selection = service.getSelection()) instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IResource) {
            IProject curProject = ((IResource)((IStructuredSelection)selection).getFirstElement()).getProject();
            paProject = this.getPaProject(curProject);
        }
        if (paProject == null) {
            try {
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                IEditorPart activeEditor = activePage.getActiveEditor();
                IEditorInput curedit = activeEditor.getEditorInput();
                IResource curresource = (IResource)curedit.getAdapter(IResource.class);
                IProject curProject = curresource.getProject();
                paProject = this.getPaProject(curProject);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return paProject;
    }

    public PaProject getPaProjectByProjectExplorer() {
        ISelection sel;
        ISelectionService ss = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        String projExpID = "org.eclipse.ui.navigator.ProjectExplorer";
        Object selectedObject = sel = ss.getSelection(projExpID);
        if (sel instanceof IStructuredSelection) {
            selectedObject = ((IStructuredSelection)sel).getFirstElement();
        }
        if (selectedObject instanceof IAdaptable) {
            IResource res = (IResource)((IAdaptable)selectedObject).getAdapter(IResource.class);
            return this.getPaProject(res.getProject());
        }
        return null;
    }

    public void dispose() {
        if (this.projectListener != null) {
            OEProjectPlugin.getDefault().getProjectManager().removeOpenEdgeProjectListener((IOpenEdgeProjectListener)this.projectListener);
            this.projectListener = null;
        }
    }

    private void checkPythonVersions() {
        if (this.pythonVersionChecked.booleanValue()) {
            return;
        }
        CheckPythonModules pycheck = new CheckPythonModules();
        if (!pycheck.pythonVersionsMatch().booleanValue()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String messagetext = "To use this plugin version of proALPHA higher versions of python modules is needed. To update the python module execute\n\npython -m pip install pa_update --upgrade --upgrade-strategy=eager\n\nin a command line started with admin rights.";
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"python not up to date", (String)"To use this plugin version of proALPHA higher versions of python modules is needed. To update the python module execute\n\npython -m pip install pa_update --upgrade --upgrade-strategy=eager\n\nin a command line started with admin rights.");
                        }
                    });
                }
            }).start();
        }
        this.pythonVersionChecked = true;
    }

    private class OpenEdgeProjectListener
    implements IOpenEdgeProjectListener {
        private OpenEdgeProjectListener() {
        }

        public void projectCreated(IOpenEdgeProject project) {
            PaProjectManager.this.addPaProject(project);
        }

        public void projectDeleted(IOpenEdgeProject project) {
            PaProjectManager.this.removePaProject(project);
        }
    }
}

