/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckPythonModules {
    private final Logger logger = LoggerFactory.getLogger(CheckPythonModules.class);
    HashMap<String, String> pyModuleVersions = new HashMap();

    public CheckPythonModules() {
        this.pyModuleVersions.put("pa-installer", "0.0.27");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap<String, String> getPythonModules() {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        HashMap<String, String> resultLines = new HashMap<String, String>();
        String regex = "([a-zA-Z0-9-]{1,}\\s*)([0-9]{1,4}(\\.[0-9]+){0,3})";
        Pattern pattern = Pattern.compile("([a-zA-Z0-9-]{1,}\\s*)([0-9]{1,4}(\\.[0-9]+){0,3})", 8);
        builder.command("python", "-m", "pip", "list");
        builder.redirectErrorStream(true);
        builder.redirectInput(ProcessBuilder.Redirect.PIPE);
        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        try {
            Process p;
            block17: {
                p = builder.start();
                this.logger.info("query python modules. call '{}'", builder.command());
                Throwable throwable = null;
                Object var7_9 = null;
                try {
                    InputStreamReader rOut = new InputStreamReader(p.getInputStream());
                    try {
                        try (BufferedReader inOut = new BufferedReader(rOut);){
                            String line;
                            do {
                                if ((line = inOut.readLine()) == null) continue;
                                Matcher m = pattern.matcher(line = line.trim());
                                if (m.matches()) {
                                    resultLines.put(m.group(1).trim(), m.group(2).trim());
                                    this.logger.debug("add modulinfo " + line);
                                    continue;
                                }
                                this.logger.debug("skip line " + line);
                            } while (line != null);
                        }
                        if (rOut == null) break block17;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (rOut == null) throw throwable;
                        ((Reader)rOut).close();
                        throw throwable;
                    }
                    ((Reader)rOut).close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            Integer callExitValue = p.waitFor();
            if (callExitValue == 0) return resultLines;
            resultLines.clear();
            return resultLines;
        }
        catch (IOException | InterruptedException e) {
            resultLines.clear();
        }
        return resultLines;
    }

    public Boolean pythonVersionsMatch() {
        Boolean pyVersionsMatch = true;
        HashMap<String, String> currentPythonModules = this.getPythonModules();
        for (String pymodname : this.pyModuleVersions.keySet()) {
            String moduleversion = currentPythonModules.get(pymodname);
            if (moduleversion == null) {
                pyVersionsMatch = false;
            } else {
                String[] neededVersion;
                String[] currentVersion = currentPythonModules.get(pymodname).split("\\.");
                if (currentVersion.length != (neededVersion = this.pyModuleVersions.get(pymodname).split("\\.")).length) {
                    pyVersionsMatch = false;
                } else {
                    Integer i = 0;
                    while (i < currentVersion.length) {
                        Integer current = Integer.parseInt(currentVersion[i]);
                        Integer needed = Integer.parseInt(neededVersion[i]);
                        if (current > needed) break;
                        if (current < needed) {
                            pyVersionsMatch = false;
                        }
                        i = i + 1;
                    }
                }
            }
            this.logger.debug(String.format("module %s got version %s. needed version is %s", pymodname, currentPythonModules.get(pymodname), this.pyModuleVersions.get(pymodname)));
            if (!pyVersionsMatch.booleanValue()) break;
        }
        return pyVersionsMatch;
    }
}

