/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.importwizards;

import com.proalpha.pds.projconf.importwizards.ImportPageOne;
import com.proalpha.pds.projconf.importwizards.ImportProjectJob;
import com.proalpha.pds.projconf.importwizards.ReadDemasFile;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportWizard
extends Wizard
implements IImportWizard {
    private final Logger logger = LoggerFactory.getLogger(ImportWizard.class);
    protected ImportPageOne one;

    public ImportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public String getWindowTitle() {
        return "Import DEMAS Installation";
    }

    public void addPages() {
        this.one = new ImportPageOne();
        this.addPage((IWizardPage)this.one);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Import proALPHA Project");
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        List<String> importProjects = this.one.getProjectFiles();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(importProjects.toString());
        }
        for (String project : importProjects) {
            this.createProjectFromIniFile(project);
        }
        return true;
    }

    private void createProjectFromIniFile(String demasfile) {
        ReadDemasFile propertiesFile = new ReadDemasFile(demasfile);
        if (!propertiesFile.isValidIni()) {
            return;
        }
        ImportProjectJob importProjectJob = new ImportProjectJob(MessageFormat.format("Importing Project {0}", propertiesFile.getFullProjectName()), propertiesFile);
        importProjectJob.setUser(true);
        importProjectJob.schedule();
    }
}

