/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.configure;

import com.openedge.pdt.project.OEProjectPlugin;
import com.openedge.pdt.project.connection.DatabaseConnectionManager;
import com.openedge.pdt.project.connection.DatabaseConnectionProfile;
import com.proalpha.pds.projconf.Activator;
import com.proalpha.pds.projconf.properties.PropertiesManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.sqlexplorer.AliasModel;
import net.sourceforge.sqlexplorer.IdentifierFactory;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConnectionBuilder {
    private final Logger logger = LoggerFactory.getLogger(DatabaseConnectionBuilder.class);
    private final Properties databaseProperties;
    private final String projectVersionIdenifier;
    private final String databaseDirectory;
    private final String dlc;

    public DatabaseConnectionBuilder(String projectVersionIdenifier, String propertiesFile, String databaseDirectory, String dlc) throws IOException {
        this.projectVersionIdenifier = projectVersionIdenifier;
        this.databaseDirectory = databaseDirectory;
        this.dlc = dlc;
        this.databaseProperties = PropertiesManager.getProperties(new File(propertiesFile));
    }

    private void addProfilesToConnectionManager(IProject project, List<DatabaseConnectionProfile> dbConnections) {
        DatabaseConnectionManager databaseConnectionManager = OEProjectPlugin.getDefault().getDatabaseConnectionManager();
        List<DatabaseConnectionProfile> existDBProfils = Arrays.asList(databaseConnectionManager.getDatabaseConnectionProfiles());
        try {
            for (DatabaseConnectionProfile dbProfile : dbConnections) {
                if (existDBProfils.contains(dbProfile)) {
                    databaseConnectionManager.removeDatabaseConnectionProfile(dbProfile.getIdentifier());
                }
                dbProfile.setAutoStartServer(false);
            }
            databaseConnectionManager.addDatabaseConnectionProfile(dbConnections.toArray(new DatabaseConnectionProfile[0]));
        }
        catch (Exception e) {
            Status status = new Status(2, "com.proalpha.pds.projconf", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        if (project.exists()) {
            databaseConnectionManager.writeDBMappingFile(dbConnections, project);
        }
    }

    private String buildUrl(String dbPort, String dbName, String dbHost) {
        return "jdbc:datadirect:openedge://" + dbHost + ":" + dbPort + ";databaseName=" + dbName;
    }

    private DatabaseConnectionProfile createDatabaseConnectionProfile(String logicalName) {
        String physicalName = String.valueOf(this.databaseDirectory) + "\\" + this.databaseProperties.getProperty(String.valueOf(logicalName) + ".dbPhysicalName");
        String connectionName = String.valueOf(this.projectVersionIdenifier) + " " + logicalName;
        String dbPort = this.databaseProperties.getProperty(String.valueOf(logicalName) + ".dbPort");
        String dbHost = this.databaseProperties.getProperty(String.valueOf(logicalName) + ".dbHost");
        String dbUserName = this.databaseProperties.getProperty(String.valueOf(logicalName) + ".dbUserName");
        String dbPassword = this.databaseProperties.getProperty(String.valueOf(logicalName) + ".dbPassword");
        String dbServerParameter = this.databaseProperties.getProperty(String.valueOf(logicalName) + ".dbServerParameter");
        String dbParameters = this.databaseProperties.getProperty(String.valueOf(logicalName) + ".dbParameter");
        String hasSecurity = this.databaseProperties.getProperty(String.valueOf(logicalName) + ".dbHasSecurity");
        String url = this.buildUrl(dbPort, new Path(physicalName).lastSegment(), dbHost);
        ISQLAlias sqlAlias = this.createSQLAlias(connectionName, url, dbUserName, dbPassword);
        DatabaseConnectionProfile dbProfile = new DatabaseConnectionProfile(connectionName);
        dbProfile.setIdentifier(connectionName.replace(' ', '_'));
        dbProfile.setGroup(this.projectVersionIdenifier);
        dbProfile.setPhysicalName(physicalName);
        dbProfile.setLogicalName(logicalName);
        dbProfile.setProVersion(this.identifyProgressVersion());
        if (Boolean.valueOf(hasSecurity).booleanValue()) {
            dbProfile.setUser(dbUserName);
            dbProfile.setPassword(dbPassword);
        }
        if (dbParameters != null) {
            dbProfile.setParameters(dbParameters);
        }
        dbProfile.setHost(dbHost);
        dbProfile.setService(dbPort);
        if (sqlAlias != null) {
            dbProfile.setAsociatedSQLAlias(sqlAlias);
            dbProfile.setSqlIdentifier(sqlAlias.getIdentifier().toString());
            dbProfile.setSqlName(String.valueOf(connectionName) + "_SQL");
            dbProfile.setSqlAliasObject(sqlAlias);
            dbProfile.setAutoStartServer(true);
            dbProfile.setAutoShutdownServer(true);
            dbProfile.setServerParameters("-db " + physicalName + " " + "-S " + dbPort + " " + dbServerParameter);
        }
        return dbProfile;
    }

    private List<DatabaseConnectionProfile> createDatabaseConnectionProfile() {
        ArrayList<DatabaseConnectionProfile> dbProfiles = new ArrayList<DatabaseConnectionProfile>();
        TreeSet<String> databaseNames = new TreeSet<String>();
        databaseNames.addAll(this.getDatabaseNames());
        for (String logicalName : databaseNames) {
            dbProfiles.add(this.createDatabaseConnectionProfile(logicalName));
        }
        return dbProfiles;
    }

    public void createDbConnections(IProject project) {
        List<DatabaseConnectionProfile> dbConnections = this.createDatabaseConnectionProfile();
        this.addProfilesToConnectionManager(project, dbConnections);
    }

    private static void removeSQLAlias(String connectionName) {
        AliasModel aliasModel = SQLExplorerPlugin.getDefault().getAliasModel();
        Object[] objectArray = aliasModel.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object alias = objectArray[n2];
            if (((ISQLAlias)alias).getName().equals(String.valueOf(connectionName) + "_SQL")) {
                aliasModel.removeAlias((ISQLAlias)alias);
                break;
            }
            ++n2;
        }
    }

    public static void removeDatabaseConnections(String groupName) {
        DatabaseConnectionManager manager = OEProjectPlugin.getDefault().getDatabaseConnectionManager();
        try {
            DatabaseConnectionProfile[] databaseConnectionProfiles = manager.getDatabaseConnectionProfiles();
            int i = 0;
            while (i < databaseConnectionProfiles.length) {
                DatabaseConnectionProfile databaseConnectionProfile = databaseConnectionProfiles[i];
                if (databaseConnectionProfile.getGroup().equalsIgnoreCase(groupName)) {
                    String connectionName = databaseConnectionProfile.getName();
                    manager.removeDatabaseConnectionProfile(databaseConnectionProfile.getIdentifier());
                    DatabaseConnectionBuilder.removeSQLAlias(connectionName);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Status status = new Status(1, "com.proalpha.pds.projconf", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    private ISQLAlias createSQLAlias(String connectionName, String url, String userName, String password) {
        IIdentifier identifier = null;
        Boolean isAliasExsits = false;
        ISQLAlias sqlAlias = null;
        AliasModel aliasModel = SQLExplorerPlugin.getDefault().getAliasModel();
        Object[] objectArray = aliasModel.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object alias = objectArray[n2];
            if (((ISQLAlias)alias).getName().equals(String.valueOf(connectionName) + "_SQL")) {
                isAliasExsits = true;
                sqlAlias = (ISQLAlias)alias;
                break;
            }
            ++n2;
        }
        if (!isAliasExsits.booleanValue()) {
            int i = 0;
            while (i < SQLExplorerPlugin.getDefault().getDriverModel().size()) {
                if (SQLExplorerPlugin.getDefault().getDriverModel().getElement(i).getUrl().startsWith("jdbc:datadirect:openedge")) {
                    identifier = SQLExplorerPlugin.getDefault().getDriverModel().getElement(i).getIdentifier();
                    break;
                }
                ++i;
            }
            sqlAlias = aliasModel.createAlias(IdentifierFactory.getInstance().createIdentifier());
            try {
                sqlAlias.setName(String.valueOf(connectionName) + "_SQL");
                sqlAlias.setDriverIdentifier(identifier);
                sqlAlias.setUrl(url.trim());
                sqlAlias.setUserName(userName);
                sqlAlias.setPassword(password);
                sqlAlias.setAutoLogon(true);
                SQLExplorerPlugin.getDefault().getAliasModel().addAlias(sqlAlias);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                sqlAlias = null;
            }
        }
        return sqlAlias;
    }

    private Set<String> getDatabaseNames() {
        TreeSet<String> databaseNames = new TreeSet<String>();
        Enumeration<?> propertyNames = this.databaseProperties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            databaseNames.add(propertyName.substring(0, propertyName.indexOf(46)));
        }
        return databaseNames;
    }

    private String identifyProgressVersion() {
        String progressVersion = "";
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(new File(new Path(this.dlc).append("version").toString())));){
                String line = br.readLine();
                if (line != null) {
                    progressVersion = line.substring(17, 22);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error("Couldn't find version file in dlc dir", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("IOException occured during search of progress version", (Throwable)e);
        }
        return progressVersion;
    }
}

