/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.importwizards;

import com.proalpha.pds.projconf.importwizards.ImportPageOne;
import com.proalpha.pds.projconf.importwizards.ImportProjectJob;
import com.proalpha.pds.projconf.utils.DemasFile;
import com.proalpha.pds.projconf.utils.Project;
import com.proalpha.pds.projconf.utils.ProjectWarningsPopup;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportWizard
extends Wizard
implements IImportWizard {
    private final Logger logger = LoggerFactory.getLogger(ImportWizard.class);
    protected ImportPageOne one;

    public ImportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public String getWindowTitle() {
        return "Import DEMAS Installation";
    }

    public void addPages() {
        this.one = new ImportPageOne();
        this.addPage((IWizardPage)this.one);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Import proALPHA Project");
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        List<Project> projects = this.one.getSelectedProjects();
        if (!ProjectWarningsPopup.sync(projects)) {
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(projects.toString());
        }
        for (Project project : projects) {
            this.createProject(project);
        }
        return true;
    }

    private void createProject(Project project) {
        DemasFile propertiesFile = project.demasFile();
        ImportProjectJob importProjectJob = new ImportProjectJob(MessageFormat.format("Importing Project {0}", propertiesFile.getFullProjectName()), propertiesFile);
        importProjectJob.setUser(true);
        importProjectJob.schedule();
    }
}

