/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.generator;

import com.proalpha.pds.generator.ContentGenerator;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerFileGenerator {
    private final Logger logger = LoggerFactory.getLogger(TriggerFileGenerator.class);
    private static final String TRIGGER_MODE_CREATE = "Create";
    private static final String TRIGGER_MODE_DELETE = "Delete";
    private static final String TRIGGER_MODE_WRITE = "Write";
    private static final String TEMPLATE_GENERATOR_CREATE_TRIGGER = "pACreateTrigger";
    private static final String TEMPLATE_GENERATOR_DELETE_TRIGGER = "pADeleteTrigger";
    private static final String TEMPLATE_GENERATOR_WRITE_TRIGGER = "pAWriteTrigger";
    private final IGeneratorDataContainer dataContainer;

    public TriggerFileGenerator(IGeneratorDataContainer dataContainer) {
        this.dataContainer = dataContainer;
        this.initializeGenerator();
    }

    private void initializeGenerator() {
        try {
            this.dataContainer.setDescription(this.dataContainer.getRepositoryInformations().getProgramShortDesc(this.dataContainer.getFileName()));
            String tableName = this.dataContainer.getTableName();
            String listOfFieldNames = this.dataContainer.getRepositoryInformations().getListOfTableFields(tableName);
            Boolean isObjectID = listOfFieldNames.toLowerCase().contains(tableName.concat("_Obj").toLowerCase());
            this.dataContainer.setIsObjectID(isObjectID);
            Boolean hasCompany = listOfFieldNames.toLowerCase().contains("firma");
            this.dataContainer.setHasCompanyField(hasCompany);
            if (hasCompany.booleanValue()) {
                this.dataContainer.setCompanyInclude(this.dataContainer.getRepositoryInformations().getTableCompanyInclude(tableName));
            }
            this.dataContainer.setHasClassicLngTable(this.dataContainer.getRepositoryInformations().exitsTableInRepository(tableName.concat("Spr")));
            this.dataContainer.setHasChangeLogGerman(listOfFieldNames.toLowerCase().contains("anlagebenutzer"));
            this.dataContainer.setHasChangeLogEnglish(listOfFieldNames.toLowerCase().contains("createdby"));
        }
        catch (Exception e) {
            this.logger.debug("Error during initializing Triggergenerator: {}", (Object)e.getMessage());
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Unable to initialize Template", (String)e.getMessage());
        }
    }

    public void generate() throws Exception {
        String triggerMode = this.dataContainer.getTriggerMode();
        String templateGeneratorName = "";
        if (triggerMode.contains(TRIGGER_MODE_WRITE)) {
            templateGeneratorName = TEMPLATE_GENERATOR_WRITE_TRIGGER;
        } else if (triggerMode.contains(TRIGGER_MODE_DELETE)) {
            templateGeneratorName = TEMPLATE_GENERATOR_DELETE_TRIGGER;
        } else if (triggerMode.contains(TRIGGER_MODE_CREATE)) {
            templateGeneratorName = TEMPLATE_GENERATOR_CREATE_TRIGGER;
        }
        new ContentGenerator("Trigger Generator", this.dataContainer, templateGeneratorName).schedule();
    }
}

